<?php



//

// Set a unique slug-like ID

$prefix = 'towngov_meta_service';



//

// Create a metabox

CSF::createMetabox( $prefix, array(

	'title'      	=> 'Towngov Service Setting',

	'icon'       	=> 'el el-cogs',

	'position'   	=> 'normal',

	'priority'   	=> 'core',

	'post_type' 	=> array( 'service' ),

	'show_restore'       => false,

	'context'            => 'advanced',

	'nav'                => 'normal',

	'theme'              => 'dark',

	'class'              => '',

) );



//

// Create a section

CSF::createSection($prefix, array(

	'fields' => array(

		array(

			'id'       => 'service_icon',

			'type'     => 'select',

			'title'    => esc_html__( 'Service Icons', 'towngov' ),

			'options'  => get_fontawesome_icons(),

		),

		array(

			'id'    => 'service_feature_list_title',

			'type'  => 'text',

			'default' => esc_html__( 'Goverment Jobs Fecilities:', 'towngov' ),

			'title' => esc_html__( 'Enter Features Title', 'towngov' ),

		),

		array(

			'id'    => 'service_feature_list',

			'type'  => 'textarea',

			'title' => esc_html__( 'Enter Features List', 'towngov' ),

		),

		//Features Box

		array(

			'id' => 'show_feature_box',

			'type' => 'switcher',

			'title' => esc_html__('Show/Hide Features Box Info', 'towngov'),

			'desc' => esc_html__('Enable to Show Features Box Info', 'towngov'),

			'default'  => false,

		),

		array(

			'id'    => 'servce_features',

			'type'  => 'group',

			'dependency' => array('show_feature_box', '==', true),			

			'title' => esc_html__( 'Features Box Info', 'towngov' ),

			'fields'	=> array(

				array(

					'id'       => 'feature_icon',

					'type'     => 'select',

					'title'    => esc_html__( 'Features Box Icons', 'towngov' ),

					'options'  => get_fontawesome_icons(),

				),

				array(

					'id'    => 'service_feature_title',

					'type'  => 'text',

					'title' => esc_html__( 'Features Box Title', 'towngov' ),

					'default' => esc_html__( 'Proin Tempus', 'towngov' ),

					'desc'  => esc_html__( 'Enter the Features Box Title', 'towngov' ),

				),

				array(

					'id'    => 'service_feature_description',

					'type'  => 'textarea',

					'title' => esc_html__( 'Description', 'towngov' ),

					'desc'  => esc_html__( 'Enter the Description', 'towngov' ),

				),

				array(

					'id'    => 'service_feature_box_url',

					'type'  => 'text',

					'title' => esc_html__( 'External Url', 'towngov' ),

					'desc'  => esc_html__( 'Enter the External Url', 'towngov' ),

				),

			),

		),

		array(

			'id'    => 'service_bottom_content',

			'type'  => 'textarea',

			'title' => esc_html__( 'Enter Bottom Description', 'towngov' ),

		),

	)

));