<?php
//
// Set a unique slug-like ID
$prefix = 'towngov_meta_projects';
//
// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'      	=> 'Towngov Project Setting',
	'icon'       	=> 'el el-cogs',
	'position'   	=> 'normal',
	'priority'   	=> 'core',
	'post_type' 	=> array( 'project' ),
	'show_restore'       => false,
	'context'            => 'advanced',
	'nav'                => 'normal',
	'theme'              => 'dark',
	'class'              => '',
) );
//
// Create a section
CSF::createSection($prefix, array(
	'fields' => array(
		
		array(
		  'id'          => 'layout_style',
		  'type'        => 'select',
		  'title'       => esc_html__( 'Choose Layout Style', 'towngov' ),
		  'placeholder' => esc_html__( 'Choose Style', 'towngov' ),
		  'options'     => array(
			'one'  => esc_html__( 'Style One', 'towngov' ),
			'two'  => esc_html__( 'Style Two', 'towngov' ),
		  ),
		  'default'     => 'one'
		),
		array(
			'id'    => 'project_cat_title',
			'type'  => 'text',
			'title' => esc_html__( 'Category Title', 'towngov' ),
		),
		array(
			'id'    => 'project_title',
			'type'  => 'text',
			'title' => esc_html__( 'Project Title', 'towngov' ),
		),
		array(
			'id'    => 'project_name',
			'type'  => 'text',
			'title' => esc_html__( 'Project Name', 'towngov' ),
		),
		array(
			'id'    => 'project_date_title',
			'type'  => 'text',
			'title' => esc_html__( 'Date Title', 'towngov' ),
		),
		array(
			'id'    => 'project_date',
			'type'  => 'text',
			'title' => esc_html__( 'Project Date', 'towngov' ),
		),
		array(
			'id'    => 'project_address_title',
			'type'  => 'text',
			'title' => esc_html__( 'Address Title', 'towngov' ),
		),
		array(
			'id'    => 'project_address',
			'type'  => 'text',
			'title' => esc_html__( 'Address', 'towngov' ),
		),
		array(
			'id'    => 'social_profile2',
			'type'  => 'group',
			'title' => esc_html__( 'Social Profiles', 'towngov' ),
			'fields'	=> array(
				array(
					'id'    => 'url',
					'type'  => 'text',
					'title' => esc_html__( 'URL', 'towngov' ),
				),
				array(
					'id'    => 'icon',
					'type'  => 'icon',
					'title' => esc_html__( 'Icon', 'towngov' ),
				),
				array(
					'id'    => 'background',
					'type'  => 'color',
					'title' => esc_html__( 'Background Color', 'towngov' ),
				),
				array(
					'id'    => 'color',
					'type'  => 'color',
					'title' => esc_html__( 'Color', 'towngov' ),
				),
			)
		),
		//Recent Project Section
		array(
			'id' => 'show_recent_project',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Recent Projects Section', 'towngov'),
			'desc' => esc_html__('Enable to Show Recent Projects Section', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'recent_project_sub_title',
			'type'  => 'text',
			'title' => esc_html__( 'Recent Projects Sub Title', 'towngov' ),
			'default' => esc_html__( 'recent work portfolio', 'towngov' ),
			'dependency' => array('show_recent_project', '==', true),
		),
		array(
			'id'    => 'recent_project_title',
			'type'  => 'text',
			'title' => esc_html__( 'Recent Projects Title', 'towngov' ),
			'default' => esc_html__( 'Explore City Highlights <br>Portfolios', 'towngov' ),
			'dependency' => array('show_recent_project', '==', true),
		),
		array(
			'id'    => 'query_number',
			'type'  => 'text',
			'title' => esc_html__( 'Recent Number of Posts', 'towngov' ),
			'default' => esc_html__( '5', 'towngov' ),
			'dependency' => array('show_recent_project', '==', true),
		),
		array(
			'id'    => 'query_category',
			'type'  => 'select',
			'title' => esc_html__( 'Category', 'towngov' ),			
			'dependency' => array('show_recent_project', '==', true),
			'options' => get_project_categories()
		),
	)
));
