<?php

//

// Create a section

CSF::createSection($prefix, array(

	'title'  => esc_html__("Towngov Header Settings", "konia"),

	'fields' => array(

		array(

			'id'      => 'header_source_type',

			'type'    => 'button_set',

			'title'   => esc_html__('Header Source Type', 'towngov'),

			'options' => array(

				'd' => esc_html__('Default', 'towngov'),

				'e' => esc_html__('Elementor', 'towngov'),

			),

			'default' => '',

		),

		array(

			'id'       => 'header_new_elementor_template',

			'type'     => 'select',

			'title'    => __('Template', 'towngov-plugin'),

			'options'     => 'posts',

			'query_args'     => [

				'post_type' => ['elementor_library'],

				'posts_per_page' => -1,

				'orderby'  => 'title',

				'order'     => 'DESC'

			],

			'dependency' => ['header_source_type', '==', 'e'],

		),

		array(

			'id'       => 'header_style_settings',

			'type'     => 'image_select',

			'title'    => esc_html__('Choose Header Styles', 'towngov'),

			'options'  => array(

				'header_v1' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',

				'header_v2' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',

			),

			'dependency' => array(array('header_source_type', '==', 'd')),

		),

	)

));

