<?php

//
// Set a unique slug-like ID
$prefix = 'towngov_meta_department';

//
// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'      	=> 'Towngov Department Setting',
	'icon'       	=> 'el el-cogs',
	'position'   	=> 'normal',
	'priority'   	=> 'core',
	'post_type' 	=> array( 'department' ),
	'show_restore'       => false,
	'context'            => 'advanced',
	'nav'                => 'normal',
	'theme'              => 'dark',
	'class'              => '',
) );

//
// Create a section
CSF::createSection($prefix, array(
	'fields' => array(
		array(
			'id'       => 'department_icon',
			'type'     => 'select',
			'title'    => esc_html__( 'Department Icons', 'towngov' ),
			'options'  => get_fontawesome_icons(),
		),
		//Features Box
		array(
			'id' => 'show_feature_box2',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Features Box Info', 'towngov'),
			'desc' => esc_html__('Enable to Show Features Box Info', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'department_law_title',
			'type'  => 'text',
			'title' => esc_html__( 'Enter Law Title', 'towngov' ),
			'dependency' => array('show_feature_box2', '==', true),	
		),
		array(
			'id'    => 'department_law_description',
			'type'  => 'textarea',
			'title' => esc_html__( 'Enter Law Description', 'towngov' ),
			'dependency' => array('show_feature_box2', '==', true),	
		),
		array(
			'id'    => 'department_features',
			'type'  => 'group',
			'dependency' => array('show_feature_box2', '==', true),			
			'title' => esc_html__( 'Features Box Info', 'towngov' ),
			'fields'	=> array(
				array(
					'id'       => 'feature_icon2',
					'type'     => 'select',
					'title'    => esc_html__( 'Features Box Icons', 'towngov' ),
					'options'  => get_fontawesome_icons(),
				),
				array(
					'id'    => 'feature_box_title',
					'type'  => 'text',
					'title' => esc_html__( 'Features Box Title', 'towngov' ),
					'default' => esc_html__( 'Education & Skills', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Features Box Title', 'towngov' ),
				),
				array(
					'id'    => 'feature_box_description',
					'type'  => 'textarea',
					'title' => esc_html__( 'Description', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Description', 'towngov' ),
				),
				array(
					'id'    => 'feature_box_url',
					'type'  => 'text',
					'title' => esc_html__( 'External Url', 'towngov' ),
					'desc'  => esc_html__( 'Enter the External Url', 'towngov' ),
				),
			),
		),
		//Faqs Section
		array(
			'id' => 'show_faqs_section',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Faqs Section Info', 'towngov'),
			'desc' => esc_html__('Enable to Show Faqs Section Info', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'department_faq',
			'type'  => 'group',
			'dependency' => array('show_faqs_section', '==', true),			
			'title' => esc_html__( 'Faqs Section Info', 'towngov' ),
			'fields'	=> array(
				array(
					'id'    => 'faqs_section_title',
					'type'  => 'text',
					'title' => esc_html__( 'Faqs Title', 'towngov' ),
					'default' => esc_html__( 'What material are used for house building?', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Faqs Title', 'towngov' ),
				),
				array(
					'id'    => 'faqs_section_description',
					'type'  => 'textarea',
					'title' => esc_html__( 'Faqs Description', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Faqs Description', 'towngov' ),
				),
			),
		),
	)
));