<?php
namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Testimonials extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	 
	public function get_name() {
		return 'towngov_testimonials';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Towngov Testimonials ', 'towngov' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-testimonial town';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'towngov' ];
	}
	
	public function get_script_depends() {
		wp_register_script( 'testimonials-carousel', YT_URL . 'assets/js/testimonial-carousel.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'testimonials-carousel' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'testimonials',
			[
				'label' => esc_html__( 'Towngov Testimonials ', 'towngov' ),
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'towngov' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial-1.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial-2.png'
					],
					'three' => [
						'label' => esc_html__('Layout 2', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/testimonials/testimonial-1.png'
					],
				],
			]
		);
		$this->add_control(
			'shape_image',
			[
			  	'label' => __( 'Shape Image', 'towngov' ),
			  	'type' => Controls_Manager::MEDIA,
				'condition' => [
					'layout_control' => 'two',
				],
			  	'label_block' => true,				
			  	'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		
		$this->add_control(
			'image',
			[
			  	'label' => __( 'Image', 'towngov' ),
			  	'type' => Controls_Manager::MEDIA,
			  	'label_block' => true,				
			  	'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'sub_title',			
			[
				'label'       => __( 'Sub Title', 'elementor' ),				
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,				
				'dynamic'     => [				
					'active' => true,
				],				
				'placeholder' => __( 'Enter your sub title', 'elementor' ),
			]
		);
		$this->add_control(
			'title',			
			[
				'label'       => __( 'Title', 'elementor' ),				
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,				
				'dynamic'     => [				
					'active' => true,
				],
				'condition' => [
					'layout_control' => 'two',
				],		
				'placeholder' => __( 'Enter your title', 'elementor' ),
			]
		);
		$this->add_control(
			'text',			
			[
				'label'       => __( 'Content', 'elementor' ),				
				'type'        => Controls_Manager::TEXTAREA,			
				'dynamic'     => [				
					'active' => true,
				],
				'condition' => [
					'layout_control' => 'two',
				],		
				'placeholder' => __( 'Enter your Content', 'elementor' ),
			]
		);
		$this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'greenture' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'towngov' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'towngov' ),
					'title'      => esc_html__( 'Title', 'towngov' ),
					'menu_order' => esc_html__( 'Menu Order', 'towngov' ),
					'rand'       => esc_html__( 'Random', 'towngov' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'towngov' ),
					'ASC'  => esc_html__( 'ASC', 'towngov' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'towngov'),
			  'label_block' => true,
			  'options' => get_testimonials_categories()
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub Title Style**/
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .testimonial-name,
								 .section-tagline',                 
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .section-tagline' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-name' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_line_color',
            [
                'label' => __('Line Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .section-tagline:before' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .section-title',                 
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .section-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Content Style**/
		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__('CONTENT STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .section-title-box p',                 
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .section-title-box p' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Loop Style**/
		$this->start_controls_section(
			'loop_style',
			[
				'label' => esc_html__('LOOP CONTENT STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);		
		//Title Style
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_title_typography',
                'label' => __('Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .testimonial-thumb-card h5,
								 .testimonial-two-card-outer-title h5',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-thumb-card h5' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-two-card-outer-title h5' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Title Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-thumb-card h5:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-two-card-outer-title h5:hover' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		//Designation Style
		$this->add_control(
			'show_loop_content2_style',
			[
				'label'       => __( 'ON/OFF  Designation Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_desig_typography',
                'label' => __('Designation Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .testimonial-thumb-card span,
								 .testimonial-two-card-outer-title span',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_content2_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_desig_color',
            [
                'label' => __('Designation Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-thumb-card span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-two-card-outer-title span' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content2_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_border_color',
            [
                'label' => __('Border Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-two-card-content' => 'border-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content2_style'    => 'yes',
				]
            ]
        );
		//Icon Style
		$this->add_control(
			'show_icon_style',
			[
				'label'       => __( 'ON/OFF  Icon Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_icon_bgcolor',
            [
                'label' => __('Icon Background Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-two-card-outer-icon' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_icon_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_icon_color',
            [
                'label' => __('Icon Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-two-card-outer-icon i' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_icon_style'    => 'yes',
				]
            ]
        );
		//Content Style
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_content_typography',
                'label' => __('Content Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .testimonial-reviews .testimonial-text,
								 .testimonial-two-card-text p',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_content_color',
            [
                'label' => __('Content Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-reviews .testimonial-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-two-card-text p' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		//Image Border Style
		$this->add_control(
			'show_image_border_style',
			[
				'label'       => __( 'ON/OFF  Image Border Color Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_image_border_color',
            [
                'label' => __('Image Border Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-thumb img' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .author-thumb-image' => 'border-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_image_border_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_image_border_active_color',
            [
                'label' => __('Image Border Active Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-thumb .swiper-slide-thumb-active img' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .author-thumb-carousel .swiper-slide-thumb-active .author-thumb-image' => 'border-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_image_border_style'    => 'yes',
				]
            ]
        );
		//Rating Style
		$this->add_control(
			'show_loop_rating_style',
			[
				'label'       => __( 'ON/OFF Rating Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_rating_bgcolor',
            [
                'label' => __('Rating Background Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-reviews .testimonial-ratings' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_rating_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_rating_color',
            [
                'label' => __('Rating Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-reviews .testimonial-ratings' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_rating_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');		
        $paged = towngov_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-towngov' );
		
		$args = array(
			'post_type'      => 'testimonials',
			'posts_per_page' => towngov_set( $settings, 'query_number' ),
			'orderby'        => towngov_set( $settings, 'query_orderby' ),
			'order'          => towngov_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( towngov_set( $settings, 'query_category' ) ) $args['testimonials_cat'] = towngov_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		if ( $query->have_posts() ) 
		{ 
	?>
  	<?php if($settings['layout_control'] == 'two') : ?>
    <section class="testimonial-two-section">
        <div class="testimonial-two-inner" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['shape_image']['id'])); ?>)">
            <div class="container">
                <div class="row">
                    <div class="col-12 col-lg-4 col-xl-4">
                        <?php if($settings['sub_title'] || $settings['title'] || $settings['text']){ ?>
                        <div class="testimonial-two-content">
                            <div class="section-title-box">
                                <?php if($settings['sub_title']){ ?><div class="section-tagline"><?php echo wp_kses($settings['sub_title'], true);?></div><!-- section-tagline --><?php } ?>
                                <?php if($settings['title']){ ?><h2 class="section-title"><?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
                                <?php if($settings['text']){ ?><p><?php echo wp_kses($settings['text'], true);?></p><?php } ?>
                            </div><!--section-title-box-->
                        </div><!--testimonial-two-content-->
                        <?php } ?>
                        <div class="testimonial-author-thumb">
                            <div class="swiper author-thumb-carousel">
                                <div class="swiper-wrapper">
                                    <?php 
										while ( $query->have_posts() ) : $query->the_post();
									?>
                                    <?php $towngov_testimonials_meta = get_post_meta( get_the_ID(), 'towngov_meta_testimonials', true );?>
                                    <div class="swiper-slide">
                                        <div class="author-thumb-image">
                                            <div class="img-fluid"><?php the_post_thumbnail('towngov_91x91'); ?></div>
                                        </div><!-- author-thumb-image -->
                                    </div><!--swiper-slide-->
                                    <?php endwhile; ?>
                                </div><!-- swiper-wrapper -->
                            </div><!--client-carousel owl-carousel owl-theme-->
                        </div><!--testimonial-author-thumb-->
                    </div><!--col-lg-4-->
                    <div class="col-lg-5">
                        <div class="testimonial-author-review">
                            <div class="swiper author-review-carousel">
                                <div class="swiper-wrapper">
                                    <?php 
										while ( $query->have_posts() ) : $query->the_post();
									?>
                                    <?php $towngov_testimonials_meta = get_post_meta( get_the_ID(), 'towngov_meta_testimonials', true );?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-two-card">
                                            <div class="testimonial-two-card-content">
                                                <div class="testimonial-two-card-text">
                                                    <p><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></p>
                                                </div><!-- testimonial-two-card-text -->
                                                <div class="testimonial-two-card-outer">
                                                    <div class="testimonial-two-card-outer-title">
                                                        <h5><?php the_title(); ?></h5>
                                                    </div><!-- testimonial-two-card-outer-title -->
                                                    <div class="testimonial-two-card-outer-title">
                                                        <span> <?php echo wp_kses($towngov_testimonials_meta['test_designation'], true ); ?></span>
                                                    </div><!-- testimonial-two-card-outer-title -->
                                                </div><!-- testimonial-two-card-outer -->
                                                <div class="testimonial-two-card-outer-icon">
                                                    <i class="flaticon-quote"></i>
                                                </div><!-- testimonial-two-card-outer-icon -->
                                            </div><!-- testimonial-two-card-content -->
                                        </div><!--testimonial-two-card-->
                                    </div><!--swiper-slide-->
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if($settings['image']){ ?>
                    <div class="col-lg-3">
                        <div class="testimonial-two-img">
                            <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'towngov'); ?>">
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    
    <?php elseif($settings['layout_control'] == 'three') : ?>
    
    <section class="testimonial-section testimonial-box-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>)">		
		<div class="container">
			<?php if($settings['sub_title']){ ?><div class="testimonial-name"><?php echo wp_kses($settings['sub_title'], true);?></div><?php } ?>
            <div class="testimonial-slider">
                <div class="swiper testimonial-reviews">
                    <div class="swiper-wrapper">
                        <?php 
                            while ( $query->have_posts() ) : $query->the_post();
                        ?>
                        <?php $towngov_testimonials_meta = get_post_meta( get_the_ID(), 'towngov_meta_testimonials', true );?>
                        <div class="swiper-slide">
                            <div class="testimonial-content">
                                <div class="testimonial-ratings">
                                    <?php $rating = wp_kses( $towngov_testimonials_meta['testimonial_rating'], true );
                                        if(!empty($rating)){
                                        for ($x = 1; $x <= 5; $x++) {
                                            if($x <= $rating) echo '<i class="fa-solid fa-star"></i>'; else echo '<i class="fa-solid fa-star-o"></i>';
                                        }
                                    } ?>
                                </div>
                                <div class="testimonial-text"><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></div>
                                <div class="testimonial-thumb-card">
                                    <h5><?php the_title(); ?></h5>
                                    <span><?php echo wp_kses($towngov_testimonials_meta['test_designation'], true ); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <div class="testimonial-thumb">
                    <div class="swiper-wrapper">
                        <?php 
                            while ( $query->have_posts() ) : $query->the_post();
                        ?>
                        <?php $towngov_testimonials_meta = get_post_meta( get_the_ID(), 'towngov_meta_testimonials', true );?>
                        <div class="swiper-slide">
                            <div class="img-fluid"><?php the_post_thumbnail('towngov_91x91'); ?></div>
                            <i class="fa-solid fa-quote-left"></i>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>		
	</section>
    
    
    <?php else: ?>
    <section class="testimonial-section" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>)">		
		<div class="container">
			<?php if($settings['sub_title']){ ?><div class="testimonial-name"><?php echo wp_kses($settings['sub_title'], true);?></div><?php } ?>
            <div class="testimonial-slider">
                <div class="swiper testimonial-reviews">
                    <div class="swiper-wrapper">
                        <?php 
                            while ( $query->have_posts() ) : $query->the_post();
                        ?>
                        <?php $towngov_testimonials_meta = get_post_meta( get_the_ID(), 'towngov_meta_testimonials', true );?>
                        <div class="swiper-slide">
                            <div class="testimonial-content">
                                <div class="testimonial-ratings">
                                    <?php $rating = wp_kses( $towngov_testimonials_meta['testimonial_rating'], true );
                                        if(!empty($rating)){
                                        for ($x = 1; $x <= 5; $x++) {
                                            if($x <= $rating) echo '<i class="fa-solid fa-star"></i>'; else echo '<i class="fa-solid fa-star-o"></i>';
                                        }
                                    } ?>
                                </div>
                                <div class="testimonial-text"><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></div>
                                <div class="testimonial-thumb-card">
                                    <h5><?php the_title(); ?></h5>
                                    <span><?php echo wp_kses($towngov_testimonials_meta['test_designation'], true ); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <div class="testimonial-thumb">
                    <div class="swiper-wrapper">
                        <?php 
                            while ( $query->have_posts() ) : $query->the_post();
                        ?>
                        <?php $towngov_testimonials_meta = get_post_meta( get_the_ID(), 'towngov_meta_testimonials', true );?>
                        <div class="swiper-slide">
                            <div class="img-fluid"><?php the_post_thumbnail('towngov_91x91'); ?></div>
                            <i class="fa-solid fa-quote-left"></i>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>		
	</section>
    <?php endif; ?>                  
    
      <?php }
		wp_reset_postdata();
	}
}