<?php
namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Blog extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'towngov_our_blog';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Blog', 'towngov' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open town';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'towngov' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_blog',
			[
				'label' => esc_html__( 'General', 'towngov' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'towngov' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/blog/blog-1.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/blog/blog-2.png'
					],
				],
			]
		);	
		
		$this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'towngov' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 8,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'towngov' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'towngov' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'towngov' ),
                    'title'      => esc_html__( 'Title', 'towngov' ),
                    'menu_order' => esc_html__( 'Menu Order', 'towngov' ),
                    'rand'       => esc_html__( 'Random', 'towngov' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'towngov' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'towngov' ),
                    'ASC'  => esc_html__( 'ASC', 'towngov' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'towngov'),
				'label_block' => true,
                'options' => get_blog_categories(),
            ]
        );	
		$this->end_controls_section();
		
		/**Grid Setting Start**/
		$this->start_controls_section(
			'grid',
			[
				'label' => esc_html__( 'Grid Setting', 'towngov' ),	
				'tab' => Controls_Manager::TAB_LAYOUT,		
			]
		);
		$this->add_control(
			'col_grid',
			[
				'label'   => esc_html__( 'Choose Column', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'three',
				'options' => array(
					'one' => esc_html__( 'One Column Grid ', 'towngov'),
					'two'  => esc_html__( 'Two Column Grid', 'towngov' ),
					'three'  => esc_html__( 'Three Column Grid', 'towngov' ),
					'four'  => esc_html__( 'Four Column Grid', 'towngov' ),
					'five'  => esc_html__( 'Six Column Grid', 'towngov' ),
				),				
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Loop Style**/
		$this->start_controls_section(
			'loop_style',
			[
				'label' => esc_html__('LOOP CONTENT STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		//Date Box Style
		$this->add_control(
			'show_loop_date_style',
			[
				'label'       => __( 'ON/OFF  Date Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_date_bgcolor',
            [
                'label' => __('Date Background Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-date' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_date_style'    => 'yes',
				]
            ]
        );
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_date_typography',
                'label' => __('Date Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .blog-card-date',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_date_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_date_color',
            [
                'label' => __('Date Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-date a' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_date_style'    => 'yes',
				]
            ]
        );
		//Meta List Style
		$this->add_control(
			'show_loop_meta_style',
			[
				'label'       => __( 'ON/OFF  Meta List Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
            'loop_loop_bgcolor',
            [
                'label' => __('Meta Background Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-meta' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_meta_typography',
                'label' => __('Meta List Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .blog-card-meta',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_meta_color',
            [
                'label' => __('Meta List Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-meta span a' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_meta_hover_color',
            [
                'label' => __('Meta List Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-meta span a:hover' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_meta_style'    => 'yes',
				]
            ]
        );
		//Category Style
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF  Content Background Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
            'loop_content_bgcolor',
            [
                'label' => __('Content Background Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		//Title Style
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_title_typography',
                'label' => __('Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .blog-card-content h4',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-content h4' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Title Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-content h4 > a:hover' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		//Content Style
		$this->add_control(
			'show_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Content Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .blog-card-content p',                 
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'content_color',
            [
                'label' => __('Content Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-card-content p' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_content_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
    }
    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$grid_col = $settings['col_grid'];
		
        $paged = towngov_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-towngov' );
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => towngov_set( $settings, 'query_number' ),
            'orderby'        => towngov_set( $settings, 'query_orderby' ),
            'order'          => towngov_set( $settings, 'query_order' ),
            'paged'         => $paged
        );
        if( towngov_set( $settings, 'query_category' ) ) $args['category_name'] = towngov_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
		
        if ( $query->have_posts() ) { 
	?>
	
    <?php if($settings['layout_control'] == 'two') : ?>
    <section class="blog-section blog-section-two p-0 m-0">		
        <div class="row row-gutter-y-155">
            <?php 
				while ( $query->have_posts() ) : $query->the_post();
				
				if( $grid_col == 'one' ){
					$classes = 'col-lg-12 col-xl-12';
				}elseif( $grid_col == 'three' ){
					$classes = 'col-lg-4 col-xl-4';
				}elseif( $grid_col == 'four' ){
					$classes = 'col-lg-3 col-xl-4';
				}elseif( $grid_col == 'five' ){
					$classes = 'col-lg-2 col-xl-4';
				}else{
					$classes = 'col-lg-6 col-xl-4';
				} 
			?>
            <div class="<?php echo esc_attr( $classes );?>">
                <div class="blog-card">
                    <div class="blog-card-image">
                        <div class="img-fluid"><?php the_post_thumbnail('towngov_465x375'); ?></div>
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"></a>
                    </div><!-- blog-card-image -->
                    <div class="blog-card-date">
                        <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><?php echo get_the_date('d'); ?><?php echo get_the_date('M'); ?></a>
                    </div><!-- blog-card-date -->
                    <div class="blog-card-content">
                        <div class="blog-card-meta">
                            <span class="author">
                                <?php esc_html_e('by', 'towngov'); ?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><?php the_author(); ?></a>
                            </span><!-- author -->
                            <span class="comment">
                                <a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><?php comments_number( wp_kses(__('0 Comments' , 'towngov'), true), wp_kses(__('01 Comment' , 'towngov'), true), wp_kses(__('0% Comments' , 'towngov'), true)); ?></a>
                            </span><!-- comment -->	
                        </div><!-- blog-card-meta -->
                        <h4><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
                        <p><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></p>
                    </div><!-- blog-card-content -->
                </div><!-- blog-card -->	
            </div><!-- col-lg-6 col-xl-4 -->
            <?php endwhile; ?>
        </div><!-- row -->		
	</section><!--blog-section-->
    
    <?php else: ?>
    
    <section class="blog-section p-0 m-0">		
        <div class="row row-gutter-y-155">
            <?php 
				while ( $query->have_posts() ) : $query->the_post();
				
				if( $grid_col == 'one' ){
					$classes = 'col-lg-12 col-xl-12';
				}elseif( $grid_col == 'two' ){
					$classes = 'col-lg-6 col-xl-4';
				}elseif( $grid_col == 'four' ){
					$classes = 'col-lg-3 col-xl-4';
				}elseif( $grid_col == 'five' ){
					$classes = 'col-lg-2 col-xl-4';
				}else{
					$classes = 'col-lg-4 col-xl-4';
				} 
			?>
            <div class="<?php echo esc_attr( $classes );?>">
                <div class="blog-card">
                    <div class="blog-card-image">
                        <div class="img-fluid"><?php the_post_thumbnail('towngov_465x375'); ?></div>
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"></a>
                    </div><!-- blog-card-image -->
                    <div class="blog-card-date">
                        <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><?php echo get_the_date('d'); ?><?php echo get_the_date('M'); ?></a>
                    </div><!-- blog-card-date -->
                    <div class="blog-card-content">
                        <div class="blog-card-meta">
                            <span class="author">
                                <?php esc_html_e('by', 'towngov'); ?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><?php the_author(); ?></a>
                            </span><!-- author -->
                            <span class="comment">
                                <a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><?php comments_number( wp_kses(__('0 Comments' , 'towngov'), true), wp_kses(__('01 Comment' , 'towngov'), true), wp_kses(__('0% Comments' , 'towngov'), true)); ?></a>
                            </span><!-- comment -->	
                        </div><!-- blog-card-meta -->
                        <h4><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
                        <p><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></p>
                    </div><!-- blog-card-content -->
                </div><!-- blog-card -->	
            </div><!-- col-lg-4 -->
            <?php endwhile; ?>
        </div><!-- row -->		
	</section><!-- blog-section -->
 	<?php endif; ?>
		<?php }
		wp_reset_postdata();
	}
}
	