<?php

namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Documentation_Grid extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'towngov_documentation_grid';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Towngov Documentation Grid', 'towngov' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open town';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'towngov' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'documentation_grid',
			[
				'label' => esc_html__( 'Documentation Grid', 'towngov' ),
			]
		);
		
		$this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'towngov' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 11,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );

		$this->add_control(
			'btn_label',
			[
				'label'       => __( 'Read More Label', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'default'	=> __('Read More', 'towngov'),
				'placeholder' => __( 'Enter your Button Title', 'towngov' ),
			]
		);
		$this->end_controls_section();
		
		/**Grid Setting Start**/
		$this->start_controls_section(
			'grid',
			[
				'label' => esc_html__( 'Grid Setting', 'towngov' ),			
			]
		);
		$this->add_control(
			'col_grid',
			[
				'label'   => esc_html__( 'Choose Column', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'three',
				'options' => array(
					'one' => esc_html__( 'One Column Grid ', 'towngov'),
					'two'  => esc_html__( 'Two Column Grid', 'towngov' ),
					'three'  => esc_html__( 'Three Column Grid', 'towngov' ),
					'four'  => esc_html__( 'Four Column Grid', 'towngov' ),
					'five'  => esc_html__( 'Six Column Grid', 'towngov' ),
				),				
			]
		);
		$this->end_controls_section();
		
		//General Style
		/**Service Box Style**/
		$this->start_controls_section(
			'general_box_style',
			[
				'label' => esc_html__('Box Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'general_box_tab' );
		
			$this->start_controls_tab(
				'general_box_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'general_box_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-general-box',				
					]
				);
				$this->add_responsive_control(
					'general_box_space',
					[
						'label'              => __( 'Space', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-general-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
							
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_responsive_control(
					'general_box_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-general-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'general_box_border_type',
						'selector' => 
							'{{WRAPPER}} .te-general-box',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'general_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-general-box',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'general_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-general-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'general_box_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'general_hover_bg_bgtype',
						'label' => __( 'Hover Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-general-box:hover',				
					]
				);
				
				$this->add_control(
					'general_background_hover_transition',
					[
						'label' => esc_html__( 'Transition Duration', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'max' => 3,
								'step' => 0.1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-general-box:hover' => 'transition-duration: {{SIZE}}s',
						],
					]
				);
		
				$this->add_control(
					'hover_animation',
					[
						'label' => esc_html__( 'Hover Animation', 'towngov' ),
						'type' => Controls_Manager::HOVER_ANIMATION,
					]
				);
				
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();
		
		/**Icon Box Style**/
		$this->start_controls_section(
			'icon_box_style',
			[
				'label' => esc_html__('Icon Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'towngov_service_icon_tab' );
		
			$this->start_controls_tab(
				'towngov_service_icon_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'icon_box_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-icon-box'				
					]
				);
				$this->add_control(
					'service_icon_color',
					[
						'label' => __('Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'color: {{VALUE}}',
							'{{WRAPPER}} .te-icon-box a' => 'color: {{VALUE}}'
						],
						'separator' => 'before',
					]
				);
				$this->add_responsive_control(
					'icon_width_size',
					[
						'label' => __( 'Width', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'width: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_height_size',
					[
						'label' => __( 'Height', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_line_height',
					[
						'label' => __( 'Line Height', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'line-height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_box_space',
					[
						'label'              => __( 'Space', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-icon-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_responsive_control(
					'icon_box_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-icon-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'service_icon_border_type',
						'selector' => 
							'{{WRAPPER}} .te-icon-box',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'service_icon_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-icon-box',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'service_icon_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'towngov_services_icon_box_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'service_icon_hover_bg_bgtype',
						'label' => __( 'Hover Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-icon-box:hover'				
					]
				);
				
				$this->add_control(
					'icon_hover_color',
					[
						'label' => __('Button Text Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .te-icon-box:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .te-icon-box:hover a' => 'color: {{VALUE}}',
						],
						'separator' => 'before',
					]
				);
				
				$this->add_control(
					'service_icon_hover_transition',
					[
						'label' => esc_html__( 'Transition Duration', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'max' => 3,
								'step' => 0.1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box:hover' => 'transition-duration: {{SIZE}}s'
						],
					]
				);
		
				$this->add_control(
					'icon_hover_animation',
					[
						'label' => esc_html__( 'Hover Animation', 'towngov' ),
						'type' => Controls_Manager::HOVER_ANIMATION,
					]
				);
				
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();
		
		//Title Style
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title', 'insuco' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
            'title__margin',
            [
                'label'      => esc_html__( 'Margin', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__( 'Padding', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'title_bgtype',
				'label' => __( 'Background', 'insuco' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .te-title',				
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Text Color', 'insuco' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Typography', 'insuco'),
				'selector' => '{{WRAPPER}} .te-title',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .te-title',
			]
		);

		$this->end_controls_section();
		
		//Text Style
		
		$this->start_controls_section(
			'text_style',
			[
				'label' => esc_html__( 'Text', 'insuco' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
            'text__margin',
            [
                'label'      => esc_html__( 'Margin', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
        $this->add_responsive_control(
            'text_padding',
            [
                'label'      => esc_html__( 'Padding', 'pyloncore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .te-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator'  => 'before',
            ]
        );
		
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'insuco' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __('Typography', 'insuco'),
				'selector' => '{{WRAPPER}} .te-text',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_text_shadow',
				'selector' => '{{WRAPPER}} .te-text',
			]
		);

		$this->end_controls_section();
		
    }
	

	/**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$grid_col = $settings['col_grid'];
		if( $grid_col == 'one' ){
			$classes = 'col-lg-12 col-xl-12';
		}elseif( $grid_col == 'two' ){
			$classes = 'col-xxl-6 col-xl-6';
		}elseif( $grid_col == 'three' ){
			$classes = 'col-xxl-4 col-xl-6';
		}elseif( $grid_col == 'four' ){
			$classes = 'col-xxl-3 col-xl-3';
		}elseif( $grid_col == 'five' ){
			$classes = 'col-xxl-2 col-xl-2';
		}else{
			$classes = 'col-xxl-4 col-xl-6';
		}
		$paged = towngov_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-towngov' );

         $terms = get_terms( 'documentations_cat', array('orderby'  => 'term_id', 'hide_empty' => 0 ) );

		
    ?>
	
<section class="document-section">
    <div class="container">
        <ul class="nav nav-pills" id="pills-tab" role="tablist">
            <li class="nav-item active" role="presentation">
                <button class="nav-link active" id="pills-all-tab" data-bs-toggle="pill" data-bs-target="#pills-all" type="button" role="tab" aria-controls="pills-all" aria-selected="true">All</button>
            </li>
            <?php foreach ($terms as $term): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-all-tab<?php echo esc_attr($term->slug); ?>" data-bs-toggle="pill" data-bs-target="#pills-all<?php echo esc_attr($term->slug); ?>" type="button" role="tab" aria-controls="pills-all" aria-selected="true"><?php echo $term->name; ?></button>
                </li>
            <?php endforeach; ?>
        </ul><!-- nav nav-pills -->

        <div class="tab-content" id="pills-tabContent">
            <!-- All Documents Tab -->
            <div class="tab-pane fade show active" id="pills-all" role="tabpanel" aria-labelledby="pills-all-tab">
                <div class="row row-gutter-30">
                    <?php
                    $args_all = array(
                        'post_type' => 'documentations',
                        // Exclude the tax_query for the "All" tab
                    );
                    $query_all = new \WP_Query($args_all);
                    while ($query_all->have_posts()) : $query_all->the_post();
                        $towngov_doc_meta = get_post_meta(get_the_ID(), 'towngov_meta_documentation', true);
                        ?>
                        <div class="<?php echo esc_attr( $classes );?>">
            <div class="service-three-card te-general-box">
                
                <div class="service-three-icon">
                    <?php if( !empty( $towngov_doc_meta['service_icon'] ) ):?>
                    	<i class="te-icon-box <?php echo $towngov_doc_meta['service_icon']; ?>"></i>
                    <?php else:?>
                    	<i class="te-icon-box flaticon-pdf"></i>
                    <?php endif;?>
                </div><!-- service-three-icon -->
                
                <div class="service-three-card-content">
                    <h3 class="te-title"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title();?></a></h3>
                    <p class="te-text"><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></p>
                    <div class="service-three-detail">
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                            <span><?php echo wp_kses( $settings[ 'btn_label' ], true );?></span>
                            <i class="fa-solid fa-arrow-right-long"></i>
                        </a>
                        <?php if( !empty( $towngov_doc_meta['service_icon'] ) ):?>
                            <i class="te-icon-box <?php echo $towngov_doc_meta['service_icon']; ?>"></i>
                        <?php else:?>
                            <i class="te-icon-box flaticon-pdf"></i>
                        <?php endif;?>
                    </div><!-- service-three-detail -->
                </div><!-- service-three-card-content -->
                
            </div><!-- service-three-card -->
        </div><!-- col-xxl-4 col-xl-6 -->
                    <?php endwhile; ?>
                </div><!-- row -->
            </div><!-- tab-pane -->

            <!-- Category Tabs -->
            <?php foreach ($terms as $term): ?>
                <?php
                $args_category = array(
                    'post_type' => 'documentations',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'documentations_cat',
                            'field'    => 'term_id',
                            'terms'    => $term->term_id,
                        ),
                    ),
                );
                $query_category = new \WP_Query($args_category);
                ?>
                <div class="tab-pane fade" id="pills-all<?php echo esc_attr($term->slug); ?>" role="tabpanel" aria-labelledby="pills-all-tab<?php echo esc_attr($term->slug); ?>">
                    <div class="row row-gutter-30">
                        <?php while ($query_category->have_posts()) : $query_category->the_post(); ?>
                            <div class="<?php echo esc_attr( $classes );?>">
            <div class="service-three-card te-general-box">
                
                <div class="service-three-icon">
                    <?php if( !empty( $towngov_doc_meta['service_icon'] ) ):?>
                    	<i class="te-icon-box <?php echo $towngov_doc_meta['service_icon']; ?>"></i>
                    <?php else:?>
                    	<i class="te-icon-box flaticon-pdf"></i>
                    <?php endif;?>
                </div><!-- service-three-icon -->
                
                <div class="service-three-card-content">
                    <h3 class="te-title"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title();?></a></h3>
                    <p class="te-text"><?php echo wp_kses(wp_trim_words(get_the_content(), $settings['text_limit']), true); ?></p>
                    <div class="service-three-detail">
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                            <span><?php echo wp_kses( $settings[ 'btn_label' ], true );?></span>
                            <i class="fa-solid fa-arrow-right-long"></i>
                        </a>
                        <?php if( !empty( $towngov_doc_meta['service_icon'] ) ):?>
                            <i class="te-icon-box <?php echo $towngov_doc_meta['service_icon']; ?>"></i>
                        <?php else:?>
                            <i class="te-icon-box flaticon-pdf"></i>
                        <?php endif;?>
                    </div><!-- service-three-detail -->
                </div><!-- service-three-card-content -->
                
            </div><!-- service-three-card -->
        </div><!-- col-xxl-4 col-xl-6 -->
                        <?php endwhile; ?>
                    </div><!-- row -->
                </div><!-- tab-pane -->
                <?php wp_reset_postdata(); ?>
            <?php endforeach; ?>
        </div><!-- tab-content -->
    </div><!-- container -->
</section><!-- document-section -->



	
	<?php 
	}
}