<?php
namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Client_Section extends Widget_Base {
    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_client_section';
    }
    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Client Section', 'towngov' );
    }
    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open town';
    }
    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'client-carousel', YT_URL . 'assets/js/clients-carousel.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'client-carousel' ];
	}
	
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'client_section',
            [
                'label' => esc_html__( 'Client Section', 'towngov' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'towngov' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/resource/clients1.png'
					],
				],
			]
		);
		$this->add_control(		
			 'title',
			[
				'label'       => __( 'Title', 'towngov' ),				
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,				
				'dynamic'     => [				
					'active' => true,
				],	
				'placeholder' => __( 'Enter your title', 'towngov' ),
			]
		);
		//Our Slider		
		$repeater = new Repeater();		
		$repeater->add_control(
			'block_img',
			[
				'name' => 'block_img',							
				'label' => esc_html__('Slide BG Image ', 'towngov'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$this->add_control(
			'slides',
			[
				'label'                 => __('Add Item', 'towngov'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
		
		/**Carousel Setting Start**/
		$this->start_controls_section(
			'carousel',
			[
				'label' => esc_html__( 'Carousel Setting', 'towngov' ),
				'condition'   => [ 'layout_control'  =>  ['one', 'two'] ]
			]
		);
		$this->add_control(
			'infinite',
			[
				'label' => __( 'infinite Loop?', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'towngov' ),
				'label_off' => __( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_responsive_control(
			'items_show',
			[
				'label' => esc_html__( 'No. of Items', 'towngov' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'default' => 3,
			]
		);
		$this->add_responsive_control(
			'image_item_gap',
			[
				'label' => __( 'Item Gap', 'towngov' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'default' => 30,
			]
		);
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'Autoplay?', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'towngov' ),
				'label_off' => __( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'autoplay_speed',
			array(
				'label'       => __( 'Animation Speed', 'towngov' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => __( '2500', 'towngov' ),
			)
		);
		$this->add_control(
            'towngov_nav_heading',
            [
                'label' => __('Navigation', 'towngov'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
			]
        );
		$this->add_control(
			'arrows',
			[
				'label' => __( 'Enable Arrows?', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'towngov' ),
				'label_off' => __( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'dots',
			[
				'label' => __( 'Enable Dots?', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'towngov' ),
				'label_off' => __( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);		
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .client-text',                 
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .client-text' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'lines_color',
            [
                'label' => __('Lines Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .client-section .owl-stage-outer' => 'border-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/*******************
		Arrow Styling Start
		*******************/
		
		$this->start_controls_section(
			'carousel_navigation_arrow',
			[
				'label' => esc_html__('Navigation - Arrow', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => ['layout_control'      => ['one', 'two']	],
			]
		);
		
		/******Tabs Start**********/
		
		$this->start_controls_tabs( 'towngov_tabs_nav_position' );
			
			$this->start_controls_tab(
				'towngov_tab_navs_position_left',
				[
					'label' => __( 'Left Arrow', 'towngov' ),
				]
			);
			$this->add_control(
				'arrow_position_toggle',
				[
					'label' => __( 'Position', 'towngov' ),
					'type' => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'None', 'towngov' ),
					'label_on' => __( 'Custom', 'towngov' ),
					'return_value' => 'yes',
				]
			);
			/******Popup Start**********/
			$this->start_popover();
				$this->add_responsive_control(
					'arrow_position_y',
					[
						'label' => __( 'Vertical', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => ['px', '%'],
						'condition' => [
							'arrow_position_toggle' => 'yes'
						],
						'range' => [
							'px' => [
								'min' => -100,
								'max' => 500,
							],
							'%' => [
								'min' => -110,
								'max' => 110,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-prev' => 'top: {{SIZE}}{{UNIT}};',
						],
					]
				);
				$this->add_responsive_control(
					'arrow_position_x',
					[
						'label' => __( 'Horizontal', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => ['px', '%'],
						'condition' => [
							'arrow_position_toggle' => 'yes'
						],
						'range' => [
							'px' => [
								'min' => -100,
								'max' => 500,
							],
							'%' => [
								'min' => -110,
								'max' => 110,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-prev' => 'left: {{SIZE}}{{UNIT}};',
						],
					]
				);
			$this->end_popover();
			$this->add_control(
				'nav_arrow_position',
				[
					'label' => esc_html__( 'Position', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'relative'  => esc_html__( 'Relative', 'textdomain' ),
						'absolute' => esc_html__( 'Absolute', 'textdomain' ),
						'fixed' => esc_html__( 'Fixed', 'textdomain' ),
					],
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-nav .owl-prev' => 'position: {{VALUE}};',
					],
				]
			);
			
			$this->end_controls_tab();
		
			$this->start_controls_tab(
				'towngov_tab_navs_position_right',
				[
					'label' => __( 'Right Arrow', 'towngov' ),
				]
			);
			$this->add_control(
				'right_arrow_position_toggle',
				[
					'label' => __( 'Position', 'towngov' ),
					'type' => Controls_Manager::POPOVER_TOGGLE,
					'label_off' => __( 'None', 'towngov' ),
					'label_on' => __( 'Custom', 'towngov' ),
					'return_value' => 'yes',
				]
			);
			$this->start_popover();
				$this->add_responsive_control(
					'right_arrow_position_y',
					[
						'label' => __( 'Vertical', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => ['px', '%'],
						'condition' => [
							'arrow_position_toggle' => 'yes'
						],
						'range' => [
							'px' => [
								'min' => -100,
								'max' => 500,
							],
							'%' => [
								'min' => -110,
								'max' => 110,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-next' => 'top: {{SIZE}}{{UNIT}};',
						],
					]
				);
				$this->add_responsive_control(
					'right_arrow_position_x',
					[
						'label' => __( 'Horizontal', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => ['px', '%'],
						'condition' => [
							'arrow_position_toggle' => 'yes'
						],
						'range' => [
							'px' => [
								'min' => -100,
								'max' => 500,
							],
							'%' => [
								'min' => -110,
								'max' => 110,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-next' => 'right: {{SIZE}}{{UNIT}};',
						],
					]
				);
			$this->end_popover();
			$this->add_control(
				'rightnav_arrow_position',
				[
					'label' => esc_html__( 'Position', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'relative'  => esc_html__( 'Relative', 'textdomain' ),
						'absolute' => esc_html__( 'Absolute', 'textdomain' ),
						'fixed' => esc_html__( 'Fixed', 'textdomain' ),
					],
					'selectors' => [
						'{{WRAPPER}} .owl-carousel .owl-nav .owl-next' => 'position: {{VALUE}};',
					],
				]
			);
		$this->end_controls_tabs();
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'axtra'),
                'selector' => 
					'{{WRAPPER}} .owl-carousel .owl-nav button span',				
                'separator' => 'before',
			]
        );
		
		$this->add_control(
            'arrow_border_radius',
            [
                'label' => __('Border Radius', 'towngov'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-nav button span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
            ]
        );
		
		$this->add_responsive_control(
			'arrow_nav_padding',
			array(
				'label'      => __('Padding', 'towngov'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array('px', '%'),
				'selectors'  => array(
					'.owl-carousel .owl-nav button span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
					
				),
			)
		);
		
		$this->start_controls_tabs( 'towngov_tabs_nav' );
		$this->start_controls_tab(
			'towngov_tab_navs_normal',
			[
				'label' => __( 'Normal', 'towngov' ),
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'navigation_border_type',
                'selector' => '{{WRAPPER}} .owl-carousel .owl-nav button span',				
				'separator' => 'before',
            ]
        );
		$this->add_control(
			'navigation_bg_color',
			array(
				'label'     => __('Background Color', 'towngov'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .owl-carousel .owl-nav button span' => 'background-color: {{VALUE}}!important',
					
				),
			)
		);
		$this->add_control(
			'navigation_color',
			array(
				'label'     => __('Color', 'towngov'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .owl-carousel .owl-nav button span' => 'color: {{VALUE}}!important',
				),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'towngov_tab_nav_hover',
			[
				'label' => __( 'Hover', 'towngov' ),
			]
		);
		$this->add_control(
            'navigation_border_hover_color',
            [
                'label' => __('Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-nav button span:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
			 ]
        );
		$this->add_control(
			'navigation_bg_hover_color',
			array(
				'label'     => __('Background Color', 'towngov'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .owl-carousel .owl-nav button span:hover' => 'background-color: {{VALUE}}!important',
					
				),
			)
		);
		$this->add_control(
			'navigation_hover_color',
			array(
				'label'     => __('Color', 'towngov'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .owl-carousel .owl-nav button span:hover' => 'color: {{VALUE}}!important',
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->end_controls_section();
		
		/******Dots Styling Start*******/
		
		$this->start_controls_section(
			'carousel_navigation_dots',
			[
				'label' => esc_html__('Navigation - Dots', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [ 'layout_control'  =>  ['one', 'two'] ]
			]
		);
		$this->add_control(
			'dots_position_toggle',
			[
				'label' => __( 'Position', 'towngov' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __( 'None', 'towngov' ),
				'label_on' => __( 'Custom', 'towngov' ),
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
		$this->add_responsive_control(
			'dots_position_y',
			[
				'label' => __( 'Vertical', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'condition' => [
					'arrow_position_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 500,
					],
					'%' => [
						'min' => -110,
						'max' => 110,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'dots_position_x',
			[
				'label' => __( 'Horizontal', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'condition' => [
					'arrow_position_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 500,
					],
					'%' => [
						'min' => -110,
						'max' => 110,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_popover();
		$this->add_control(
			'nav_dots_position',
			[
				'label' => esc_html__( 'Position', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'relative'  => esc_html__( 'Relative', 'textdomain' ),
					'absolute' => esc_html__( 'Absolute', 'textdomain' ),
					'fixed' => esc_html__( 'Fixed', 'textdomain' ),
				],
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots' => 'position: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'dots_nav_size',
			[
				'label' => __( 'Width', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_control(
			'dots_nav_heigt_size',
			[
				'label' => __( 'Height', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_control(
            'dots_border_radius',
            [
                'label' => __('Border Radius', 'towngov'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots button span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
            ]
        );
		$this->start_controls_tabs( 'towngov_tabs_dots' );
		
		$this->start_controls_tab(
			'towngov_tab_dots_normal',
			[
				'label' => __( 'Normal', 'towngov' ),
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_border_type',
                'selector' => '{{WRAPPER}} .owl-carousel .owl-dots button span',				
				'separator' => 'before',
            ]
        );
		$this->add_control(
			'dots_bg_color',
			array(
				'label'     => __('Background Color', 'towngov'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .owl-carousel .owl-dots button span' => 'background-color: {{VALUE}}!important',
					
				),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'towngov_tab_dots_hover',
			[
				'label' => __( 'Hover', 'towngov' ),
			]
		);
		$this->add_control(
            'dots_border_hover_color',
            [
                'label' => __('Border Hover Color', 'axtra'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots button span:hover' => 'border-color: {{VALUE}}!important',
					'{{WRAPPER}} .owl-carousel .owl-dots button.active span' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
			 ]
        );
		$this->add_control(
			'dots_bg_hover_color',
			array(
				'label'     => __('Background Color', 'towngov'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .owl-carousel .owl-dots button span:hover' => 'background-color: {{VALUE}}!important',
					'{{WRAPPER}} .owl-carousel .owl-dots button.active span' => 'background-color: {{VALUE}}!important',
					
				),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		$layout = $settings[ 'layout_control' ];
		$items_show = $settings[ 'items_show' ];
		$image_item_gap = $settings[ 'image_item_gap' ];
		$autoplay_speed = $settings[ 'autoplay_speed' ];
		
		if($settings['infinite'] == 'yes'){
			$infiinite = true;
		}else{
			$infiinite = false;
		}

		if($settings['autoplay'] == 'yes'){
			$autoplay = true;
		}else{
			$autoplay = false;
		}

		if($settings['dots'] == 'yes'){
			$dots = true;
		}else{
			$dots = false;
		}

		if($settings['arrows'] == 'yes'){
			$arrows = true;
		} else{
			$arrows = false;
		}
		
		$changed_atts = array(
			'infinite'       => $infiinite,
			'autoplay'       => $autoplay,
			'autoplaySpeed'  => $autoplay_speed,
			'dots' 			 => $dots,
			'nav' 		 => $arrows,
			'item_gap' 	     => $image_item_gap,
			'item_show' 	 => $items_show
		);
		
		$slider_atts = 'data-slider';
		
		$this->add_render_attribute( 'slider_settings', $slider_atts , wp_json_encode( $changed_atts ) );
	?>
    
    <section class="client-section">
		<?php if($settings['title']){ ?><h5 class="client-text"><?php echo wp_kses($settings['title'], true);?></h5><?php } ?>
		<div class="container">
			<div class="client-carousel owl-carousel owl-theme <?php if(! $settings['dots'] == 'yes' ) echo 'owl-dots-none';?> <?php if( $settings['arrows'] == 'yes' ) echo 'nav-style-one'; else echo 'owl-nav-none';?>" id="client-slider" <?php $this->print_render_attribute_string( 'slider_settings' ); ?>>
				<?php foreach($settings['slides'] as $key => $item):?>
                <div class="item">
					<img src="<?php echo esc_url(wp_get_attachment_url($item['block_img']['id'])); ?>" class="img-fluid" alt="<?php esc_attr_e('Awesome Image','towngov');?>">
				</div><!--item-->
                <?php endforeach;?>
			</div><!--client-carousel owl-carousel owl-theme-->
		</div><!--container-->
	</section><!--client-section-->
    
      <?php
    }
}