<?php 
namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Causes_Grid_v2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_causes_grid_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Towngov Causes Grid V2', 'towngov' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open town';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'causes-carousels', YT_URL . 'assets/js/causes-count.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'causes-carousels' ];
	}

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'causes_grid_v2',
            [
                'label' => esc_html__( 'Towngov Causes Grid V2', 'towngov' ),
			]
        );
		$this->add_control(
			'show_excerpt',
			[
				'label' => __( 'Show Form Excerpt', 'towngov' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'description' => __( 'Show/Hide the form excerpt.', 'towngov' ),
				'label_on' => __( 'Show', 'towngov' ),
				'label_off' => __( 'Hide', 'towngov' ),
				'default' => 'yes',
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'towngov' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'condition' => [
					'show_excerpt' => 'yes',
				]
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label' => esc_html__( 'Button Title', 'elementor' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter button title', 'elementor' ),
				'default' => esc_html__( 'Donate Now', 'elementor' ),
			]
		);	
		$this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'towngov' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'towngov' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'towngov' ),
                    'title'      => esc_html__( 'Title', 'towngov' ),
                    'menu_order' => esc_html__( 'Menu Order', 'towngov' ),
                    'rand'       => esc_html__( 'Random', 'towngov' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'towngov' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'towngov' ),
                    'ASC'  => esc_html__( 'ASC', 'towngov' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'towngov'),
				'label_block' => true,
                'options' => get_campaign_categories()
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$btn_title = $settings[ 'btn_title' ];

        $paged = get_query_var('paged');
		$paged = towngov_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-towngov' );
        $args = array(
            'post_type'      => 'give_forms',
            'posts_per_page' => towngov_set( $settings, 'query_number' ),
            'orderby'        => towngov_set( $settings, 'query_orderby' ),
            'order'          => towngov_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if( towngov_set( $settings, 'query_category' ) ) $args['give_forms_category'] = towngov_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <div class="row row-gutter-30">
            <?php
				while ( $query->have_posts() ) : $query->the_post();
				$form_id          = get_the_ID();
				$raw_content      = ''; // Raw form content.
				$stripped_content = ''; // Form content stripped of HTML tags and shortcodes.
				$excerpt          = ''; // Trimmed form excerpt ready for display.
			?>
            <div class="col-lg-6 col-xl-4">
                <div class="causes-card">
                    <div class="causes-card-imgbox">
                        <div class="img-fluid"><?php the_post_thumbnail( get_the_id(), 'towngov_372x286'); ?></div>
                    </div>
                    <div class="causes-content">
                        <div class="causes-card-funding">
                            <div class="causes-card-progressbar">
                                <div class="causes-card-progressbar-inner count-box-two" data-percentage="%">
                                    <div class="causes-card-progressbar-text count-text-two"></div>
                                </div>
                            </div>
                        </div>
                        <h4> <a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_title();?></a> </h4>
                        
                        <p><?php echo give_get_meta( $form_id, 'description', true )?></p>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
        
        
        <?php }
        wp_reset_postdata();
    }
}
