/* flatpickr v4.6.9, @license MIT */

(function (global, factory) {

    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :

    typeof define === 'function' && define.amd ? define(factory) :

    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.flatpickr = factory());

}(this, (function () { 'use strict';



    /*! *****************************************************************************

    Copyright (c) Microsoft Corporation.



    Permission to use, copy, modify, and/or distribute this software for any

    purpose with or without fee is hereby granted.



    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH

    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY

    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,

    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM

    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR

    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR

    PERFORMANCE OF THIS SOFTWARE.

    ***************************************************************************** */



    var __assign = function() {

        __assign = Object.assign || function __assign(t) {

            for (var s, i = 1, n = arguments.length; i < n; i++) {

                s = arguments[i];

                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];

            }

            return t;

        };

        return __assign.apply(this, arguments);

    };



    function __spreadArrays() {

        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;

        for (var r = Array(s), k = 0, i = 0; i < il; i++)

            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)

                r[k] = a[j];

        return r;

    }



    var HOOKS = [

        "onChange",

        "onClose",

        "onDayCreate",

        "onDestroy",

        "onKeyDown",

        "onMonthChange",

        "onOpen",

        "onParseConfig",

        "onReady",

        "onValueUpdate",

        "onYearChange",

        "onPreCalendarPosition",

    ];

    var defaults = {

        _disable: [],

        allowInput: false,

        allowInvalidPreload: false,

        altFormat: "F j, Y",

        altInput: false,

        altInputClass: "form-control input",

        animate: typeof window === "object" &&

            window.navigator.userAgent.indexOf("MSIE") === -1,

        ariaDateFormat: "F j, Y",

        autoFillDefaultTime: true,

        clickOpens: true,

        closeOnSelect: true,

        conjunction: ", ",

        dateFormat: "Y-m-d",

        defaultHour: 12,

        defaultMinute: 0,

        defaultSeconds: 0,

        disable: [],

        disableMobile: false,

        enableSeconds: false,

        enableTime: false,

        errorHandler: function (err) {

            return typeof console !== "undefined" && console.warn(err);

        },

        getWeek: function (givenDate) {

            var date = new Date(givenDate.getTime());

            date.setHours(0, 0, 0, 0);

            // Thursday in current week decides the year.

            date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));

            // January 4 is always in week 1.

            var week1 = new Date(date.getFullYear(), 0, 4);

            // Adjust to Thursday in week 1 and count number of weeks from date to week1.

            return (1 +

                Math.round(((date.getTime() - week1.getTime()) / 86400000 -

                    3 +

                    ((week1.getDay() + 6) % 7)) /

                    7));

        },

        hourIncrement: 1,

        ignoredFocusElements: [],

        inline: false,

        locale: "default",

        minuteIncrement: 5,

        mode: "single",

        monthSelectorType: "dropdown",

        nextArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",

        noCalendar: false,

        now: new Date(),

        onChange: [],

        onClose: [],

        onDayCreate: [],

        onDestroy: [],

        onKeyDown: [],

        onMonthChange: [],

        onOpen: [],

        onParseConfig: [],

        onReady: [],

        onValueUpdate: [],

        onYearChange: [],

        onPreCalendarPosition: [],

        plugins: [],

        position: "auto",

        positionElement: undefined,

        prevArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",

        shorthandCurrentMonth: false,

        showMonths: 1,

        static: false,

        time_24hr: false,

        weekNumbers: false,

        wrap: false,

    };



    var english = {

        weekdays: {

            shorthand: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],

            longhand: [

                "Sunday",

                "Monday",

                "Tuesday",

                "Wednesday",

                "Thursday",

                "Friday",

                "Saturday",

            ],

        },

        months: {

            shorthand: [

                "Jan",

                "Feb",

                "Mar",

                "Apr",

                "May",

                "Jun",

                "Jul",

                "Aug",

                "Sep",

                "Oct",

                "Nov",

                "Dec",

            ],

            longhand: [

                "January",

                "February",

                "March",

                "April",

                "May",

                "June",

                "July",

                "August",

                "September",

                "October",

                "November",

                "December",

            ],

        },

        daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],

        firstDayOfWeek: 0,

        ordinal: function (nth) {

            var s = nth % 100;

            if (s > 3 && s < 21)

                return "th";

            switch (s % 10) {

                case 1:

                    return "st";

                case 2:

                    return "nd";

                case 3:

                    return "rd";

                default:

                    return "th";

            }

        },

        rangeSeparator: " to ",

        weekAbbreviation: "Wk",

        scrollTitle: "Scroll to increment",

        toggleTitle: "Click to toggle",

        amPM: ["AM", "PM"],

        yearAriaLabel: "Year",

        monthAriaLabel: "Month",

        hourAriaLabel: "Hour",

        minuteAriaLabel: "Minute",

        time_24hr: false,

    };



    var pad = function (number, length) {

        if (length === void 0) { length = 2; }

        return ("000" + number).slice(length * -1);

    };

    var int = function (bool) { return (bool === true ? 1 : 0); };

    /* istanbul ignore next */

    function debounce(fn, wait) {

        var t;

        return function () {

            var _this = this;

            clearTimeout(t);

            t = setTimeout(function () { return fn.apply(_this, arguments); }, wait);

        };

    }

    var arrayify = function (obj) {

        return obj instanceof Array ? obj : [obj];

    };



    function toggleClass(elem, className, bool) {

        if (bool === true)

            return elem.classList.add(className);

        elem.classList.remove(className);

    }

    function createElement(tag, className, content) {

        var e = window.document.createElement(tag);

        className = className || "";

        content = content || "";

        e.className = className;

        if (content !== undefined)

            e.textContent = content;

        return e;

    }

    function clearNode(node) {

        while (node.firstChild)

            node.removeChild(node.firstChild);

    }

    function findParent(node, condition) {

        if (condition(node))

            return node;

        else if (node.parentNode)

            return findParent(node.parentNode, condition);

        return undefined; // nothing found

    }

    function createNumberInput(inputClassName, opts) {

        var wrapper = createElement("div", "numInputWrapper"), numInput = createElement("input", "numInput " + inputClassName), arrowUp = createElement("span", "arrowUp"), arrowDown = createElement("span", "arrowDown");

        if (navigator.userAgent.indexOf("MSIE 9.0") === -1) {

            numInput.type = "number";

        }

        else {

            numInput.type = "text";

            numInput.pattern = "\\d*";

        }

        if (opts !== undefined)

            for (var key in opts)

                numInput.setAttribute(key, opts[key]);

        wrapper.appendChild(numInput);

        wrapper.appendChild(arrowUp);

        wrapper.appendChild(arrowDown);

        return wrapper;

    }

    function getEventTarget(event) {

        try {

            if (typeof event.composedPath === "function") {

                var path = event.composedPath();

                return path[0];

            }

            return event.target;

        }

        catch (error) {

            return event.target;

        }

    }



    var doNothing = function () { return undefined; };

    var monthToStr = function (monthNumber, shorthand, locale) { return locale.months[shorthand ? "shorthand" : "longhand"][monthNumber]; };

    var revFormat = {

        D: doNothing,

        F: function (dateObj, monthName, locale) {

            dateObj.setMonth(locale.months.longhand.indexOf(monthName));

        },

        G: function (dateObj, hour) {

            dateObj.setHours(parseFloat(hour));

        },

        H: function (dateObj, hour) {

            dateObj.setHours(parseFloat(hour));

        },

        J: function (dateObj, day) {

            dateObj.setDate(parseFloat(day));

        },

        K: function (dateObj, amPM, locale) {

            dateObj.setHours((dateObj.getHours() % 12) +

                12 * int(new RegExp(locale.amPM[1], "i").test(amPM)));

        },

        M: function (dateObj, shortMonth, locale) {

            dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));

        },

        S: function (dateObj, seconds) {

            dateObj.setSeconds(parseFloat(seconds));

        },

        U: function (_, unixSeconds) { return new Date(parseFloat(unixSeconds) * 1000); },

        W: function (dateObj, weekNum, locale) {

            var weekNumber = parseInt(weekNum);

            var date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);

            date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);

            return date;

        },

        Y: function (dateObj, year) {

            dateObj.setFullYear(parseFloat(year));

        },

        Z: function (_, ISODate) { return new Date(ISODate); },

        d: function (dateObj, day) {

            dateObj.setDate(parseFloat(day));

        },

        h: function (dateObj, hour) {

            dateObj.setHours(parseFloat(hour));

        },

        i: function (dateObj, minutes) {

            dateObj.setMinutes(parseFloat(minutes));

        },

        j: function (dateObj, day) {

            dateObj.setDate(parseFloat(day));

        },

        l: doNothing,

        m: function (dateObj, month) {

            dateObj.setMonth(parseFloat(month) - 1);

        },

        n: function (dateObj, month) {

            dateObj.setMonth(parseFloat(month) - 1);

        },

        s: function (dateObj, seconds) {

            dateObj.setSeconds(parseFloat(seconds));

        },

        u: function (_, unixMillSeconds) {

            return new Date(parseFloat(unixMillSeconds));

        },

        w: doNothing,

        y: function (dateObj, year) {

            dateObj.setFullYear(2000 + parseFloat(year));

        },

    };

    var tokenRegex = {

        D: "(\\w+)",

        F: "(\\w+)",

        G: "(\\d\\d|\\d)",

        H: "(\\d\\d|\\d)",

        J: "(\\d\\d|\\d)\\w+",

        K: "",

        M: "(\\w+)",

        S: "(\\d\\d|\\d)",

        U: "(.+)",

        W: "(\\d\\d|\\d)",

        Y: "(\\d{4})",

        Z: "(.+)",

        d: "(\\d\\d|\\d)",

        h: "(\\d\\d|\\d)",

        i: "(\\d\\d|\\d)",

        j: "(\\d\\d|\\d)",

        l: "(\\w+)",

        m: "(\\d\\d|\\d)",

        n: "(\\d\\d|\\d)",

        s: "(\\d\\d|\\d)",

        u: "(.+)",

        w: "(\\d\\d|\\d)",

        y: "(\\d{2})",

    };

    var formats = {

        // get the date in UTC

        Z: function (date) { return date.toISOString(); },

        // weekday name, short, e.g. Thu

        D: function (date, locale, options) {

            return locale.weekdays.shorthand[formats.w(date, locale, options)];

        },

        // full month name e.g. January

        F: function (date, locale, options) {

            return monthToStr(formats.n(date, locale, options) - 1, false, locale);

        },

        // padded hour 1-12

        G: function (date, locale, options) {

            return pad(formats.h(date, locale, options));

        },

        // hours with leading zero e.g. 03

        H: function (date) { return pad(date.getHours()); },

        // day (1-30) with ordinal suffix e.g. 1st, 2nd

        J: function (date, locale) {

            return locale.ordinal !== undefined

                ? date.getDate() + locale.ordinal(date.getDate())

                : date.getDate();

        },

        // AM/PM

        K: function (date, locale) { return locale.amPM[int(date.getHours() > 11)]; },

        // shorthand month e.g. Jan, Sep, Oct, etc

        M: function (date, locale) {

            return monthToStr(date.getMonth(), true, locale);

        },

        // seconds 00-59

        S: function (date) { return pad(date.getSeconds()); },

        // unix timestamp

        U: function (date) { return date.getTime() / 1000; },

        W: function (date, _, options) {

            return options.getWeek(date);

        },

        // full year e.g. 2016, padded (0001-9999)

        Y: function (date) { return pad(date.getFullYear(), 4); },

        // day in month, padded (01-30)

        d: function (date) { return pad(date.getDate()); },

        // hour from 1-12 (am/pm)

        h: function (date) { return (date.getHours() % 12 ? date.getHours() % 12 : 12); },

        // minutes, padded with leading zero e.g. 09

        i: function (date) { return pad(date.getMinutes()); },

        // day in month (1-30)

        j: function (date) { return date.getDate(); },

        // weekday name, full, e.g. Thursday

        l: function (date, locale) {

            return locale.weekdays.longhand[date.getDay()];

        },

        // padded month number (01-12)

        m: function (date) { return pad(date.getMonth() + 1); },

        // the month number (1-12)

        n: function (date) { return date.getMonth() + 1; },

        // seconds 0-59

        s: function (date) { return date.getSeconds(); },

        // Unix Milliseconds

        u: function (date) { return date.getTime(); },

        // number of the day of the week

        w: function (date) { return date.getDay(); },

        // last two digits of year e.g. 16 for 2016

        y: function (date) { return String(date.getFullYear()).substring(2); },

    };



    var createDateFormatter = function (_a) {

        var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c, _d = _a.isMobile, isMobile = _d === void 0 ? false : _d;

        return function (dateObj, frmt, overrideLocale) {

            var locale = overrideLocale || l10n;

            if (config.formatDate !== undefined && !isMobile) {

                return config.formatDate(dateObj, frmt, locale);

            }

            return frmt

                .split("")

                .map(function (c, i, arr) {

                return formats[c] && arr[i - 1] !== "\\"

                    ? formats[c](dateObj, locale, config)

                    : c !== "\\"

                        ? c

                        : "";

            })

                .join("");

        };

    };

    var createDateParser = function (_a) {

        var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c;

        return function (date, givenFormat, timeless, customLocale) {

            if (date !== 0 && !date)

                return undefined;

            var locale = customLocale || l10n;

            var parsedDate;

            var dateOrig = date;

            if (date instanceof Date)

                parsedDate = new Date(date.getTime());

            else if (typeof date !== "string" &&

                date.toFixed !== undefined // timestamp

            )

                // create a copy

                parsedDate = new Date(date);

            else if (typeof date === "string") {

                // date string

                var format = givenFormat || (config || defaults).dateFormat;

                var datestr = String(date).trim();

                if (datestr === "today") {

                    parsedDate = new Date();

                    timeless = true;

                }

                else if (/Z$/.test(datestr) ||

                    /GMT$/.test(datestr) // datestrings w/ timezone

                )

                    parsedDate = new Date(date);

                else if (config && config.parseDate)

                    parsedDate = config.parseDate(date, format);

                else {

                    parsedDate =

                        !config || !config.noCalendar

                            ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0)

                            : new Date(new Date().setHours(0, 0, 0, 0));

                    var matched = void 0, ops = [];

                    for (var i = 0, matchIndex = 0, regexStr = ""; i < format.length; i++) {

                        var token_1 = format[i];

                        var isBackSlash = token_1 === "\\";

                        var escaped = format[i - 1] === "\\" || isBackSlash;

                        if (tokenRegex[token_1] && !escaped) {

                            regexStr += tokenRegex[token_1];

                            var match = new RegExp(regexStr).exec(date);

                            if (match && (matched = true)) {

                                ops[token_1 !== "Y" ? "push" : "unshift"]({

                                    fn: revFormat[token_1],

                                    val: match[++matchIndex],

                                });

                            }

                        }

                        else if (!isBackSlash)

                            regexStr += "."; // don't really care

                        ops.forEach(function (_a) {

                            var fn = _a.fn, val = _a.val;

                            return (parsedDate = fn(parsedDate, val, locale) || parsedDate);

                        });

                    }

                    parsedDate = matched ? parsedDate : undefined;

                }

            }

            /* istanbul ignore next */

            if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {

                config.errorHandler(new Error("Invalid date provided: " + dateOrig));

                return undefined;

            }

            if (timeless === true)

                parsedDate.setHours(0, 0, 0, 0);

            return parsedDate;

        };

    };

    /**

     * Compute the difference in dates, measured in ms

     */

    function compareDates(date1, date2, timeless) {

        if (timeless === void 0) { timeless = true; }

        if (timeless !== false) {

            return (new Date(date1.getTime()).setHours(0, 0, 0, 0) -

                new Date(date2.getTime()).setHours(0, 0, 0, 0));

        }

        return date1.getTime() - date2.getTime();

    }

    var isBetween = function (ts, ts1, ts2) {

        return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);

    };

    var duration = {

        DAY: 86400000,

    };

    function getDefaultHours(config) {

        var hours = config.defaultHour;

        var minutes = config.defaultMinute;

        var seconds = config.defaultSeconds;

        if (config.minDate !== undefined) {

            var minHour = config.minDate.getHours();

            var minMinutes = config.minDate.getMinutes();

            var minSeconds = config.minDate.getSeconds();

            if (hours < minHour) {

                hours = minHour;

            }

            if (hours === minHour && minutes < minMinutes) {

                minutes = minMinutes;

            }

            if (hours === minHour && minutes === minMinutes && seconds < minSeconds)

                seconds = config.minDate.getSeconds();

        }

        if (config.maxDate !== undefined) {

            var maxHr = config.maxDate.getHours();

            var maxMinutes = config.maxDate.getMinutes();

            hours = Math.min(hours, maxHr);

            if (hours === maxHr)

                minutes = Math.min(maxMinutes, minutes);

            if (hours === maxHr && minutes === maxMinutes)

                seconds = config.maxDate.getSeconds();

        }

        return { hours: hours, minutes: minutes, seconds: seconds };

    }



    if (typeof Object.assign !== "function") {

        Object.assign = function (target) {

            var args = [];

            for (var _i = 1; _i < arguments.length; _i++) {

                args[_i - 1] = arguments[_i];

            }

            if (!target) {

                throw TypeError("Cannot convert undefined or null to object");

            }

            var _loop_1 = function (source) {

                if (source) {

                    Object.keys(source).forEach(function (key) { return (target[key] = source[key]); });

                }

            };

            for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {

                var source = args_1[_a];

                _loop_1(source);

            }

            return target;

        };

    }



    var DEBOUNCED_CHANGE_MS = 300;

    function FlatpickrInstance(element, instanceConfig) {

        var self = {

            config: __assign(__assign({}, defaults), flatpickr.defaultConfig),

            l10n: english,

        };

        self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });

        self._handlers = [];

        self.pluginElements = [];

        self.loadedPlugins = [];

        self._bind = bind;

        self._setHoursFromDate = setHoursFromDate;

        self._positionCalendar = positionCalendar;

        self.changeMonth = changeMonth;

        self.changeYear = changeYear;

        self.clear = clear;

        self.close = close;

        self._createElement = createElement;

        self.destroy = destroy;

        self.isEnabled = isEnabled;

        self.jumpToDate = jumpToDate;

        self.open = open;

        self.redraw = redraw;

        self.set = set;

        self.setDate = setDate;

        self.toggle = toggle;

        function setupHelperFunctions() {

            self.utils = {

                getDaysInMonth: function (month, yr) {

                    if (month === void 0) { month = self.currentMonth; }

                    if (yr === void 0) { yr = self.currentYear; }

                    if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))

                        return 29;

                    return self.l10n.daysInMonth[month];

                },

            };

        }

        function init() {

            self.element = self.input = element;

            self.isOpen = false;

            parseConfig();

            setupLocale();

            setupInputs();

            setupDates();

            setupHelperFunctions();

            if (!self.isMobile)

                build();

            bindEvents();

            if (self.selectedDates.length || self.config.noCalendar) {

                if (self.config.enableTime) {

                    setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj : undefined);

                }

                updateValue(false);

            }

            setCalendarWidth();

            var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);

            /* TODO: investigate this further



              Currently, there is weird positioning behavior in safari causing pages

              to scroll up. https://github.com/chmln/flatpickr/issues/563



              However, most browsers are not Safari and positioning is expensive when used

              in scale. https://github.com/chmln/flatpickr/issues/1096

            */

            if (!self.isMobile && isSafari) {

                positionCalendar();

            }

            triggerEvent("onReady");

        }

        function bindToInstance(fn) {

            return fn.bind(self);

        }

        function setCalendarWidth() {

            var config = self.config;

            if (config.weekNumbers === false && config.showMonths === 1) {

                return;

            }

            else if (config.noCalendar !== true) {

                window.requestAnimationFrame(function () {

                    if (self.calendarContainer !== undefined) {

                        self.calendarContainer.style.visibility = "hidden";

                        self.calendarContainer.style.display = "block";

                    }

                    if (self.daysContainer !== undefined) {

                        var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;

                        self.daysContainer.style.width = daysWidth + "px";

                        self.calendarContainer.style.width =

                            daysWidth +

                                (self.weekWrapper !== undefined

                                    ? self.weekWrapper.offsetWidth

                                    : 0) +

                                "px";

                        self.calendarContainer.style.removeProperty("visibility");

                        self.calendarContainer.style.removeProperty("display");

                    }

                });

            }

        }

        /**

         * The handler for all events targeting the time inputs

         */

        function updateTime(e) {

            if (self.selectedDates.length === 0) {

                var defaultDate = self.config.minDate === undefined ||

                    compareDates(new Date(), self.config.minDate) >= 0

                    ? new Date()

                    : new Date(self.config.minDate.getTime());

                var defaults = getDefaultHours(self.config);

                defaultDate.setHours(defaults.hours, defaults.minutes, defaults.seconds, defaultDate.getMilliseconds());

                self.selectedDates = [defaultDate];

                self.latestSelectedDateObj = defaultDate;

            }

            if (e !== undefined && e.type !== "blur") {

                timeWrapper(e);

            }

            var prevValue = self._input.value;

            setHoursFromInputs();

            updateValue();

            if (self._input.value !== prevValue) {

                self._debouncedChange();

            }

        }

        function ampm2military(hour, amPM) {

            return (hour % 12) + 12 * int(amPM === self.l10n.amPM[1]);

        }

        function military2ampm(hour) {

            switch (hour % 24) {

                case 0:

                case 12:

                    return 12;

                default:

                    return hour % 12;

            }

        }

        /**

         * Syncs the selected date object time with user's time input

         */

        function setHoursFromInputs() {

            if (self.hourElement === undefined || self.minuteElement === undefined)

                return;

            var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined

                ? (parseInt(self.secondElement.value, 10) || 0) % 60

                : 0;

            if (self.amPM !== undefined) {

                hours = ampm2military(hours, self.amPM.textContent);

            }

            var limitMinHours = self.config.minTime !== undefined ||

                (self.config.minDate &&

                    self.minDateHasTime &&

                    self.latestSelectedDateObj &&

                    compareDates(self.latestSelectedDateObj, self.config.minDate, true) ===

                        0);

            var limitMaxHours = self.config.maxTime !== undefined ||

                (self.config.maxDate &&

                    self.maxDateHasTime &&

                    self.latestSelectedDateObj &&

                    compareDates(self.latestSelectedDateObj, self.config.maxDate, true) ===

                        0);

            if (limitMaxHours) {

                var maxTime = self.config.maxTime !== undefined

                    ? self.config.maxTime

                    : self.config.maxDate;

                hours = Math.min(hours, maxTime.getHours());

                if (hours === maxTime.getHours())

                    minutes = Math.min(minutes, maxTime.getMinutes());

                if (minutes === maxTime.getMinutes())

                    seconds = Math.min(seconds, maxTime.getSeconds());

            }

            if (limitMinHours) {

                var minTime = self.config.minTime !== undefined

                    ? self.config.minTime

                    : self.config.minDate;

                hours = Math.max(hours, minTime.getHours());

                if (hours === minTime.getHours() && minutes < minTime.getMinutes())

                    minutes = minTime.getMinutes();

                if (minutes === minTime.getMinutes())

                    seconds = Math.max(seconds, minTime.getSeconds());

            }

            setHours(hours, minutes, seconds);

        }

        /**

         * Syncs time input values with a date

         */

        function setHoursFromDate(dateObj) {

            var date = dateObj || self.latestSelectedDateObj;

            if (date) {

                setHours(date.getHours(), date.getMinutes(), date.getSeconds());

            }

        }

        /**

         * Sets the hours, minutes, and optionally seconds

         * of the latest selected date object and the

         * corresponding time inputs

         * @param {Number} hours the hour. whether its military

         *                 or am-pm gets inferred from config

         * @param {Number} minutes the minutes

         * @param {Number} seconds the seconds (optional)

         */

        function setHours(hours, minutes, seconds) {

            if (self.latestSelectedDateObj !== undefined) {

                self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);

            }

            if (!self.hourElement || !self.minuteElement || self.isMobile)

                return;

            self.hourElement.value = pad(!self.config.time_24hr

                ? ((12 + hours) % 12) + 12 * int(hours % 12 === 0)

                : hours);

            self.minuteElement.value = pad(minutes);

            if (self.amPM !== undefined)

                self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];

            if (self.secondElement !== undefined)

                self.secondElement.value = pad(seconds);

        }

        /**

         * Handles the year input and incrementing events

         * @param {Event} event the keyup or increment event

         */

        function onYearInput(event) {

            var eventTarget = getEventTarget(event);

            var year = parseInt(eventTarget.value) + (event.delta || 0);

            if (year / 1000 > 1 ||

                (event.key === "Enter" && !/[^\d]/.test(year.toString()))) {

                changeYear(year);

            }

        }

        /**

         * Essentially addEventListener + tracking

         * @param {Element} element the element to addEventListener to

         * @param {String} event the event name

         * @param {Function} handler the event handler

         */

        function bind(element, event, handler, options) {

            if (event instanceof Array)

                return event.forEach(function (ev) { return bind(element, ev, handler, options); });

            if (element instanceof Array)

                return element.forEach(function (el) { return bind(el, event, handler, options); });

            element.addEventListener(event, handler, options);

            self._handlers.push({

                remove: function () { return element.removeEventListener(event, handler); },

            });

        }

        function triggerChange() {

            triggerEvent("onChange");

        }

        /**

         * Adds all the necessary event listeners

         */

        function bindEvents() {

            if (self.config.wrap) {

                ["open", "close", "toggle", "clear"].forEach(function (evt) {

                    Array.prototype.forEach.call(self.element.querySelectorAll("[data-" + evt + "]"), function (el) {

                        return bind(el, "click", self[evt]);

                    });

                });

            }

            if (self.isMobile) {

                setupMobile();

                return;

            }

            var debouncedResize = debounce(onResize, 50);

            self._debouncedChange = debounce(triggerChange, DEBOUNCED_CHANGE_MS);

            if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))

                bind(self.daysContainer, "mouseover", function (e) {

                    if (self.config.mode === "range")

                        onMouseOver(getEventTarget(e));

                });

            bind(window.document.body, "keydown", onKeyDown);

            if (!self.config.inline && !self.config.static)

                bind(window, "resize", debouncedResize);

            if (window.ontouchstart !== undefined)

                bind(window.document, "touchstart", documentClick);

            else

                bind(window.document, "mousedown", documentClick);

            bind(window.document, "focus", documentClick, { capture: true });

            if (self.config.clickOpens === true) {

                bind(self._input, "focus", self.open);

                bind(self._input, "click", self.open);

            }

            if (self.daysContainer !== undefined) {

                bind(self.monthNav, "click", onMonthNavClick);

                bind(self.monthNav, ["keyup", "increment"], onYearInput);

                bind(self.daysContainer, "click", selectDate);

            }

            if (self.timeContainer !== undefined &&

                self.minuteElement !== undefined &&

                self.hourElement !== undefined) {

                var selText = function (e) {

                    return getEventTarget(e).select();

                };

                bind(self.timeContainer, ["increment"], updateTime);

                bind(self.timeContainer, "blur", updateTime, { capture: true });

                bind(self.timeContainer, "click", timeIncrement);

                bind([self.hourElement, self.minuteElement], ["focus", "click"], selText);

                if (self.secondElement !== undefined)

                    bind(self.secondElement, "focus", function () { return self.secondElement && self.secondElement.select(); });

                if (self.amPM !== undefined) {

                    bind(self.amPM, "click", function (e) {

                        updateTime(e);

                        triggerChange();

                    });

                }

            }

            if (self.config.allowInput) {

                bind(self._input, "blur", onBlur);

            }

        }

        /**

         * Set the calendar view to a particular date.

         * @param {Date} jumpDate the date to set the view to

         * @param {boolean} triggerChange if change events should be triggered

         */

        function jumpToDate(jumpDate, triggerChange) {

            var jumpTo = jumpDate !== undefined

                ? self.parseDate(jumpDate)

                : self.latestSelectedDateObj ||

                    (self.config.minDate && self.config.minDate > self.now

                        ? self.config.minDate

                        : self.config.maxDate && self.config.maxDate < self.now

                            ? self.config.maxDate

                            : self.now);

            var oldYear = self.currentYear;

            var oldMonth = self.currentMonth;

            try {

                if (jumpTo !== undefined) {

                    self.currentYear = jumpTo.getFullYear();

                    self.currentMonth = jumpTo.getMonth();

                }

            }

            catch (e) {

                /* istanbul ignore next */

                e.message = "Invalid date supplied: " + jumpTo;

                self.config.errorHandler(e);

            }

            if (triggerChange && self.currentYear !== oldYear) {

                triggerEvent("onYearChange");

                buildMonthSwitch();

            }

            if (triggerChange &&

                (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {

                triggerEvent("onMonthChange");

            }

            self.redraw();

        }

        /**

         * The up/down arrow handler for time inputs

         * @param {Event} e the click event

         */

        function timeIncrement(e) {

            var eventTarget = getEventTarget(e);

            if (~eventTarget.className.indexOf("arrow"))

                incrementNumInput(e, eventTarget.classList.contains("arrowUp") ? 1 : -1);

        }

        /**

         * Increments/decrements the value of input associ-

         * ated with the up/down arrow by dispatching an

         * "increment" event on the input.

         *

         * @param {Event} e the click event

         * @param {Number} delta the diff (usually 1 or -1)

         * @param {Element} inputElem the input element

         */

        function incrementNumInput(e, delta, inputElem) {

            var target = e && getEventTarget(e);

            var input = inputElem ||

                (target && target.parentNode && target.parentNode.firstChild);

            var event = createEvent("increment");

            event.delta = delta;

            input && input.dispatchEvent(event);

        }

        function build() {

            var fragment = window.document.createDocumentFragment();

            self.calendarContainer = createElement("div", "flatpickr-calendar");

            self.calendarContainer.tabIndex = -1;

            if (!self.config.noCalendar) {

                fragment.appendChild(buildMonthNav());

                self.innerContainer = createElement("div", "flatpickr-innerContainer");

                if (self.config.weekNumbers) {

                    var _a = buildWeeks(), weekWrapper = _a.weekWrapper, weekNumbers = _a.weekNumbers;

                    self.innerContainer.appendChild(weekWrapper);

                    self.weekNumbers = weekNumbers;

                    self.weekWrapper = weekWrapper;

                }

                self.rContainer = createElement("div", "flatpickr-rContainer");

                self.rContainer.appendChild(buildWeekdays());

                if (!self.daysContainer) {

                    self.daysContainer = createElement("div", "flatpickr-days");

                    self.daysContainer.tabIndex = -1;

                }

                buildDays();

                self.rContainer.appendChild(self.daysContainer);

                self.innerContainer.appendChild(self.rContainer);

                fragment.appendChild(self.innerContainer);

            }

            if (self.config.enableTime) {

                fragment.appendChild(buildTime());

            }

            toggleClass(self.calendarContainer, "rangeMode", self.config.mode === "range");

            toggleClass(self.calendarContainer, "animate", self.config.animate === true);

            toggleClass(self.calendarContainer, "multiMonth", self.config.showMonths > 1);

            self.calendarContainer.appendChild(fragment);

            var customAppend = self.config.appendTo !== undefined &&

                self.config.appendTo.nodeType !== undefined;

            if (self.config.inline || self.config.static) {

                self.calendarContainer.classList.add(self.config.inline ? "inline" : "static");

                if (self.config.inline) {

                    if (!customAppend && self.element.parentNode)

                        self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);

                    else if (self.config.appendTo !== undefined)

                        self.config.appendTo.appendChild(self.calendarContainer);

                }

                if (self.config.static) {

                    var wrapper = createElement("div", "flatpickr-wrapper");

                    if (self.element.parentNode)

                        self.element.parentNode.insertBefore(wrapper, self.element);

                    wrapper.appendChild(self.element);

                    if (self.altInput)

                        wrapper.appendChild(self.altInput);

                    wrapper.appendChild(self.calendarContainer);

                }

            }

            if (!self.config.static && !self.config.inline)

                (self.config.appendTo !== undefined

                    ? self.config.appendTo

                    : window.document.body).appendChild(self.calendarContainer);

        }

        function createDay(className, date, dayNumber, i) {

            var dateIsEnabled = isEnabled(date, true), dayElement = createElement("span", "flatpickr-day " + className, date.getDate().toString());

            dayElement.dateObj = date;

            dayElement.$i = i;

            dayElement.setAttribute("aria-label", self.formatDate(date, self.config.ariaDateFormat));

            if (className.indexOf("hidden") === -1 &&

                compareDates(date, self.now) === 0) {

                self.todayDateElem = dayElement;

                dayElement.classList.add("today");

                dayElement.setAttribute("aria-current", "date");

            }

            if (dateIsEnabled) {

                dayElement.tabIndex = -1;

                if (isDateSelected(date)) {

                    dayElement.classList.add("selected");

                    self.selectedDateElem = dayElement;

                    if (self.config.mode === "range") {

                        toggleClass(dayElement, "startRange", self.selectedDates[0] &&

                            compareDates(date, self.selectedDates[0], true) === 0);

                        toggleClass(dayElement, "endRange", self.selectedDates[1] &&

                            compareDates(date, self.selectedDates[1], true) === 0);

                        if (className === "nextMonthDay")

                            dayElement.classList.add("inRange");

                    }

                }

            }

            else {

                dayElement.classList.add("flatpickr-disabled");

            }

            if (self.config.mode === "range") {

                if (isDateInRange(date) && !isDateSelected(date))

                    dayElement.classList.add("inRange");

            }

            if (self.weekNumbers &&

                self.config.showMonths === 1 &&

                className !== "prevMonthDay" &&

                dayNumber % 7 === 1) {

                self.weekNumbers.insertAdjacentHTML("beforeend", "<span class='flatpickr-day'>" + self.config.getWeek(date) + "</span>");

            }

            triggerEvent("onDayCreate", dayElement);

            return dayElement;

        }

        function focusOnDayElem(targetNode) {

            targetNode.focus();

            if (self.config.mode === "range")

                onMouseOver(targetNode);

        }

        function getFirstAvailableDay(delta) {

            var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;

            var endMonth = delta > 0 ? self.config.showMonths : -1;

            for (var m = startMonth; m != endMonth; m += delta) {

                var month = self.daysContainer.children[m];

                var startIndex = delta > 0 ? 0 : month.children.length - 1;

                var endIndex = delta > 0 ? month.children.length : -1;

                for (var i = startIndex; i != endIndex; i += delta) {

                    var c = month.children[i];

                    if (c.className.indexOf("hidden") === -1 && isEnabled(c.dateObj))

                        return c;

                }

            }

            return undefined;

        }

        function getNextAvailableDay(current, delta) {

            var givenMonth = current.className.indexOf("Month") === -1

                ? current.dateObj.getMonth()

                : self.currentMonth;

            var endMonth = delta > 0 ? self.config.showMonths : -1;

            var loopDelta = delta > 0 ? 1 : -1;

            for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {

                var month = self.daysContainer.children[m];

                var startIndex = givenMonth - self.currentMonth === m

                    ? current.$i + delta

                    : delta < 0

                        ? month.children.length - 1

                        : 0;

                var numMonthDays = month.children.length;

                for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {

                    var c = month.children[i];

                    if (c.className.indexOf("hidden") === -1 &&

                        isEnabled(c.dateObj) &&

                        Math.abs(current.$i - i) >= Math.abs(delta))

                        return focusOnDayElem(c);

                }

            }

            self.changeMonth(loopDelta);

            focusOnDay(getFirstAvailableDay(loopDelta), 0);

            return undefined;

        }

        function focusOnDay(current, offset) {

            var dayFocused = isInView(document.activeElement || document.body);

            var startElem = current !== undefined

                ? current

                : dayFocused

                    ? document.activeElement

                    : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)

                        ? self.selectedDateElem

                        : self.todayDateElem !== undefined && isInView(self.todayDateElem)

                            ? self.todayDateElem

                            : getFirstAvailableDay(offset > 0 ? 1 : -1);

            if (startElem === undefined) {

                self._input.focus();

            }

            else if (!dayFocused) {

                focusOnDayElem(startElem);

            }

            else {

                getNextAvailableDay(startElem, offset);

            }

        }

        function buildMonthDays(year, month) {

            var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;

            var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12, year);

            var daysInMonth = self.utils.getDaysInMonth(month, year), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? "prevMonthDay hidden" : "prevMonthDay", nextMonthDayClass = isMultiMonth ? "nextMonthDay hidden" : "nextMonthDay";

            var dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;

            // prepend days from the ending of previous month

            for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {

                days.appendChild(createDay(prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));

            }

            // Start at 1 since there is no 0th day

            for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {

                days.appendChild(createDay("", new Date(year, month, dayNumber), dayNumber, dayIndex));

            }

            // append days from the next month

            for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&

                (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {

                days.appendChild(createDay(nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));

            }

            //updateNavigationCurrentMonth();

            var dayContainer = createElement("div", "dayContainer");

            dayContainer.appendChild(days);

            return dayContainer;

        }

        function buildDays() {

            if (self.daysContainer === undefined) {

                return;

            }

            clearNode(self.daysContainer);

            // TODO: week numbers for each month

            if (self.weekNumbers)

                clearNode(self.weekNumbers);

            var frag = document.createDocumentFragment();

            for (var i = 0; i < self.config.showMonths; i++) {

                var d = new Date(self.currentYear, self.currentMonth, 1);

                d.setMonth(self.currentMonth + i);

                frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));

            }

            self.daysContainer.appendChild(frag);

            self.days = self.daysContainer.firstChild;

            if (self.config.mode === "range" && self.selectedDates.length === 1) {

                onMouseOver();

            }

        }

        function buildMonthSwitch() {

            if (self.config.showMonths > 1 ||

                self.config.monthSelectorType !== "dropdown")

                return;

            var shouldBuildMonth = function (month) {

                if (self.config.minDate !== undefined &&

                    self.currentYear === self.config.minDate.getFullYear() &&

                    month < self.config.minDate.getMonth()) {

                    return false;

                }

                return !(self.config.maxDate !== undefined &&

                    self.currentYear === self.config.maxDate.getFullYear() &&

                    month > self.config.maxDate.getMonth());

            };

            self.monthsDropdownContainer.tabIndex = -1;

            self.monthsDropdownContainer.innerHTML = "";

            for (var i = 0; i < 12; i++) {

                if (!shouldBuildMonth(i))

                    continue;

                var month = createElement("option", "flatpickr-monthDropdown-month");

                month.value = new Date(self.currentYear, i).getMonth().toString();

                month.textContent = monthToStr(i, self.config.shorthandCurrentMonth, self.l10n);

                month.tabIndex = -1;

                if (self.currentMonth === i) {

                    month.selected = true;

                }

                self.monthsDropdownContainer.appendChild(month);

            }

        }

        function buildMonth() {

            var container = createElement("div", "flatpickr-month");

            var monthNavFragment = window.document.createDocumentFragment();

            var monthElement;

            if (self.config.showMonths > 1 ||

                self.config.monthSelectorType === "static") {

                monthElement = createElement("span", "cur-month");

            }

            else {

                self.monthsDropdownContainer = createElement("select", "flatpickr-monthDropdown-months");

                self.monthsDropdownContainer.setAttribute("aria-label", self.l10n.monthAriaLabel);

                bind(self.monthsDropdownContainer, "change", function (e) {

                    var target = getEventTarget(e);

                    var selectedMonth = parseInt(target.value, 10);

                    self.changeMonth(selectedMonth - self.currentMonth);

                    triggerEvent("onMonthChange");

                });

                buildMonthSwitch();

                monthElement = self.monthsDropdownContainer;

            }

            var yearInput = createNumberInput("cur-year", { tabindex: "-1" });

            var yearElement = yearInput.getElementsByTagName("input")[0];

            yearElement.setAttribute("aria-label", self.l10n.yearAriaLabel);

            if (self.config.minDate) {

                yearElement.setAttribute("min", self.config.minDate.getFullYear().toString());

            }

            if (self.config.maxDate) {

                yearElement.setAttribute("max", self.config.maxDate.getFullYear().toString());

                yearElement.disabled =

                    !!self.config.minDate &&

                        self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();

            }

            var currentMonth = createElement("div", "flatpickr-current-month");

            currentMonth.appendChild(monthElement);

            currentMonth.appendChild(yearInput);

            monthNavFragment.appendChild(currentMonth);

            container.appendChild(monthNavFragment);

            return {

                container: container,

                yearElement: yearElement,

                monthElement: monthElement,

            };

        }

        function buildMonths() {

            clearNode(self.monthNav);

            self.monthNav.appendChild(self.prevMonthNav);

            if (self.config.showMonths) {

                self.yearElements = [];

                self.monthElements = [];

            }

            for (var m = self.config.showMonths; m--;) {

                var month = buildMonth();

                self.yearElements.push(month.yearElement);

                self.monthElements.push(month.monthElement);

                self.monthNav.appendChild(month.container);

            }

            self.monthNav.appendChild(self.nextMonthNav);

        }

        function buildMonthNav() {

            self.monthNav = createElement("div", "flatpickr-months");

            self.yearElements = [];

            self.monthElements = [];

            self.prevMonthNav = createElement("span", "flatpickr-prev-month");

            self.prevMonthNav.innerHTML = self.config.prevArrow;

            self.nextMonthNav = createElement("span", "flatpickr-next-month");

            self.nextMonthNav.innerHTML = self.config.nextArrow;

            buildMonths();

            Object.defineProperty(self, "_hidePrevMonthArrow", {

                get: function () { return self.__hidePrevMonthArrow; },

                set: function (bool) {

                    if (self.__hidePrevMonthArrow !== bool) {

                        toggleClass(self.prevMonthNav, "flatpickr-disabled", bool);

                        self.__hidePrevMonthArrow = bool;

                    }

                },

            });

            Object.defineProperty(self, "_hideNextMonthArrow", {

                get: function () { return self.__hideNextMonthArrow; },

                set: function (bool) {

                    if (self.__hideNextMonthArrow !== bool) {

                        toggleClass(self.nextMonthNav, "flatpickr-disabled", bool);

                        self.__hideNextMonthArrow = bool;

                    }

                },

            });

            self.currentYearElement = self.yearElements[0];

            updateNavigationCurrentMonth();

            return self.monthNav;

        }

        function buildTime() {

            self.calendarContainer.classList.add("hasTime");

            if (self.config.noCalendar)

                self.calendarContainer.classList.add("noCalendar");

            var defaults = getDefaultHours(self.config);

            self.timeContainer = createElement("div", "flatpickr-time");

            self.timeContainer.tabIndex = -1;

            var separator = createElement("span", "flatpickr-time-separator", ":");

            var hourInput = createNumberInput("flatpickr-hour", {

                "aria-label": self.l10n.hourAriaLabel,

            });

            self.hourElement = hourInput.getElementsByTagName("input")[0];

            var minuteInput = createNumberInput("flatpickr-minute", {

                "aria-label": self.l10n.minuteAriaLabel,

            });

            self.minuteElement = minuteInput.getElementsByTagName("input")[0];

            self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;

            self.hourElement.value = pad(self.latestSelectedDateObj

                ? self.latestSelectedDateObj.getHours()

                : self.config.time_24hr

                    ? defaults.hours

                    : military2ampm(defaults.hours));

            self.minuteElement.value = pad(self.latestSelectedDateObj

                ? self.latestSelectedDateObj.getMinutes()

                : defaults.minutes);

            self.hourElement.setAttribute("step", self.config.hourIncrement.toString());

            self.minuteElement.setAttribute("step", self.config.minuteIncrement.toString());

            self.hourElement.setAttribute("min", self.config.time_24hr ? "0" : "1");

            self.hourElement.setAttribute("max", self.config.time_24hr ? "23" : "12");

            self.hourElement.setAttribute("maxlength", "2");

            self.minuteElement.setAttribute("min", "0");

            self.minuteElement.setAttribute("max", "59");

            self.minuteElement.setAttribute("maxlength", "2");

            self.timeContainer.appendChild(hourInput);

            self.timeContainer.appendChild(separator);

            self.timeContainer.appendChild(minuteInput);

            if (self.config.time_24hr)

                self.timeContainer.classList.add("time24hr");

            if (self.config.enableSeconds) {

                self.timeContainer.classList.add("hasSeconds");

                var secondInput = createNumberInput("flatpickr-second");

                self.secondElement = secondInput.getElementsByTagName("input")[0];

                self.secondElement.value = pad(self.latestSelectedDateObj

                    ? self.latestSelectedDateObj.getSeconds()

                    : defaults.seconds);

                self.secondElement.setAttribute("step", self.minuteElement.getAttribute("step"));

                self.secondElement.setAttribute("min", "0");

                self.secondElement.setAttribute("max", "59");

                self.secondElement.setAttribute("maxlength", "2");

                self.timeContainer.appendChild(createElement("span", "flatpickr-time-separator", ":"));

                self.timeContainer.appendChild(secondInput);

            }

            if (!self.config.time_24hr) {

                // add self.amPM if appropriate

                self.amPM = createElement("span", "flatpickr-am-pm", self.l10n.amPM[int((self.latestSelectedDateObj

                    ? self.hourElement.value

                    : self.config.defaultHour) > 11)]);

                self.amPM.title = self.l10n.toggleTitle;

                self.amPM.tabIndex = -1;

                self.timeContainer.appendChild(self.amPM);

            }

            return self.timeContainer;

        }

        function buildWeekdays() {

            if (!self.weekdayContainer)

                self.weekdayContainer = createElement("div", "flatpickr-weekdays");

            else

                clearNode(self.weekdayContainer);

            for (var i = self.config.showMonths; i--;) {

                var container = createElement("div", "flatpickr-weekdaycontainer");

                self.weekdayContainer.appendChild(container);

            }

            updateWeekdays();

            return self.weekdayContainer;

        }

        function updateWeekdays() {

            if (!self.weekdayContainer) {

                return;

            }

            var firstDayOfWeek = self.l10n.firstDayOfWeek;

            var weekdays = __spreadArrays(self.l10n.weekdays.shorthand);

            if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {

                weekdays = __spreadArrays(weekdays.splice(firstDayOfWeek, weekdays.length), weekdays.splice(0, firstDayOfWeek));

            }

            for (var i = self.config.showMonths; i--;) {

                self.weekdayContainer.children[i].innerHTML = "\n      <span class='flatpickr-weekday'>\n        " + weekdays.join("</span><span class='flatpickr-weekday'>") + "\n      </span>\n      ";

            }

        }

        /* istanbul ignore next */

        function buildWeeks() {

            self.calendarContainer.classList.add("hasWeeks");

            var weekWrapper = createElement("div", "flatpickr-weekwrapper");

            weekWrapper.appendChild(createElement("span", "flatpickr-weekday", self.l10n.weekAbbreviation));

            var weekNumbers = createElement("div", "flatpickr-weeks");

            weekWrapper.appendChild(weekNumbers);

            return {

                weekWrapper: weekWrapper,

                weekNumbers: weekNumbers,

            };

        }

        function changeMonth(value, isOffset) {

            if (isOffset === void 0) { isOffset = true; }

            var delta = isOffset ? value : value - self.currentMonth;

            if ((delta < 0 && self._hidePrevMonthArrow === true) ||

                (delta > 0 && self._hideNextMonthArrow === true))

                return;

            self.currentMonth += delta;

            if (self.currentMonth < 0 || self.currentMonth > 11) {

                self.currentYear += self.currentMonth > 11 ? 1 : -1;

                self.currentMonth = (self.currentMonth + 12) % 12;

                triggerEvent("onYearChange");

                buildMonthSwitch();

            }

            buildDays();

            triggerEvent("onMonthChange");

            updateNavigationCurrentMonth();

        }

        function clear(triggerChangeEvent, toInitial) {

            if (triggerChangeEvent === void 0) { triggerChangeEvent = true; }

            if (toInitial === void 0) { toInitial = true; }

            self.input.value = "";

            if (self.altInput !== undefined)

                self.altInput.value = "";

            if (self.mobileInput !== undefined)

                self.mobileInput.value = "";

            self.selectedDates = [];

            self.latestSelectedDateObj = undefined;

            if (toInitial === true) {

                self.currentYear = self._initialDate.getFullYear();

                self.currentMonth = self._initialDate.getMonth();

            }

            if (self.config.enableTime === true) {

                var _a = getDefaultHours(self.config), hours = _a.hours, minutes = _a.minutes, seconds = _a.seconds;

                setHours(hours, minutes, seconds);

            }

            self.redraw();

            if (triggerChangeEvent)

                // triggerChangeEvent is true (default) or an Event

                triggerEvent("onChange");

        }

        function close() {

            self.isOpen = false;

            if (!self.isMobile) {

                if (self.calendarContainer !== undefined) {

                    self.calendarContainer.classList.remove("open");

                }

                if (self._input !== undefined) {

                    self._input.classList.remove("active");

                }

            }

            triggerEvent("onClose");

        }

        function destroy() {

            if (self.config !== undefined)

                triggerEvent("onDestroy");

            for (var i = self._handlers.length; i--;) {

                self._handlers[i].remove();

            }

            self._handlers = [];

            if (self.mobileInput) {

                if (self.mobileInput.parentNode)

                    self.mobileInput.parentNode.removeChild(self.mobileInput);

                self.mobileInput = undefined;

            }

            else if (self.calendarContainer && self.calendarContainer.parentNode) {

                if (self.config.static && self.calendarContainer.parentNode) {

                    var wrapper = self.calendarContainer.parentNode;

                    wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);

                    if (wrapper.parentNode) {

                        while (wrapper.firstChild)

                            wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);

                        wrapper.parentNode.removeChild(wrapper);

                    }

                }

                else

                    self.calendarContainer.parentNode.removeChild(self.calendarContainer);

            }

            if (self.altInput) {

                self.input.type = "text";

                if (self.altInput.parentNode)

                    self.altInput.parentNode.removeChild(self.altInput);

                delete self.altInput;

            }

            if (self.input) {

                self.input.type = self.input._type;

                self.input.classList.remove("flatpickr-input");

                self.input.removeAttribute("readonly");

            }

            [

                "_showTimeInput",

                "latestSelectedDateObj",

                "_hideNextMonthArrow",

                "_hidePrevMonthArrow",

                "__hideNextMonthArrow",

                "__hidePrevMonthArrow",

                "isMobile",

                "isOpen",

                "selectedDateElem",

                "minDateHasTime",

                "maxDateHasTime",

                "days",

                "daysContainer",

                "_input",

                "_positionElement",

                "innerContainer",

                "rContainer",

                "monthNav",

                "todayDateElem",

                "calendarContainer",

                "weekdayContainer",

                "prevMonthNav",

                "nextMonthNav",

                "monthsDropdownContainer",

                "currentMonthElement",

                "currentYearElement",

                "navigationCurrentMonth",

                "selectedDateElem",

                "config",

            ].forEach(function (k) {

                try {

                    delete self[k];

                }

                catch (_) { }

            });

        }

        function isCalendarElem(elem) {

            if (self.config.appendTo && self.config.appendTo.contains(elem))

                return true;

            return self.calendarContainer.contains(elem);

        }

        function documentClick(e) {

            if (self.isOpen && !self.config.inline) {

                var eventTarget_1 = getEventTarget(e);

                var isCalendarElement = isCalendarElem(eventTarget_1);

                var isInput = eventTarget_1 === self.input ||

                    eventTarget_1 === self.altInput ||

                    self.element.contains(eventTarget_1) ||

                    // web components

                    // e.path is not present in all browsers. circumventing typechecks

                    (e.path &&

                        e.path.indexOf &&

                        (~e.path.indexOf(self.input) ||

                            ~e.path.indexOf(self.altInput)));

                var lostFocus = e.type === "blur"

                    ? isInput &&

                        e.relatedTarget &&

                        !isCalendarElem(e.relatedTarget)

                    : !isInput &&

                        !isCalendarElement &&

                        !isCalendarElem(e.relatedTarget);

                var isIgnored = !self.config.ignoredFocusElements.some(function (elem) {

                    return elem.contains(eventTarget_1);

                });

                if (lostFocus && isIgnored) {

                    if (self.timeContainer !== undefined &&

                        self.minuteElement !== undefined &&

                        self.hourElement !== undefined &&

                        self.input.value !== "" &&

                        self.input.value !== undefined) {

                        updateTime();

                    }

                    self.close();

                    if (self.config &&

                        self.config.mode === "range" &&

                        self.selectedDates.length === 1) {

                        self.clear(false);

                        self.redraw();

                    }

                }

            }

        }

        function changeYear(newYear) {

            if (!newYear ||

                (self.config.minDate && newYear < self.config.minDate.getFullYear()) ||

                (self.config.maxDate && newYear > self.config.maxDate.getFullYear()))

                return;

            var newYearNum = newYear, isNewYear = self.currentYear !== newYearNum;

            self.currentYear = newYearNum || self.currentYear;

            if (self.config.maxDate &&

                self.currentYear === self.config.maxDate.getFullYear()) {

                self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);

            }

            else if (self.config.minDate &&

                self.currentYear === self.config.minDate.getFullYear()) {

                self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);

            }

            if (isNewYear) {

                self.redraw();

                triggerEvent("onYearChange");

                buildMonthSwitch();

            }

        }

        function isEnabled(date, timeless) {

            var _a;

            if (timeless === void 0) { timeless = true; }

            var dateToCheck = self.parseDate(date, undefined, timeless); // timeless

            if ((self.config.minDate &&

                dateToCheck &&

                compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0) ||

                (self.config.maxDate &&

                    dateToCheck &&

                    compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0))

                return false;

            if (!self.config.enable && self.config.disable.length === 0)

                return true;

            if (dateToCheck === undefined)

                return false;

            var bool = !!self.config.enable, array = (_a = self.config.enable) !== null && _a !== void 0 ? _a : self.config.disable;

            for (var i = 0, d = void 0; i < array.length; i++) {

                d = array[i];

                if (typeof d === "function" &&

                    d(dateToCheck) // disabled by function

                )

                    return bool;

                else if (d instanceof Date &&

                    dateToCheck !== undefined &&

                    d.getTime() === dateToCheck.getTime())

                    // disabled by date

                    return bool;

                else if (typeof d === "string") {

                    // disabled by date string

                    var parsed = self.parseDate(d, undefined, true);

                    return parsed && parsed.getTime() === dateToCheck.getTime()

                        ? bool

                        : !bool;

                }

                else if (

                // disabled by range

                typeof d === "object" &&

                    dateToCheck !== undefined &&

                    d.from &&

                    d.to &&

                    dateToCheck.getTime() >= d.from.getTime() &&

                    dateToCheck.getTime() <= d.to.getTime())

                    return bool;

            }

            return !bool;

        }

        function isInView(elem) {

            if (self.daysContainer !== undefined)

                return (elem.className.indexOf("hidden") === -1 &&

                    elem.className.indexOf("flatpickr-disabled") === -1 &&

                    self.daysContainer.contains(elem));

            return false;

        }

        function onBlur(e) {

            var isInput = e.target === self._input;

            if (isInput &&

                (self.selectedDates.length > 0 || self._input.value.length > 0) &&

                !(e.relatedTarget && isCalendarElem(e.relatedTarget))) {

                self.setDate(self._input.value, true, e.target === self.altInput

                    ? self.config.altFormat

                    : self.config.dateFormat);

            }

        }

        function onKeyDown(e) {

            // e.key                      e.keyCode

            // "Backspace"                        8

            // "Tab"                              9

            // "Enter"                           13

            // "Escape"     (IE "Esc")           27

            // "ArrowLeft"  (IE "Left")          37

            // "ArrowUp"    (IE "Up")            38

            // "ArrowRight" (IE "Right")         39

            // "ArrowDown"  (IE "Down")          40

            // "Delete"     (IE "Del")           46

            var eventTarget = getEventTarget(e);

            var isInput = self.config.wrap

                ? element.contains(eventTarget)

                : eventTarget === self._input;

            var allowInput = self.config.allowInput;

            var allowKeydown = self.isOpen && (!allowInput || !isInput);

            var allowInlineKeydown = self.config.inline && isInput && !allowInput;

            if (e.keyCode === 13 && isInput) {

                if (allowInput) {

                    self.setDate(self._input.value, true, eventTarget === self.altInput

                        ? self.config.altFormat

                        : self.config.dateFormat);

                    return eventTarget.blur();

                }

                else {

                    self.open();

                }

            }

            else if (isCalendarElem(eventTarget) ||

                allowKeydown ||

                allowInlineKeydown) {

                var isTimeObj = !!self.timeContainer &&

                    self.timeContainer.contains(eventTarget);

                switch (e.keyCode) {

                    case 13:

                        if (isTimeObj) {

                            e.preventDefault();

                            updateTime();

                            focusAndClose();

                        }

                        else

                            selectDate(e);

                        break;

                    case 27: // escape

                        e.preventDefault();

                        focusAndClose();

                        break;

                    case 8:

                    case 46:

                        if (isInput && !self.config.allowInput) {

                            e.preventDefault();

                            self.clear();

                        }

                        break;

                    case 37:

                    case 39:

                        if (!isTimeObj && !isInput) {

                            e.preventDefault();

                            if (self.daysContainer !== undefined &&

                                (allowInput === false ||

                                    (document.activeElement && isInView(document.activeElement)))) {

                                var delta_1 = e.keyCode === 39 ? 1 : -1;

                                if (!e.ctrlKey)

                                    focusOnDay(undefined, delta_1);

                                else {

                                    e.stopPropagation();

                                    changeMonth(delta_1);

                                    focusOnDay(getFirstAvailableDay(1), 0);

                                }

                            }

                        }

                        else if (self.hourElement)

                            self.hourElement.focus();

                        break;

                    case 38:

                    case 40:

                        e.preventDefault();

                        var delta = e.keyCode === 40 ? 1 : -1;

                        if ((self.daysContainer &&

                            eventTarget.$i !== undefined) ||

                            eventTarget === self.input ||

                            eventTarget === self.altInput) {

                            if (e.ctrlKey) {

                                e.stopPropagation();

                                changeYear(self.currentYear - delta);

                                focusOnDay(getFirstAvailableDay(1), 0);

                            }

                            else if (!isTimeObj)

                                focusOnDay(undefined, delta * 7);

                        }

                        else if (eventTarget === self.currentYearElement) {

                            changeYear(self.currentYear - delta);

                        }

                        else if (self.config.enableTime) {

                            if (!isTimeObj && self.hourElement)

                                self.hourElement.focus();

                            updateTime(e);

                            self._debouncedChange();

                        }

                        break;

                    case 9:

                        if (isTimeObj) {

                            var elems = [

                                self.hourElement,

                                self.minuteElement,

                                self.secondElement,

                                self.amPM,

                            ]

                                .concat(self.pluginElements)

                                .filter(function (x) { return x; });

                            var i = elems.indexOf(eventTarget);

                            if (i !== -1) {

                                var target = elems[i + (e.shiftKey ? -1 : 1)];

                                e.preventDefault();

                                (target || self._input).focus();

                            }

                        }

                        else if (!self.config.noCalendar &&

                            self.daysContainer &&

                            self.daysContainer.contains(eventTarget) &&

                            e.shiftKey) {

                            e.preventDefault();

                            self._input.focus();

                        }

                        break;

                }

            }

            if (self.amPM !== undefined && eventTarget === self.amPM) {

                switch (e.key) {

                    case self.l10n.amPM[0].charAt(0):

                    case self.l10n.amPM[0].charAt(0).toLowerCase():

                        self.amPM.textContent = self.l10n.amPM[0];

                        setHoursFromInputs();

                        updateValue();

                        break;

                    case self.l10n.amPM[1].charAt(0):

                    case self.l10n.amPM[1].charAt(0).toLowerCase():

                        self.amPM.textContent = self.l10n.amPM[1];

                        setHoursFromInputs();

                        updateValue();

                        break;

                }

            }

            if (isInput || isCalendarElem(eventTarget)) {

                triggerEvent("onKeyDown", e);

            }

        }

        function onMouseOver(elem) {

            if (self.selectedDates.length !== 1 ||

                (elem &&

                    (!elem.classList.contains("flatpickr-day") ||

                        elem.classList.contains("flatpickr-disabled"))))

                return;

            var hoverDate = elem

                ? elem.dateObj.getTime()

                : self.days.firstElementChild.dateObj.getTime(), initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(), rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()), rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());

            var containsDisabled = false;

            var minRange = 0, maxRange = 0;

            for (var t = rangeStartDate; t < rangeEndDate; t += duration.DAY) {

                if (!isEnabled(new Date(t), true)) {

                    containsDisabled =

                        containsDisabled || (t > rangeStartDate && t < rangeEndDate);

                    if (t < initialDate && (!minRange || t > minRange))

                        minRange = t;

                    else if (t > initialDate && (!maxRange || t < maxRange))

                        maxRange = t;

                }

            }

            for (var m = 0; m < self.config.showMonths; m++) {

                var month = self.daysContainer.children[m];

                var _loop_1 = function (i, l) {

                    var dayElem = month.children[i], date = dayElem.dateObj;

                    var timestamp = date.getTime();

                    var outOfRange = (minRange > 0 && timestamp < minRange) ||

                        (maxRange > 0 && timestamp > maxRange);

                    if (outOfRange) {

                        dayElem.classList.add("notAllowed");

                        ["inRange", "startRange", "endRange"].forEach(function (c) {

                            dayElem.classList.remove(c);

                        });

                        return "continue";

                    }

                    else if (containsDisabled && !outOfRange)

                        return "continue";

                    ["startRange", "inRange", "endRange", "notAllowed"].forEach(function (c) {

                        dayElem.classList.remove(c);

                    });

                    if (elem !== undefined) {

                        elem.classList.add(hoverDate <= self.selectedDates[0].getTime()

                            ? "startRange"

                            : "endRange");

                        if (initialDate < hoverDate && timestamp === initialDate)

                            dayElem.classList.add("startRange");

                        else if (initialDate > hoverDate && timestamp === initialDate)

                            dayElem.classList.add("endRange");

                        if (timestamp >= minRange &&

                            (maxRange === 0 || timestamp <= maxRange) &&

                            isBetween(timestamp, initialDate, hoverDate))

                            dayElem.classList.add("inRange");

                    }

                };

                for (var i = 0, l = month.children.length; i < l; i++) {

                    _loop_1(i, l);

                }

            }

        }

        function onResize() {

            if (self.isOpen && !self.config.static && !self.config.inline)

                positionCalendar();

        }

        function open(e, positionElement) {

            if (positionElement === void 0) { positionElement = self._positionElement; }

            if (self.isMobile === true) {

                if (e) {

                    e.preventDefault();

                    var eventTarget = getEventTarget(e);

                    if (eventTarget) {

                        eventTarget.blur();

                    }

                }

                if (self.mobileInput !== undefined) {

                    self.mobileInput.focus();

                    self.mobileInput.click();

                }

                triggerEvent("onOpen");

                return;

            }

            else if (self._input.disabled || self.config.inline) {

                return;

            }

            var wasOpen = self.isOpen;

            self.isOpen = true;

            if (!wasOpen) {

                self.calendarContainer.classList.add("open");

                self._input.classList.add("active");

                triggerEvent("onOpen");

                positionCalendar(positionElement);

            }

            if (self.config.enableTime === true && self.config.noCalendar === true) {

                if (self.config.allowInput === false &&

                    (e === undefined ||

                        !self.timeContainer.contains(e.relatedTarget))) {

                    setTimeout(function () { return self.hourElement.select(); }, 50);

                }

            }

        }

        function minMaxDateSetter(type) {

            return function (date) {

                var dateObj = (self.config["_" + type + "Date"] = self.parseDate(date, self.config.dateFormat));

                var inverseDateObj = self.config["_" + (type === "min" ? "max" : "min") + "Date"];

                if (dateObj !== undefined) {

                    self[type === "min" ? "minDateHasTime" : "maxDateHasTime"] =

                        dateObj.getHours() > 0 ||

                            dateObj.getMinutes() > 0 ||

                            dateObj.getSeconds() > 0;

                }

                if (self.selectedDates) {

                    self.selectedDates = self.selectedDates.filter(function (d) { return isEnabled(d); });

                    if (!self.selectedDates.length && type === "min")

                        setHoursFromDate(dateObj);

                    updateValue();

                }

                if (self.daysContainer) {

                    redraw();

                    if (dateObj !== undefined)

                        self.currentYearElement[type] = dateObj.getFullYear().toString();

                    else

                        self.currentYearElement.removeAttribute(type);

                    self.currentYearElement.disabled =

                        !!inverseDateObj &&

                            dateObj !== undefined &&

                            inverseDateObj.getFullYear() === dateObj.getFullYear();

                }

            };

        }

        function parseConfig() {

            var boolOpts = [

                "wrap",

                "weekNumbers",

                "allowInput",

                "allowInvalidPreload",

                "clickOpens",

                "time_24hr",

                "enableTime",

                "noCalendar",

                "altInput",

                "shorthandCurrentMonth",

                "inline",

                "static",

                "enableSeconds",

                "disableMobile",

            ];

            var userConfig = __assign(__assign({}, JSON.parse(JSON.stringify(element.dataset || {}))), instanceConfig);

            var formats = {};

            self.config.parseDate = userConfig.parseDate;

            self.config.formatDate = userConfig.formatDate;

            Object.defineProperty(self.config, "enable", {

                get: function () { return self.config._enable; },

                set: function (dates) {

                    self.config._enable = parseDateRules(dates);

                },

            });

            Object.defineProperty(self.config, "disable", {

                get: function () { return self.config._disable; },

                set: function (dates) {

                    self.config._disable = parseDateRules(dates);

                },

            });

            var timeMode = userConfig.mode === "time";

            if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {

                var defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults.dateFormat;

                formats.dateFormat =

                    userConfig.noCalendar || timeMode

                        ? "H:i" + (userConfig.enableSeconds ? ":S" : "")

                        : defaultDateFormat + " H:i" + (userConfig.enableSeconds ? ":S" : "");

            }

            if (userConfig.altInput &&

                (userConfig.enableTime || timeMode) &&

                !userConfig.altFormat) {

                var defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults.altFormat;

                formats.altFormat =

                    userConfig.noCalendar || timeMode

                        ? "h:i" + (userConfig.enableSeconds ? ":S K" : " K")

                        : defaultAltFormat + (" h:i" + (userConfig.enableSeconds ? ":S" : "") + " K");

            }

            Object.defineProperty(self.config, "minDate", {

                get: function () { return self.config._minDate; },

                set: minMaxDateSetter("min"),

            });

            Object.defineProperty(self.config, "maxDate", {

                get: function () { return self.config._maxDate; },

                set: minMaxDateSetter("max"),

            });

            var minMaxTimeSetter = function (type) { return function (val) {

                self.config[type === "min" ? "_minTime" : "_maxTime"] = self.parseDate(val, "H:i:S");

            }; };

            Object.defineProperty(self.config, "minTime", {

                get: function () { return self.config._minTime; },

                set: minMaxTimeSetter("min"),

            });

            Object.defineProperty(self.config, "maxTime", {

                get: function () { return self.config._maxTime; },

                set: minMaxTimeSetter("max"),

            });

            if (userConfig.mode === "time") {

                self.config.noCalendar = true;

                self.config.enableTime = true;

            }

            Object.assign(self.config, formats, userConfig);

            for (var i = 0; i < boolOpts.length; i++)

                // https://github.com/microsoft/TypeScript/issues/31663

                self.config[boolOpts[i]] =

                    self.config[boolOpts[i]] === true ||

                        self.config[boolOpts[i]] === "true";

            HOOKS.filter(function (hook) { return self.config[hook] !== undefined; }).forEach(function (hook) {

                self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);

            });

            self.isMobile =

                !self.config.disableMobile &&

                    !self.config.inline &&

                    self.config.mode === "single" &&

                    !self.config.disable.length &&

                    !self.config.enable &&

                    !self.config.weekNumbers &&

                    /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);

            for (var i = 0; i < self.config.plugins.length; i++) {

                var pluginConf = self.config.plugins[i](self) || {};

                for (var key in pluginConf) {

                    if (HOOKS.indexOf(key) > -1) {

                        self.config[key] = arrayify(pluginConf[key])

                            .map(bindToInstance)

                            .concat(self.config[key]);

                    }

                    else if (typeof userConfig[key] === "undefined")

                        self.config[key] = pluginConf[key];

                }

            }

            if (!userConfig.altInputClass) {

                self.config.altInputClass =

                    getInputElem().className + " " + self.config.altInputClass;

            }

            triggerEvent("onParseConfig");

        }

        function getInputElem() {

            return self.config.wrap

                ? element.querySelector("[data-input]")

                : element;

        }

        function setupLocale() {

            if (typeof self.config.locale !== "object" &&

                typeof flatpickr.l10ns[self.config.locale] === "undefined")

                self.config.errorHandler(new Error("flatpickr: invalid locale " + self.config.locale));

            self.l10n = __assign(__assign({}, flatpickr.l10ns.default), (typeof self.config.locale === "object"

                ? self.config.locale

                : self.config.locale !== "default"

                    ? flatpickr.l10ns[self.config.locale]

                    : undefined));

            tokenRegex.K = "(" + self.l10n.amPM[0] + "|" + self.l10n.amPM[1] + "|" + self.l10n.amPM[0].toLowerCase() + "|" + self.l10n.amPM[1].toLowerCase() + ")";

            var userConfig = __assign(__assign({}, instanceConfig), JSON.parse(JSON.stringify(element.dataset || {})));

            if (userConfig.time_24hr === undefined &&

                flatpickr.defaultConfig.time_24hr === undefined) {

                self.config.time_24hr = self.l10n.time_24hr;

            }

            self.formatDate = createDateFormatter(self);

            self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });

        }

        function positionCalendar(customPositionElement) {

            if (typeof self.config.position === "function") {

                return void self.config.position(self, customPositionElement);

            }

            if (self.calendarContainer === undefined)

                return;

            triggerEvent("onPreCalendarPosition");

            var positionElement = customPositionElement || self._positionElement;

            var calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, (function (acc, child) { return acc + child.offsetHeight; }), 0), calendarWidth = self.calendarContainer.offsetWidth, configPos = self.config.position.split(" "), configPosVertical = configPos[0], configPosHorizontal = configPos.length > 1 ? configPos[1] : null, inputBounds = positionElement.getBoundingClientRect(), distanceFromBottom = window.innerHeight - inputBounds.bottom, showOnTop = configPosVertical === "above" ||

                (configPosVertical !== "below" &&

                    distanceFromBottom < calendarHeight &&

                    inputBounds.top > calendarHeight);

            var top = window.pageYOffset +

                inputBounds.top +

                (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);

            toggleClass(self.calendarContainer, "arrowTop", !showOnTop);

            toggleClass(self.calendarContainer, "arrowBottom", showOnTop);

            if (self.config.inline)

                return;

            var left = window.pageXOffset + inputBounds.left;

            var isCenter = false;

            var isRight = false;

            if (configPosHorizontal === "center") {

                left -= (calendarWidth - inputBounds.width) / 2;

                isCenter = true;

            }

            else if (configPosHorizontal === "right") {

                left -= calendarWidth - inputBounds.width;

                isRight = true;

            }

            toggleClass(self.calendarContainer, "arrowLeft", !isCenter && !isRight);

            toggleClass(self.calendarContainer, "arrowCenter", isCenter);

            toggleClass(self.calendarContainer, "arrowRight", isRight);

            var right = window.document.body.offsetWidth -

                (window.pageXOffset + inputBounds.right);

            var rightMost = left + calendarWidth > window.document.body.offsetWidth;

            var centerMost = right + calendarWidth > window.document.body.offsetWidth;

            toggleClass(self.calendarContainer, "rightMost", rightMost);

            if (self.config.static)

                return;

            self.calendarContainer.style.top = top + "px";

            if (!rightMost) {

                self.calendarContainer.style.left = left + "px";

                self.calendarContainer.style.right = "auto";

            }

            else if (!centerMost) {

                self.calendarContainer.style.left = "auto";

                self.calendarContainer.style.right = right + "px";

            }

            else {

                var doc = getDocumentStyleSheet();

                // some testing environments don't have css support

                if (doc === undefined)

                    return;

                var bodyWidth = window.document.body.offsetWidth;

                var centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);

                var centerBefore = ".flatpickr-calendar.centerMost:before";

                var centerAfter = ".flatpickr-calendar.centerMost:after";

                var centerIndex = doc.cssRules.length;

                var centerStyle = "{left:" + inputBounds.left + "px;right:auto;}";

                toggleClass(self.calendarContainer, "rightMost", false);

                toggleClass(self.calendarContainer, "centerMost", true);

                doc.insertRule(centerBefore + "," + centerAfter + centerStyle, centerIndex);

                self.calendarContainer.style.left = centerLeft + "px";

                self.calendarContainer.style.right = "auto";

            }

        }

        function getDocumentStyleSheet() {

            var editableSheet = null;

            for (var i = 0; i < document.styleSheets.length; i++) {

                var sheet = document.styleSheets[i];

                try {

                    sheet.cssRules;

                }

                catch (err) {

                    continue;

                }

                editableSheet = sheet;

                break;

            }

            return editableSheet != null ? editableSheet : createStyleSheet();

        }

        function createStyleSheet() {

            var style = document.createElement("style");

            document.head.appendChild(style);

            return style.sheet;

        }

        function redraw() {

            if (self.config.noCalendar || self.isMobile)

                return;

            buildMonthSwitch();

            updateNavigationCurrentMonth();

            buildDays();

        }

        function focusAndClose() {

            self._input.focus();

            if (window.navigator.userAgent.indexOf("MSIE") !== -1 ||

                navigator.msMaxTouchPoints !== undefined) {

                // hack - bugs in the way IE handles focus keeps the calendar open

                setTimeout(self.close, 0);

            }

            else {

                self.close();

            }

        }

        function selectDate(e) {

            e.preventDefault();

            e.stopPropagation();

            var isSelectable = function (day) {

                return day.classList &&

                    day.classList.contains("flatpickr-day") &&

                    !day.classList.contains("flatpickr-disabled") &&

                    !day.classList.contains("notAllowed");

            };

            var t = findParent(getEventTarget(e), isSelectable);

            if (t === undefined)

                return;

            var target = t;

            var selectedDate = (self.latestSelectedDateObj = new Date(target.dateObj.getTime()));

            var shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth ||

                selectedDate.getMonth() >

                    self.currentMonth + self.config.showMonths - 1) &&

                self.config.mode !== "range";

            self.selectedDateElem = target;

            if (self.config.mode === "single")

                self.selectedDates = [selectedDate];

            else if (self.config.mode === "multiple") {

                var selectedIndex = isDateSelected(selectedDate);

                if (selectedIndex)

                    self.selectedDates.splice(parseInt(selectedIndex), 1);

                else

                    self.selectedDates.push(selectedDate);

            }

            else if (self.config.mode === "range") {

                if (self.selectedDates.length === 2) {

                    self.clear(false, false);

                }

                self.latestSelectedDateObj = selectedDate;

                self.selectedDates.push(selectedDate);

                // unless selecting same date twice, sort ascendingly

                if (compareDates(selectedDate, self.selectedDates[0], true) !== 0)

                    self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });

            }

            setHoursFromInputs();

            if (shouldChangeMonth) {

                var isNewYear = self.currentYear !== selectedDate.getFullYear();

                self.currentYear = selectedDate.getFullYear();

                self.currentMonth = selectedDate.getMonth();

                if (isNewYear) {

                    triggerEvent("onYearChange");

                    buildMonthSwitch();

                }

                triggerEvent("onMonthChange");

            }

            updateNavigationCurrentMonth();

            buildDays();

            updateValue();

            // maintain focus

            if (!shouldChangeMonth &&

                self.config.mode !== "range" &&

                self.config.showMonths === 1)

                focusOnDayElem(target);

            else if (self.selectedDateElem !== undefined &&

                self.hourElement === undefined) {

                self.selectedDateElem && self.selectedDateElem.focus();

            }

            if (self.hourElement !== undefined)

                self.hourElement !== undefined && self.hourElement.focus();

            if (self.config.closeOnSelect) {

                var single = self.config.mode === "single" && !self.config.enableTime;

                var range = self.config.mode === "range" &&

                    self.selectedDates.length === 2 &&

                    !self.config.enableTime;

                if (single || range) {

                    focusAndClose();

                }

            }

            triggerChange();

        }

        var CALLBACKS = {

            locale: [setupLocale, updateWeekdays],

            showMonths: [buildMonths, setCalendarWidth, buildWeekdays],

            minDate: [jumpToDate],

            maxDate: [jumpToDate],

            clickOpens: [

                function () {

                    if (self.config.clickOpens === true) {

                        bind(self._input, "focus", self.open);

                        bind(self._input, "click", self.open);

                    }

                    else {

                        self._input.removeEventListener("focus", self.open);

                        self._input.removeEventListener("click", self.open);

                    }

                },

            ],

        };

        function set(option, value) {

            if (option !== null && typeof option === "object") {

                Object.assign(self.config, option);

                for (var key in option) {

                    if (CALLBACKS[key] !== undefined)

                        CALLBACKS[key].forEach(function (x) { return x(); });

                }

            }

            else {

                self.config[option] = value;

                if (CALLBACKS[option] !== undefined)

                    CALLBACKS[option].forEach(function (x) { return x(); });

                else if (HOOKS.indexOf(option) > -1)

                    self.config[option] = arrayify(value);

            }

            self.redraw();

            updateValue(true);

        }

        function setSelectedDate(inputDate, format) {

            var dates = [];

            if (inputDate instanceof Array)

                dates = inputDate.map(function (d) { return self.parseDate(d, format); });

            else if (inputDate instanceof Date || typeof inputDate === "number")

                dates = [self.parseDate(inputDate, format)];

            else if (typeof inputDate === "string") {

                switch (self.config.mode) {

                    case "single":

                    case "time":

                        dates = [self.parseDate(inputDate, format)];

                        break;

                    case "multiple":

                        dates = inputDate

                            .split(self.config.conjunction)

                            .map(function (date) { return self.parseDate(date, format); });

                        break;

                    case "range":

                        dates = inputDate

                            .split(self.l10n.rangeSeparator)

                            .map(function (date) { return self.parseDate(date, format); });

                        break;

                }

            }

            else

                self.config.errorHandler(new Error("Invalid date supplied: " + JSON.stringify(inputDate)));

            self.selectedDates = (self.config.allowInvalidPreload

                ? dates

                : dates.filter(function (d) { return d instanceof Date && isEnabled(d, false); }));

            if (self.config.mode === "range")

                self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });

        }

        function setDate(date, triggerChange, format) {

            if (triggerChange === void 0) { triggerChange = false; }

            if (format === void 0) { format = self.config.dateFormat; }

            if ((date !== 0 && !date) || (date instanceof Array && date.length === 0))

                return self.clear(triggerChange);

            setSelectedDate(date, format);

            self.latestSelectedDateObj =

                self.selectedDates[self.selectedDates.length - 1];

            self.redraw();

            jumpToDate(undefined, triggerChange);

            setHoursFromDate();

            if (self.selectedDates.length === 0) {

                self.clear(false);

            }

            updateValue(triggerChange);

            if (triggerChange)

                triggerEvent("onChange");

        }

        function parseDateRules(arr) {

            return arr

                .slice()

                .map(function (rule) {

                if (typeof rule === "string" ||

                    typeof rule === "number" ||

                    rule instanceof Date) {

                    return self.parseDate(rule, undefined, true);

                }

                else if (rule &&

                    typeof rule === "object" &&

                    rule.from &&

                    rule.to)

                    return {

                        from: self.parseDate(rule.from, undefined),

                        to: self.parseDate(rule.to, undefined),

                    };

                return rule;

            })

                .filter(function (x) { return x; }); // remove falsy values

        }

        function setupDates() {

            self.selectedDates = [];

            self.now = self.parseDate(self.config.now) || new Date();

            // Workaround IE11 setting placeholder as the input's value

            var preloadedDate = self.config.defaultDate ||

                ((self.input.nodeName === "INPUT" ||

                    self.input.nodeName === "TEXTAREA") &&

                    self.input.placeholder &&

                    self.input.value === self.input.placeholder

                    ? null

                    : self.input.value);

            if (preloadedDate)

                setSelectedDate(preloadedDate, self.config.dateFormat);

            self._initialDate =

                self.selectedDates.length > 0

                    ? self.selectedDates[0]

                    : self.config.minDate &&

                        self.config.minDate.getTime() > self.now.getTime()

                        ? self.config.minDate

                        : self.config.maxDate &&

                            self.config.maxDate.getTime() < self.now.getTime()

                            ? self.config.maxDate

                            : self.now;

            self.currentYear = self._initialDate.getFullYear();

            self.currentMonth = self._initialDate.getMonth();

            if (self.selectedDates.length > 0)

                self.latestSelectedDateObj = self.selectedDates[0];

            if (self.config.minTime !== undefined)

                self.config.minTime = self.parseDate(self.config.minTime, "H:i");

            if (self.config.maxTime !== undefined)

                self.config.maxTime = self.parseDate(self.config.maxTime, "H:i");

            self.minDateHasTime =

                !!self.config.minDate &&

                    (self.config.minDate.getHours() > 0 ||

                        self.config.minDate.getMinutes() > 0 ||

                        self.config.minDate.getSeconds() > 0);

            self.maxDateHasTime =

                !!self.config.maxDate &&

                    (self.config.maxDate.getHours() > 0 ||

                        self.config.maxDate.getMinutes() > 0 ||

                        self.config.maxDate.getSeconds() > 0);

        }

        function setupInputs() {

            self.input = getInputElem();

            /* istanbul ignore next */

            if (!self.input) {

                self.config.errorHandler(new Error("Invalid input element specified"));

                return;

            }

            // hack: store previous type to restore it after destroy()

            self.input._type = self.input.type;

            self.input.type = "text";

            self.input.classList.add("flatpickr-input");

            self._input = self.input;

            if (self.config.altInput) {

                // replicate self.element

                self.altInput = createElement(self.input.nodeName, self.config.altInputClass);

                self._input = self.altInput;

                self.altInput.placeholder = self.input.placeholder;

                self.altInput.disabled = self.input.disabled;

                self.altInput.required = self.input.required;

                self.altInput.tabIndex = self.input.tabIndex;

                self.altInput.type = "text";

                self.input.setAttribute("type", "hidden");

                if (!self.config.static && self.input.parentNode)

                    self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);

            }

            if (!self.config.allowInput)

                self._input.setAttribute("readonly", "readonly");

            self._positionElement = self.config.positionElement || self._input;

        }

        function setupMobile() {

            var inputType = self.config.enableTime

                ? self.config.noCalendar

                    ? "time"

                    : "datetime-local"

                : "date";

            self.mobileInput = createElement("input", self.input.className + " flatpickr-mobile");

            self.mobileInput.tabIndex = 1;

            self.mobileInput.type = inputType;

            self.mobileInput.disabled = self.input.disabled;

            self.mobileInput.required = self.input.required;

            self.mobileInput.placeholder = self.input.placeholder;

            self.mobileFormatStr =

                inputType === "datetime-local"

                    ? "Y-m-d\\TH:i:S"

                    : inputType === "date"

                        ? "Y-m-d"

                        : "H:i:S";

            if (self.selectedDates.length > 0) {

                self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);

            }

            if (self.config.minDate)

                self.mobileInput.min = self.formatDate(self.config.minDate, "Y-m-d");

            if (self.config.maxDate)

                self.mobileInput.max = self.formatDate(self.config.maxDate, "Y-m-d");

            if (self.input.getAttribute("step"))

                self.mobileInput.step = String(self.input.getAttribute("step"));

            self.input.type = "hidden";

            if (self.altInput !== undefined)

                self.altInput.type = "hidden";

            try {

                if (self.input.parentNode)

                    self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);

            }

            catch (_a) { }

            bind(self.mobileInput, "change", function (e) {

                self.setDate(getEventTarget(e).value, false, self.mobileFormatStr);

                triggerEvent("onChange");

                triggerEvent("onClose");

            });

        }

        function toggle(e) {

            if (self.isOpen === true)

                return self.close();

            self.open(e);

        }

        function triggerEvent(event, data) {

            // If the instance has been destroyed already, all hooks have been removed

            if (self.config === undefined)

                return;

            var hooks = self.config[event];

            if (hooks !== undefined && hooks.length > 0) {

                for (var i = 0; hooks[i] && i < hooks.length; i++)

                    hooks[i](self.selectedDates, self.input.value, self, data);

            }

            if (event === "onChange") {

                self.input.dispatchEvent(createEvent("change"));

                // many front-end frameworks bind to the input event

                self.input.dispatchEvent(createEvent("input"));

            }

        }

        function createEvent(name) {

            var e = document.createEvent("Event");

            e.initEvent(name, true, true);

            return e;

        }

        function isDateSelected(date) {

            for (var i = 0; i < self.selectedDates.length; i++) {

                if (compareDates(self.selectedDates[i], date) === 0)

                    return "" + i;

            }

            return false;

        }

        function isDateInRange(date) {

            if (self.config.mode !== "range" || self.selectedDates.length < 2)

                return false;

            return (compareDates(date, self.selectedDates[0]) >= 0 &&

                compareDates(date, self.selectedDates[1]) <= 0);

        }

        function updateNavigationCurrentMonth() {

            if (self.config.noCalendar || self.isMobile || !self.monthNav)

                return;

            self.yearElements.forEach(function (yearElement, i) {

                var d = new Date(self.currentYear, self.currentMonth, 1);

                d.setMonth(self.currentMonth + i);

                if (self.config.showMonths > 1 ||

                    self.config.monthSelectorType === "static") {

                    self.monthElements[i].textContent =

                        monthToStr(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + " ";

                }

                else {

                    self.monthsDropdownContainer.value = d.getMonth().toString();

                }

                yearElement.value = d.getFullYear().toString();

            });

            self._hidePrevMonthArrow =

                self.config.minDate !== undefined &&

                    (self.currentYear === self.config.minDate.getFullYear()

                        ? self.currentMonth <= self.config.minDate.getMonth()

                        : self.currentYear < self.config.minDate.getFullYear());

            self._hideNextMonthArrow =

                self.config.maxDate !== undefined &&

                    (self.currentYear === self.config.maxDate.getFullYear()

                        ? self.currentMonth + 1 > self.config.maxDate.getMonth()

                        : self.currentYear > self.config.maxDate.getFullYear());

        }

        function getDateStr(format) {

            return self.selectedDates

                .map(function (dObj) { return self.formatDate(dObj, format); })

                .filter(function (d, i, arr) {

                return self.config.mode !== "range" ||

                    self.config.enableTime ||

                    arr.indexOf(d) === i;

            })

                .join(self.config.mode !== "range"

                ? self.config.conjunction

                : self.l10n.rangeSeparator);

        }

        /**

         * Updates the values of inputs associated with the calendar

         */

        function updateValue(triggerChange) {

            if (triggerChange === void 0) { triggerChange = true; }

            if (self.mobileInput !== undefined && self.mobileFormatStr) {

                self.mobileInput.value =

                    self.latestSelectedDateObj !== undefined

                        ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr)

                        : "";

            }

            self.input.value = getDateStr(self.config.dateFormat);

            if (self.altInput !== undefined) {

                self.altInput.value = getDateStr(self.config.altFormat);

            }

            if (triggerChange !== false)

                triggerEvent("onValueUpdate");

        }

        function onMonthNavClick(e) {

            var eventTarget = getEventTarget(e);

            var isPrevMonth = self.prevMonthNav.contains(eventTarget);

            var isNextMonth = self.nextMonthNav.contains(eventTarget);

            if (isPrevMonth || isNextMonth) {

                changeMonth(isPrevMonth ? -1 : 1);

            }

            else if (self.yearElements.indexOf(eventTarget) >= 0) {

                eventTarget.select();

            }

            else if (eventTarget.classList.contains("arrowUp")) {

                self.changeYear(self.currentYear + 1);

            }

            else if (eventTarget.classList.contains("arrowDown")) {

                self.changeYear(self.currentYear - 1);

            }

        }

        function timeWrapper(e) {

            e.preventDefault();

            var isKeyDown = e.type === "keydown", eventTarget = getEventTarget(e), input = eventTarget;

            if (self.amPM !== undefined && eventTarget === self.amPM) {

                self.amPM.textContent =

                    self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];

            }

            var min = parseFloat(input.getAttribute("min")), max = parseFloat(input.getAttribute("max")), step = parseFloat(input.getAttribute("step")), curValue = parseInt(input.value, 10), delta = e.delta ||

                (isKeyDown ? (e.which === 38 ? 1 : -1) : 0);

            var newValue = curValue + step * delta;

            if (typeof input.value !== "undefined" && input.value.length === 2) {

                var isHourElem = input === self.hourElement, isMinuteElem = input === self.minuteElement;

                if (newValue < min) {

                    newValue =

                        max +

                            newValue +

                            int(!isHourElem) +

                            (int(isHourElem) && int(!self.amPM));

                    if (isMinuteElem)

                        incrementNumInput(undefined, -1, self.hourElement);

                }

                else if (newValue > max) {

                    newValue =

                        input === self.hourElement ? newValue - max - int(!self.amPM) : min;

                    if (isMinuteElem)

                        incrementNumInput(undefined, 1, self.hourElement);

                }

                if (self.amPM &&

                    isHourElem &&

                    (step === 1

                        ? newValue + curValue === 23

                        : Math.abs(newValue - curValue) > step)) {

                    self.amPM.textContent =

                        self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];

                }

                input.value = pad(newValue);

            }

        }

        init();

        return self;

    }

    /* istanbul ignore next */

    function _flatpickr(nodeList, config) {

        // static list

        var nodes = Array.prototype.slice

            .call(nodeList)

            .filter(function (x) { return x instanceof HTMLElement; });

        var instances = [];

        for (var i = 0; i < nodes.length; i++) {

            var node = nodes[i];

            try {

                if (node.getAttribute("data-fp-omit") !== null)

                    continue;

                if (node._flatpickr !== undefined) {

                    node._flatpickr.destroy();

                    node._flatpickr = undefined;

                }

                node._flatpickr = FlatpickrInstance(node, config || {});

                instances.push(node._flatpickr);

            }

            catch (e) {

                console.error(e);

            }

        }

        return instances.length === 1 ? instances[0] : instances;

    }

    /* istanbul ignore next */

    if (typeof HTMLElement !== "undefined" &&

        typeof HTMLCollection !== "undefined" &&

        typeof NodeList !== "undefined") {

        // browser env

        HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {

            return _flatpickr(this, config);

        };

        HTMLElement.prototype.flatpickr = function (config) {

            return _flatpickr([this], config);

        };

    }

    /* istanbul ignore next */

    var flatpickr = function (selector, config) {

        if (typeof selector === "string") {

            return _flatpickr(window.document.querySelectorAll(selector), config);

        }

        else if (selector instanceof Node) {

            return _flatpickr([selector], config);

        }

        else {

            return _flatpickr(selector, config);

        }

    };

    /* istanbul ignore next */

    flatpickr.defaultConfig = {};

    flatpickr.l10ns = {

        en: __assign({}, english),

        default: __assign({}, english),

    };

    flatpickr.localize = function (l10n) {

        flatpickr.l10ns.default = __assign(__assign({}, flatpickr.l10ns.default), l10n);

    };

    flatpickr.setDefaults = function (config) {

        flatpickr.defaultConfig = __assign(__assign({}, flatpickr.defaultConfig), config);

    };

    flatpickr.parseDate = createDateParser({});

    flatpickr.formatDate = createDateFormatter({});

    flatpickr.compareDates = compareDates;

    /* istanbul ignore next */

    if (typeof jQuery !== "undefined" && typeof jQuery.fn !== "undefined") {

        jQuery.fn.flatpickr = function (config) {

            return _flatpickr(this, config);

        };

    }

    Date.prototype.fp_incr = function (days) {

        return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === "string" ? parseInt(days, 10) : days));

    };

    if (typeof window !== "undefined") {

        window.flatpickr = flatpickr;

    }



    return flatpickr;



})));

;/**

*

* jQuery Chosen AJAX Autocomplete Library

*

* https://github.com/meltingice/ajax-chosen

* https://github.com/michaelperrin/ajax-chosen

*

* MIT License

*

* Customized by Codestar

*

*/

(function($) {



  function CSFAjaxChosen(element, options) {

    this.element = $(element);

    this.options = options;

    this.init();

  };



  CSFAjaxChosen.prototype.init = function() {

    this.element.chosen(this.options);

    this.container    = this.element.next('.chosen-container');

    this.search_field = this.container.find('.chosen-search-input');

    this.is_multiple  = this.container.hasClass('chosen-container-multi');

    this.is_typing    = false;

    this.chosenXhr    = null;

    this.events();

  };



  CSFAjaxChosen.prototype.events = function() {



    var _this = this;



    this.search_field.on('compositionstart', function() {

      _this.is_typing = true;

    });



    this.search_field.on('compositionend', function() {

      _this.is_typing = false;

      _this.update_list();

    });



    this.search_field.on('keyup', function() {

      _this.update_list();

    });



    this.search_field.on('focus', function() {

      _this.search_field_focused();

    });



  };



  CSFAjaxChosen.prototype.search_field_focused = function() {

    this.search_welcome_message();

    if ( this.options.min_length === 0 && this.search_field.val().length === 0 ) {

      this.update_list();

    }

  };



  CSFAjaxChosen.prototype.search_welcome_message = function() {



    var value   = $.trim(this.search_field.val());

    var results = this.container.find('.chosen-results');



    if ( results.children().length === 0 && value.length === 0 ) {

      results.html('<li class="no-results">' + this.options.typing_text.replace('%s', this.options.min_length - value.length) + '</li>');

    }



  };



  CSFAjaxChosen.prototype.update_list = function() {



    var _this = this;



    this.search_welcome_message();



    if ( this.is_typing ) { return; }



    var value   = $.trim(this.search_field.val());

    var message = ( value.length < this.options.min_length ) ? this.options.typing_text.replace('%s', this.options.min_length - value.length) : this.options.searching_text;



    this.container.find('.no-results').text(message);



    if ( value === this.search_field.data('prevVal') ) { return; }



    this.search_field.data('prevVal', value);



    if (this.timer) {

      clearTimeout(this.timer);

    }



    if ( value.length < this.options.min_length ) { return; }



    this.timer = setTimeout( function() {



      if ( _this.chosenXhr ) {

        _this.chosenXhr.abort();

      }



      _this.options.data['term'] = value;



      _this.chosenXhr = window.wp.ajax.post('csf-chosen', _this.options.data).done( function( response ) {

        _this.show_results( response );

      }).fail( function( response ) {

        _this.container.find('.no-results').text(response.error);

      });



    }, this.options.type_delay );



  };



  CSFAjaxChosen.prototype.show_results = function( items ) {



    var _this = this;



    if ( this.is_typing || items === null ) { return; }



    if ( items.length === 0 ) {

      this.element.data().chosen.no_results_clear();

      this.element.data().chosen.no_results(this.search_field.val());

      return;

    }



    var selected_values = [];



    this.element.find('option').each(function() {

      if ( $(this).is(':selected') ) {

        selected_values.push( $(this).val() + "-" + $(this).text() );

      } else {

        if( $(this).attr('value').length ) {

          $(this).remove();

        }

      }

    });



    $.each(items, function(i, item) {

      if ( $.inArray( item.value + "-" + item.text, selected_values ) === -1 ) {

        $('<option />').attr('value', item.value).html(item.text).appendTo(_this.element);

      }

    });



    var value_before_trigger = this.search_field.val();

    var width_before_trigger = this.search_field.innerWidth();



    this.element.trigger('chosen:updated');



    if( this.is_multiple ) {



      var $hidden_select = this.element.parent().find('.csf-hide-select');

      var $hidden_value  = $hidden_select.val() || [];



      this.element.CSFChosenOrder($hidden_value, true);

      this.search_field.css('width', width_before_trigger);



    }



    this.search_field.val(value_before_trigger);



    if ( this.chosenXhr.done !== null ) {

      this.chosenXhr.done(items);

    }



  };



  $.fn.CSFAjaxChosen = function(chosenOptions) {

    return this.each(function() {

      new CSFAjaxChosen(this, chosenOptions);

    });

  };



})(jQuery);

;// Chosen Order v1.2.1

// This plugin allows you to handle the order of the selection for Chosen multiple <select> dropdowns

// Full source at https://github.com/tristanjahier/chosen-order

// Copyright (c) 2013 - Tristan Jahier, http://tristan-jahier.fr

(function() {

  var $, CSFAbstractChosenOrder, _ref,

    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },

    __hasProp = {}.hasOwnProperty,

    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };



  CSFAbstractChosenOrder = (function() {



    function CSFAbstractChosenOrder() {}



    CSFAbstractChosenOrder.insertAt = function(node, index, parentNode) {

      return parentNode.insertBefore(node, parentNode.children[index].nextSibling);

    };



    CSFAbstractChosenOrder.getFlattenedOptionsAndGroups = function(select) {

      var flattened_options, opt, options, sub_opt, sub_options, _i, _j, _len, _len1;

      options = Array.prototype.filter.call(select.childNodes, function(o) {

        var _ref;

        return (_ref = o.nodeName.toUpperCase()) === 'OPTION' || _ref === 'OPTGROUP';

      });

      flattened_options = [];

      for (_i = 0, _len = options.length; _i < _len; _i++) {

        opt = options[_i];

        flattened_options.push(opt);

        if (opt.nodeName.toUpperCase() === 'OPTGROUP') {

          sub_options = Array.prototype.filter.call(opt.childNodes, function(o) {

            return o.nodeName.toUpperCase() === 'OPTION';

          });

          for (_j = 0, _len1 = sub_options.length; _j < _len1; _j++) {

            sub_opt = sub_options[_j];

            flattened_options.push(sub_opt);

          }

        }

      }

      return flattened_options;

    };



    CSFAbstractChosenOrder.isValidMultipleSelectElement = function(element) {

      return element !== null && typeof element !== "undefined" && element.nodeName === "SELECT" && element.multiple;

    };



    CSFAbstractChosenOrder.getChosenUIContainer = function(select) {

      if (select.id !== "") {

        return document.getElementById(select.id.replace(/-/g, "_") + "_chosen");

      } else {

        return this.searchChosenUIContainer(select);

      }

    };



    CSFAbstractChosenOrder.isChosenified = function(select) {

      return this.getChosenUIContainer(select) != null;

    };



    CSFAbstractChosenOrder.forceSelection = function(select, selection) {

      var i, opt, options, _ref;

      options = this.getFlattenedOptionsAndGroups(select);

      i = 0;

      while (i < options.length) {

        opt = options[i];

        if (_ref = opt.getAttribute("value"), __indexOf.call(selection, _ref) >= 0) {

          opt.selected = true;

          opt.setAttribute("selected", "");

        } else {

          opt.selected = false;

          opt.removeAttribute("selected");

        }

        i++;

      }

      return this.triggerEvent(select, "chosen:updated");

    };



    CSFAbstractChosenOrder.CSFChosenOrder = function(select, order, force) {

      var chosen_choices, chosen_options, chosen_ui, i, j, opt, opt_val, option, options, rel, relAttributeName, _i, _j, _len, _len1, _results;

      if (this.getDOMElement != null) {

        select = this.getDOMElement(select);

      }

      if (!this.isValidMultipleSelectElement(select)) {

        return;

      }

      chosen_ui = this.getChosenUIContainer(select);

      if (chosen_ui == null) {

        return;

      }

      if (order instanceof Array) {

        order = order.map(Function.prototype.call, String.prototype.trim);

        options = this.getFlattenedOptionsAndGroups(select);

        if ((force != null) && force === true) {

          this.forceSelection(select, order);

        }

        _results = [];

        for (i = _i = 0, _len = order.length; _i < _len; i = ++_i) {

          opt_val = order[i];

          rel = null;

          for (j = _j = 0, _len1 = options.length; _j < _len1; j = ++_j) {

            opt = options[j];

            if (opt.value === opt_val) {

              rel = j;

            }

          }

          chosen_options = chosen_ui.querySelectorAll('.search-choice');

          relAttributeName = this.relAttributeName;

          option = Array.prototype.filter.call(chosen_options, function(o) {

            return o.querySelector("a.search-choice-close[" + relAttributeName + "=\"" + rel + "\"]") != null;

          })[0];

          if (option == null) {

            continue;

          }

          chosen_choices = chosen_ui.querySelector("ul.chosen-choices");

          _results.push(this.insertAt(option, i, chosen_ui.querySelector('ul.chosen-choices')));

        }

        return _results;

      } else {

        return;

      }

    };



    return CSFAbstractChosenOrder;



  })();



  $ = jQuery;



  $.fn.extend({

    CSFChosenOrder: function(order, force) {

      return _CSFChosenOrder.CSFChosenOrder(this, order, force);

    }

  });



  this._CSFChosenOrder = (function(_super) {

    __extends(_CSFChosenOrder, _super);



    function _CSFChosenOrder() {

      _ref = _CSFChosenOrder.__super__.constructor.apply(this, arguments);

      return _ref;

    }



    _CSFChosenOrder.relAttributeName = 'data-option-array-index';



    _CSFChosenOrder.isjQueryObject = function(obj) {

      return (typeof jQuery !== "undefined" && jQuery !== null) && obj instanceof jQuery;

    };



    _CSFChosenOrder.getDOMElement = function(element) {

      if (this.isjQueryObject(element)) {

        return element.get(0);

      } else {

        return element;

      }

    };



    _CSFChosenOrder.searchChosenUIContainer = function(element) {

      if ($(element).data("chosen") != null) {

        return $(element).data("chosen").container[0];

      } else {

        return $(element).next(".chosen-container.chosen-container-multi").get(0);

      }

    };



    _CSFChosenOrder.triggerEvent = function(target, event_name) {

      return $(target).trigger(event_name);

    };



    return _CSFChosenOrder;



  })(CSFAbstractChosenOrder);



}).call(this);

;(function() {

  var $, AbstractChosen, Chosen, SelectParser,

    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },

    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },

    hasProp = {}.hasOwnProperty;



  SelectParser = (function() {

    function SelectParser() {

      this.options_index = 0;

      this.parsed = [];

    }



    SelectParser.prototype.add_node = function(child) {

      if (child.nodeName.toUpperCase() === "OPTGROUP") {

        return this.add_group(child);

      } else {

        return this.add_option(child);

      }

    };



    SelectParser.prototype.add_group = function(group) {

      var group_position, i, len, option, ref, results1;

      group_position = this.parsed.length;

      this.parsed.push({

        array_index: group_position,

        group: true,

        label: group.label,

        title: group.title ? group.title : void 0,

        children: 0,

        disabled: group.disabled,

        classes: group.className

      });

      ref = group.childNodes;

      results1 = [];

      for (i = 0, len = ref.length; i < len; i++) {

        option = ref[i];

        results1.push(this.add_option(option, group_position, group.disabled));

      }

      return results1;

    };



    SelectParser.prototype.add_option = function(option, group_position, group_disabled) {

      if (option.nodeName.toUpperCase() === "OPTION") {

        if (option.text !== "") {

          if (group_position != null) {

            this.parsed[group_position].children += 1;

          }

          this.parsed.push({

            array_index: this.parsed.length,

            options_index: this.options_index,

            value: option.value,

            text: option.text,

            html: option.innerHTML,

            title: option.title ? option.title : void 0,

            selected: option.selected,

            disabled: group_disabled === true ? group_disabled : option.disabled,

            group_array_index: group_position,

            group_label: group_position != null ? this.parsed[group_position].label : null,

            classes: option.className,

            style: option.style.cssText

          });

        } else {

          this.parsed.push({

            array_index: this.parsed.length,

            options_index: this.options_index,

            empty: true

          });

        }

        return this.options_index += 1;

      }

    };



    return SelectParser;



  })();



  SelectParser.select_to_array = function(select) {

    var child, i, len, parser, ref;

    parser = new SelectParser();

    ref = select.childNodes;

    for (i = 0, len = ref.length; i < len; i++) {

      child = ref[i];

      parser.add_node(child);

    }

    return parser.parsed;

  };



  AbstractChosen = (function() {

    function AbstractChosen(form_field, options1) {

      this.form_field = form_field;

      this.options = options1 != null ? options1 : {};

      this.label_click_handler = bind(this.label_click_handler, this);

      if (!AbstractChosen.browser_is_supported()) {

        return;

      }

      this.is_multiple = this.form_field.multiple;

      this.set_default_text();

      this.set_default_values();

      this.setup();

      this.set_up_html();

      this.register_observers();

      this.on_ready();

    }



    AbstractChosen.prototype.set_default_values = function() {

      this.click_test_action = (function(_this) {

        return function(evt) {

          return _this.test_active_click(evt);

        };

      })(this);

      this.activate_action = (function(_this) {

        return function(evt) {

          return _this.activate_field(evt);

        };

      })(this);

      this.active_field = false;

      this.mouse_on_container = false;

      this.results_showing = false;

      this.result_highlighted = null;

      this.is_rtl = this.options.rtl || /\bchosen-rtl\b/.test(this.form_field.className);

      this.allow_single_deselect = (this.options.allow_single_deselect != null) && (this.form_field.options[0] != null) && this.form_field.options[0].text === "" ? this.options.allow_single_deselect : false;

      this.disable_search_threshold = this.options.disable_search_threshold || 0;

      this.disable_search = this.options.disable_search || false;

      this.enable_split_word_search = this.options.enable_split_word_search != null ? this.options.enable_split_word_search : true;

      this.group_search = this.options.group_search != null ? this.options.group_search : true;

      this.search_contains = this.options.search_contains || false;

      this.single_backstroke_delete = this.options.single_backstroke_delete != null ? this.options.single_backstroke_delete : true;

      this.max_selected_options = this.options.max_selected_options || Infinity;

      this.inherit_select_classes = this.options.inherit_select_classes || false;

      this.display_selected_options = this.options.display_selected_options != null ? this.options.display_selected_options : true;

      this.display_disabled_options = this.options.display_disabled_options != null ? this.options.display_disabled_options : true;

      this.include_group_label_in_selected = this.options.include_group_label_in_selected || false;

      this.max_shown_results = this.options.max_shown_results || Number.POSITIVE_INFINITY;

      this.case_sensitive_search = this.options.case_sensitive_search || false;

      return this.hide_results_on_select = this.options.hide_results_on_select != null ? this.options.hide_results_on_select : true;

    };



    AbstractChosen.prototype.set_default_text = function() {

      if (this.form_field.getAttribute("data-placeholder")) {

        this.default_text = this.form_field.getAttribute("data-placeholder");

      } else if (this.is_multiple) {

        this.default_text = this.options.placeholder_text_multiple || this.options.placeholder_text || AbstractChosen.default_multiple_text;

      } else {

        this.default_text = this.options.placeholder_text_single || this.options.placeholder_text || AbstractChosen.default_single_text;

      }

      this.default_text = this.escape_html(this.default_text);

      return this.results_none_found = this.form_field.getAttribute("data-no_results_text") || this.options.no_results_text || AbstractChosen.default_no_result_text;

    };



    AbstractChosen.prototype.choice_label = function(item) {

      if (this.include_group_label_in_selected && (item.group_label != null)) {

        return "<b class='group-name'>" + (this.escape_html(item.group_label)) + "</b>" + item.html;

      } else {

        return item.html;

      }

    };



    AbstractChosen.prototype.mouse_enter = function() {

      return this.mouse_on_container = true;

    };



    AbstractChosen.prototype.mouse_leave = function() {

      return this.mouse_on_container = false;

    };



    AbstractChosen.prototype.input_focus = function(evt) {

      if (this.is_multiple) {

        if (!this.active_field) {

          return setTimeout(((function(_this) {

            return function() {

              return _this.container_mousedown();

            };

          })(this)), 50);

        }

      } else {

        if (!this.active_field) {

          return this.activate_field();

        }

      }

    };



    AbstractChosen.prototype.input_blur = function(evt) {

      if (!this.mouse_on_container) {

        this.active_field = false;

        return setTimeout(((function(_this) {

          return function() {

            return _this.blur_test();

          };

        })(this)), 100);

      }

    };



    AbstractChosen.prototype.label_click_handler = function(evt) {

      if (this.is_multiple) {

        return this.container_mousedown(evt);

      } else {

        return this.activate_field();

      }

    };



    AbstractChosen.prototype.results_option_build = function(options) {

      var content, data, data_content, i, len, ref, shown_results;

      content = '';

      shown_results = 0;

      ref = this.results_data;

      for (i = 0, len = ref.length; i < len; i++) {

        data = ref[i];

        data_content = '';

        if (data.group) {

          data_content = this.result_add_group(data);

        } else {

          data_content = this.result_add_option(data);

        }

        if (data_content !== '') {

          shown_results++;

          content += data_content;

        }

        if (options != null ? options.first : void 0) {

          if (data.selected && this.is_multiple) {

            this.choice_build(data);

          } else if (data.selected && !this.is_multiple) {

            this.single_set_selected_text(this.choice_label(data));

          }

        }

        if (shown_results >= this.max_shown_results) {

          break;

        }

      }

      return content;

    };



    AbstractChosen.prototype.result_add_option = function(option) {

      var classes, option_el;

      if (!option.search_match) {

        return '';

      }

      if (!this.include_option_in_results(option)) {

        return '';

      }

      classes = [];

      if (!option.disabled && !(option.selected && this.is_multiple)) {

        classes.push("active-result");

      }

      if (option.disabled && !(option.selected && this.is_multiple)) {

        classes.push("disabled-result");

      }

      if (option.selected) {

        classes.push("result-selected");

      }

      if (option.group_array_index != null) {

        classes.push("group-option");

      }

      if (option.classes !== "") {

        classes.push(option.classes);

      }

      option_el = document.createElement("li");

      option_el.className = classes.join(" ");

      if (option.style) {

        option_el.style.cssText = option.style;

      }

      option_el.setAttribute("data-option-array-index", option.array_index);

      option_el.innerHTML = option.highlighted_html || option.html;

      if (option.title) {

        option_el.title = option.title;

      }

      return this.outerHTML(option_el);

    };



    AbstractChosen.prototype.result_add_group = function(group) {

      var classes, group_el;

      if (!(group.search_match || group.group_match)) {

        return '';

      }

      if (!(group.active_options > 0)) {

        return '';

      }

      classes = [];

      classes.push("group-result");

      if (group.classes) {

        classes.push(group.classes);

      }

      group_el = document.createElement("li");

      group_el.className = classes.join(" ");

      group_el.innerHTML = group.highlighted_html || this.escape_html(group.label);

      if (group.title) {

        group_el.title = group.title;

      }

      return this.outerHTML(group_el);

    };



    AbstractChosen.prototype.results_update_field = function() {

      this.set_default_text();

      if (!this.is_multiple) {

        this.results_reset_cleanup();

      }

      this.result_clear_highlight();

      this.results_build();

      if (this.results_showing) {

        return this.winnow_results();

      }

    };



    AbstractChosen.prototype.reset_single_select_options = function() {

      var i, len, ref, result, results1;

      ref = this.results_data;

      results1 = [];

      for (i = 0, len = ref.length; i < len; i++) {

        result = ref[i];

        if (result.selected) {

          results1.push(result.selected = false);

        } else {

          results1.push(void 0);

        }

      }

      return results1;

    };



    AbstractChosen.prototype.results_toggle = function() {

      if (this.results_showing) {

        return this.results_hide();

      } else {

        return this.results_show();

      }

    };



    AbstractChosen.prototype.results_search = function(evt) {

      if (this.results_showing) {

        return this.winnow_results();

      } else {

        return this.results_show();

      }

    };



    AbstractChosen.prototype.winnow_results = function(options) {

      var escapedQuery, fix, i, len, option, prefix, query, ref, regex, results, results_group, search_match, startpos, suffix, text;

      this.no_results_clear();

      results = 0;

      query = this.get_search_text();

      escapedQuery = query.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");

      regex = this.get_search_regex(escapedQuery);

      ref = this.results_data;

      for (i = 0, len = ref.length; i < len; i++) {

        option = ref[i];

        option.search_match = false;

        results_group = null;

        search_match = null;

        option.highlighted_html = '';

        if (this.include_option_in_results(option)) {

          if (option.group) {

            option.group_match = false;

            option.active_options = 0;

          }

          if ((option.group_array_index != null) && this.results_data[option.group_array_index]) {

            results_group = this.results_data[option.group_array_index];

            if (results_group.active_options === 0 && results_group.search_match) {

              results += 1;

            }

            results_group.active_options += 1;

          }

          text = option.group ? option.label : option.text;

          if (!(option.group && !this.group_search)) {

            search_match = this.search_string_match(text, regex);

            option.search_match = search_match != null;

            if (option.search_match && !option.group) {

              results += 1;

            }

            if (option.search_match) {

              if (query.length) {

                startpos = search_match.index;

                prefix = text.slice(0, startpos);

                fix = text.slice(startpos, startpos + query.length);

                suffix = text.slice(startpos + query.length);

                option.highlighted_html = (this.escape_html(prefix)) + "<em>" + (this.escape_html(fix)) + "</em>" + (this.escape_html(suffix));

              }

              if (results_group != null) {

                results_group.group_match = true;

              }

            } else if ((option.group_array_index != null) && this.results_data[option.group_array_index].search_match) {

              option.search_match = true;

            }

          }

        }

      }

      this.result_clear_highlight();

      if (results < 1 && query.length) {

        this.update_results_content("");

        return this.no_results(query);

      } else {

        this.update_results_content(this.results_option_build());

        if (!(options != null ? options.skip_highlight : void 0)) {

          return this.winnow_results_set_highlight();

        }

      }

    };



    AbstractChosen.prototype.get_search_regex = function(escaped_search_string) {

      var regex_flag, regex_string;

      regex_string = this.search_contains ? escaped_search_string : "(^|\\s|\\b)" + escaped_search_string + "[^\\s]*";

      if (!(this.enable_split_word_search || this.search_contains)) {

        regex_string = "^" + regex_string;

      }

      regex_flag = this.case_sensitive_search ? "" : "i";

      return new RegExp(regex_string, regex_flag);

    };



    AbstractChosen.prototype.search_string_match = function(search_string, regex) {

      var match;

      match = regex.exec(search_string);

      if (!this.search_contains && (match != null ? match[1] : void 0)) {

        match.index += 1;

      }

      return match;

    };



    AbstractChosen.prototype.choices_count = function() {

      var i, len, option, ref;

      if (this.selected_option_count != null) {

        return this.selected_option_count;

      }

      this.selected_option_count = 0;

      ref = this.form_field.options;

      for (i = 0, len = ref.length; i < len; i++) {

        option = ref[i];

        if (option.selected) {

          this.selected_option_count += 1;

        }

      }

      return this.selected_option_count;

    };



    AbstractChosen.prototype.choices_click = function(evt) {

      evt.preventDefault();

      this.activate_field();

      if (!(this.results_showing || this.is_disabled)) {

        return this.results_show();

      }

    };



    AbstractChosen.prototype.keydown_checker = function(evt) {

      var ref, stroke;

      stroke = (ref = evt.which) != null ? ref : evt.keyCode;

      this.search_field_scale();

      if (stroke !== 8 && this.pending_backstroke) {

        this.clear_backstroke();

      }

      switch (stroke) {

        case 8:

          this.backstroke_length = this.get_search_field_value().length;

          break;

        case 9:

          if (this.results_showing && !this.is_multiple) {

            this.result_select(evt);

          }

          this.mouse_on_container = false;

          break;

        case 13:

          if (this.results_showing) {

            evt.preventDefault();

          }

          break;

        case 27:

          if (this.results_showing) {

            evt.preventDefault();

          }

          break;

        case 32:

          if (this.disable_search) {

            evt.preventDefault();

          }

          break;

        case 38:

          evt.preventDefault();

          this.keyup_arrow();

          break;

        case 40:

          evt.preventDefault();

          this.keydown_arrow();

          break;

      }

    };



    AbstractChosen.prototype.keyup_checker = function(evt) {

      var ref, stroke;

      stroke = (ref = evt.which) != null ? ref : evt.keyCode;

      this.search_field_scale();

      switch (stroke) {

        case 8:

          if (this.is_multiple && this.backstroke_length < 1 && this.choices_count() > 0) {

            this.keydown_backstroke();

          } else if (!this.pending_backstroke) {

            this.result_clear_highlight();

            this.results_search();

          }

          break;

        case 13:

          evt.preventDefault();

          if (this.results_showing) {

            this.result_select(evt);

          }

          break;

        case 27:

          if (this.results_showing) {

            this.results_hide();

          }

          break;

        case 9:

        case 16:

        case 17:

        case 18:

        case 38:

        case 40:

        case 91:

          break;

        default:

          this.results_search();

          break;

      }

    };



    AbstractChosen.prototype.clipboard_event_checker = function(evt) {

      if (this.is_disabled) {

        return;

      }

      return setTimeout(((function(_this) {

        return function() {

          return _this.results_search();

        };

      })(this)), 50);

    };



    AbstractChosen.prototype.container_width = function() {

      if (this.options.width != null) {

        return this.options.width;

      } else {

        return this.form_field.offsetWidth + "px";

      }

    };



    AbstractChosen.prototype.include_option_in_results = function(option) {

      if (this.is_multiple && (!this.display_selected_options && option.selected)) {

        return false;

      }

      if (!this.display_disabled_options && option.disabled) {

        return false;

      }

      if (option.empty) {

        return false;

      }

      return true;

    };



    AbstractChosen.prototype.search_results_touchstart = function(evt) {

      this.touch_started = true;

      return this.search_results_mouseover(evt);

    };



    AbstractChosen.prototype.search_results_touchmove = function(evt) {

      this.touch_started = false;

      return this.search_results_mouseout(evt);

    };



    AbstractChosen.prototype.search_results_touchend = function(evt) {

      if (this.touch_started) {

        return this.search_results_mouseup(evt);

      }

    };



    AbstractChosen.prototype.outerHTML = function(element) {

      var tmp;

      if (element.outerHTML) {

        return element.outerHTML;

      }

      tmp = document.createElement("div");

      tmp.appendChild(element);

      return tmp.innerHTML;

    };



    AbstractChosen.prototype.get_single_html = function() {

      return "<a class=\"chosen-single chosen-default\">\n  <span>" + this.default_text + "</span>\n  <div><b></b></div>\n</a>\n<div class=\"chosen-drop\">\n  <div class=\"chosen-search\">\n    <input class=\"chosen-search-input\" type=\"text\" autocomplete=\"off\" />\n  </div>\n  <ul class=\"chosen-results\"></ul>\n</div>";

    };



    AbstractChosen.prototype.get_multi_html = function() {

      return "<ul class=\"chosen-choices\">\n  <li class=\"search-field\">\n    <input class=\"chosen-search-input\" type=\"text\" autocomplete=\"off\" value=\"" + this.default_text + "\" />\n  </li>\n</ul>\n<div class=\"chosen-drop\">\n  <ul class=\"chosen-results\"></ul>\n</div>";

    };



    AbstractChosen.prototype.get_no_results_html = function(terms) {

      return "<li class=\"no-results\">\n  " + this.results_none_found + " <span>" + (this.escape_html(terms)) + "</span>\n</li>";

    };



    AbstractChosen.browser_is_supported = function() {

      if ("Microsoft Internet Explorer" === window.navigator.appName) {

        return document.documentMode >= 8;

      }

      if (/iP(od|hone)/i.test(window.navigator.userAgent) || /IEMobile/i.test(window.navigator.userAgent) || /Windows Phone/i.test(window.navigator.userAgent) || /BlackBerry/i.test(window.navigator.userAgent) || /BB10/i.test(window.navigator.userAgent) || /Android.*Mobile/i.test(window.navigator.userAgent)) {

        return false;

      }

      return true;

    };



    AbstractChosen.default_multiple_text = "Select Some Options";



    AbstractChosen.default_single_text = "Select an Option";



    AbstractChosen.default_no_result_text = "No results match";



    return AbstractChosen;



  })();



  $ = jQuery;



  $.fn.extend({

    chosen: function(options) {

      if (!AbstractChosen.browser_is_supported()) {

        return this;

      }

      return this.each(function(input_field) {

        var $this, chosen;

        $this = $(this);

        chosen = $this.data('chosen');

        if (options === 'destroy') {

          if (chosen instanceof Chosen) {

            chosen.destroy();

          }

          return;

        }

        if (!(chosen instanceof Chosen)) {

          $this.data('chosen', new Chosen(this, options));

        }

      });

    }

  });



  Chosen = (function(superClass) {

    extend(Chosen, superClass);



    function Chosen() {

      return Chosen.__super__.constructor.apply(this, arguments);

    }



    Chosen.prototype.setup = function() {

      this.form_field_jq = $(this.form_field);

      return this.current_selectedIndex = this.form_field.selectedIndex;

    };



    Chosen.prototype.set_up_html = function() {

      var container_classes, container_props;

      container_classes = ["chosen-container"];

      container_classes.push("chosen-container-" + (this.is_multiple ? "multi" : "single"));

      if (this.inherit_select_classes && this.form_field.className) {

        container_classes.push(this.form_field.className);

      }

      if (this.is_rtl) {

        container_classes.push("chosen-rtl");

      }

      container_props = {

        'class': container_classes.join(' '),

        'title': this.form_field.title

      };

      if (this.form_field.id.length) {

        container_props.id = this.form_field.id.replace(/[^\w]/g, '_') + "_chosen";

      }

      this.container = $("<div />", container_props);

      this.container.width(this.container_width());

      if (this.is_multiple) {

        this.container.html(this.get_multi_html());

      } else {

        this.container.html(this.get_single_html());

      }

      this.form_field_jq.hide().after(this.container);

      this.dropdown = this.container.find('div.chosen-drop').first();

      this.search_field = this.container.find('input').first();

      this.search_results = this.container.find('ul.chosen-results').first();

      this.search_field_scale();

      this.search_no_results = this.container.find('li.no-results').first();

      if (this.is_multiple) {

        this.search_choices = this.container.find('ul.chosen-choices').first();

        this.search_container = this.container.find('li.search-field').first();

      } else {

        this.search_container = this.container.find('div.chosen-search').first();

        this.selected_item = this.container.find('.chosen-single').first();

      }

      this.results_build();

      this.set_tab_index();

      return this.set_label_behavior();

    };



    Chosen.prototype.on_ready = function() {

      return this.form_field_jq.trigger("chosen:ready", {

        chosen: this

      });

    };



    Chosen.prototype.register_observers = function() {

      this.container.on('touchstart.chosen', (function(_this) {

        return function(evt) {

          _this.container_mousedown(evt);

        };

      })(this));

      this.container.on('touchend.chosen', (function(_this) {

        return function(evt) {

          _this.container_mouseup(evt);

        };

      })(this));

      this.container.on('mousedown.chosen', (function(_this) {

        return function(evt) {

          _this.container_mousedown(evt);

        };

      })(this));

      this.container.on('mouseup.chosen', (function(_this) {

        return function(evt) {

          _this.container_mouseup(evt);

        };

      })(this));

      this.container.on('mouseenter.chosen', (function(_this) {

        return function(evt) {

          _this.mouse_enter(evt);

        };

      })(this));

      this.container.on('mouseleave.chosen', (function(_this) {

        return function(evt) {

          _this.mouse_leave(evt);

        };

      })(this));

      this.search_results.on('mouseup.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_mouseup(evt);

        };

      })(this));

      this.search_results.on('mouseover.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_mouseover(evt);

        };

      })(this));

      this.search_results.on('mouseout.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_mouseout(evt);

        };

      })(this));

      this.search_results.on('mousewheel.chosen DOMMouseScroll.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_mousewheel(evt);

        };

      })(this));

      this.search_results.on('touchstart.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_touchstart(evt);

        };

      })(this));

      this.search_results.on('touchmove.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_touchmove(evt);

        };

      })(this));

      this.search_results.on('touchend.chosen', (function(_this) {

        return function(evt) {

          _this.search_results_touchend(evt);

        };

      })(this));

      this.form_field_jq.on("chosen:updated.chosen", (function(_this) {

        return function(evt) {

          _this.results_update_field(evt);

        };

      })(this));

      this.form_field_jq.on("chosen:activate.chosen", (function(_this) {

        return function(evt) {

          _this.activate_field(evt);

        };

      })(this));

      this.form_field_jq.on("chosen:open.chosen", (function(_this) {

        return function(evt) {

          _this.container_mousedown(evt);

        };

      })(this));

      this.form_field_jq.on("chosen:close.chosen", (function(_this) {

        return function(evt) {

          _this.close_field(evt);

        };

      })(this));

      this.search_field.on('blur.chosen', (function(_this) {

        return function(evt) {

          _this.input_blur(evt);

        };

      })(this));

      this.search_field.on('keyup.chosen', (function(_this) {

        return function(evt) {

          _this.keyup_checker(evt);

        };

      })(this));

      this.search_field.on('keydown.chosen', (function(_this) {

        return function(evt) {

          _this.keydown_checker(evt);

        };

      })(this));

      this.search_field.on('focus.chosen', (function(_this) {

        return function(evt) {

          _this.input_focus(evt);

        };

      })(this));

      this.search_field.on('cut.chosen', (function(_this) {

        return function(evt) {

          _this.clipboard_event_checker(evt);

        };

      })(this));

      this.search_field.on('paste.chosen', (function(_this) {

        return function(evt) {

          _this.clipboard_event_checker(evt);

        };

      })(this));

      if (this.is_multiple) {

        return this.search_choices.on('click.chosen', (function(_this) {

          return function(evt) {

            _this.choices_click(evt);

          };

        })(this));

      } else {

        return this.container.on('click.chosen', function(evt) {

          evt.preventDefault();

        });

      }

    };



    Chosen.prototype.destroy = function() {

      $(this.container[0].ownerDocument).off('click.chosen', this.click_test_action);

      if (this.form_field_label.length > 0) {

        this.form_field_label.off('click.chosen');

      }

      if (this.search_field[0].tabIndex) {

        this.form_field_jq[0].tabIndex = this.search_field[0].tabIndex;

      }

      this.container.remove();

      this.form_field_jq.removeData('chosen');

      return this.form_field_jq.show();

    };



    Chosen.prototype.search_field_disabled = function() {

      this.is_disabled = this.form_field.disabled || this.form_field_jq.parents('fieldset').is(':disabled');

      this.container.toggleClass('chosen-disabled', this.is_disabled);

      this.search_field[0].disabled = this.is_disabled;

      if (!this.is_multiple) {

        this.selected_item.off('focus.chosen', this.activate_field);

      }

      if (this.is_disabled) {

        return this.close_field();

      } else if (!this.is_multiple) {

        return this.selected_item.on('focus.chosen', this.activate_field);

      }

    };



    Chosen.prototype.container_mousedown = function(evt) {

      var ref;

      if (this.is_disabled) {

        return;

      }

      if (evt && ((ref = evt.type) === 'mousedown' || ref === 'touchstart') && !this.results_showing) {

        evt.preventDefault();

      }

      if (!((evt != null) && ($(evt.target)).hasClass("search-choice-close"))) {

        if (!this.active_field) {

          if (this.is_multiple) {

            this.search_field.val("");

          }

          $(this.container[0].ownerDocument).on('click.chosen', this.click_test_action);

          this.results_show();

        } else if (!this.is_multiple && evt && (($(evt.target)[0] === this.selected_item[0]) || $(evt.target).parents("a.chosen-single").length)) {

          evt.preventDefault();

          this.results_toggle();

        }

        return this.activate_field();

      }

    };



    Chosen.prototype.container_mouseup = function(evt) {

      if (evt.target.nodeName === "ABBR" && !this.is_disabled) {

        return this.results_reset(evt);

      }

    };



    Chosen.prototype.search_results_mousewheel = function(evt) {

      var delta;

      if (evt.originalEvent) {

        delta = evt.originalEvent.deltaY || -evt.originalEvent.wheelDelta || evt.originalEvent.detail;

      }

      if (delta != null) {

        evt.preventDefault();

        if (evt.type === 'DOMMouseScroll') {

          delta = delta * 40;

        }

        return this.search_results.scrollTop(delta + this.search_results.scrollTop());

      }

    };



    Chosen.prototype.blur_test = function(evt) {

      if (!this.active_field && this.container.hasClass("chosen-container-active")) {

        return this.close_field();

      }

    };



    Chosen.prototype.close_field = function() {

      $(this.container[0].ownerDocument).off("click.chosen", this.click_test_action);

      this.active_field = false;

      this.results_hide();

      this.container.removeClass("chosen-container-active");

      this.clear_backstroke();

      this.show_search_field_default();

      this.search_field_scale();

      return this.search_field.blur();

    };



    Chosen.prototype.activate_field = function() {

      if (this.is_disabled) {

        return;

      }

      this.container.addClass("chosen-container-active");

      this.active_field = true;

      this.search_field.val(this.search_field.val());

      return this.search_field.focus();

    };



    Chosen.prototype.test_active_click = function(evt) {

      var active_container;

      active_container = $(evt.target).closest('.chosen-container');

      if (active_container.length && this.container[0] === active_container[0]) {

        return this.active_field = true;

      } else {

        return this.close_field();

      }

    };



    Chosen.prototype.results_build = function() {

      this.parsing = true;

      this.selected_option_count = null;

      this.results_data = SelectParser.select_to_array(this.form_field);

      if (this.is_multiple) {

        this.search_choices.find("li.search-choice").remove();

      } else {

        this.single_set_selected_text();

        if (this.disable_search || this.form_field.options.length <= this.disable_search_threshold) {

          this.search_field[0].readOnly = true;

          this.container.addClass("chosen-container-single-nosearch");

        } else {

          this.search_field[0].readOnly = false;

          this.container.removeClass("chosen-container-single-nosearch");

        }

      }

      this.update_results_content(this.results_option_build({

        first: true

      }));

      this.search_field_disabled();

      this.show_search_field_default();

      this.search_field_scale();

      return this.parsing = false;

    };



    Chosen.prototype.result_do_highlight = function(el) {

      var high_bottom, high_top, maxHeight, visible_bottom, visible_top;

      if (el.length) {

        this.result_clear_highlight();

        this.result_highlight = el;

        this.result_highlight.addClass("highlighted");

        maxHeight = parseInt(this.search_results.css("maxHeight"), 10);

        visible_top = this.search_results.scrollTop();

        visible_bottom = maxHeight + visible_top;

        high_top = this.result_highlight.position().top + this.search_results.scrollTop();

        high_bottom = high_top + this.result_highlight.outerHeight();

        if (high_bottom >= visible_bottom) {

          return this.search_results.scrollTop((high_bottom - maxHeight) > 0 ? high_bottom - maxHeight : 0);

        } else if (high_top < visible_top) {

          return this.search_results.scrollTop(high_top);

        }

      }

    };



    Chosen.prototype.result_clear_highlight = function() {

      if (this.result_highlight) {

        this.result_highlight.removeClass("highlighted");

      }

      return this.result_highlight = null;

    };



    Chosen.prototype.results_show = function() {

      if (this.is_multiple && this.max_selected_options <= this.choices_count()) {

        this.form_field_jq.trigger("chosen:maxselected", {

          chosen: this

        });

        return false;

      }

      this.container.addClass("chosen-with-drop");

      this.results_showing = true;

      this.search_field.focus();

      this.search_field.val(this.get_search_field_value());

      this.winnow_results();

      return this.form_field_jq.trigger("chosen:showing_dropdown", {

        chosen: this

      });

    };



    Chosen.prototype.update_results_content = function(content) {

      return this.search_results.html(content);

    };



    Chosen.prototype.results_hide = function() {

      if (this.results_showing) {

        this.result_clear_highlight();

        this.container.removeClass("chosen-with-drop");

        this.form_field_jq.trigger("chosen:hiding_dropdown", {

          chosen: this

        });

      }

      return this.results_showing = false;

    };



    Chosen.prototype.set_tab_index = function(el) {

      var ti;

      if (this.form_field.tabIndex) {

        ti = this.form_field.tabIndex;

        this.form_field.tabIndex = -1;

        return this.search_field[0].tabIndex = ti;

      }

    };



    Chosen.prototype.set_label_behavior = function() {

      this.form_field_label = this.form_field_jq.parents("label");

      if (!this.form_field_label.length && this.form_field.id.length) {

        this.form_field_label = $("label[for='" + this.form_field.id + "']");

      }

      if (this.form_field_label.length > 0) {

        return this.form_field_label.on('click.chosen', this.label_click_handler);

      }

    };



    Chosen.prototype.show_search_field_default = function() {

      if (this.is_multiple && this.choices_count() < 1 && !this.active_field) {

        this.search_field.val(this.default_text);

        return this.search_field.addClass("default");

      } else {

        this.search_field.val("");

        return this.search_field.removeClass("default");

      }

    };



    Chosen.prototype.search_results_mouseup = function(evt) {

      var target;

      target = $(evt.target).hasClass("active-result") ? $(evt.target) : $(evt.target).parents(".active-result").first();

      if (target.length) {

        this.result_highlight = target;

        this.result_select(evt);

        return this.search_field.focus();

      }

    };



    Chosen.prototype.search_results_mouseover = function(evt) {

      var target;

      target = $(evt.target).hasClass("active-result") ? $(evt.target) : $(evt.target).parents(".active-result").first();

      if (target) {

        return this.result_do_highlight(target);

      }

    };



    Chosen.prototype.search_results_mouseout = function(evt) {

      if ($(evt.target).hasClass("active-result") || $(evt.target).parents('.active-result').first()) {

        return this.result_clear_highlight();

      }

    };



    Chosen.prototype.choice_build = function(item) {

      var choice, close_link;

      choice = $('<li />', {

        "class": "search-choice"

      }).html("<span>" + (this.choice_label(item)) + "</span>");

      if (item.disabled) {

        choice.addClass('search-choice-disabled');

      } else {

        close_link = $('<a />', {

          "class": 'search-choice-close',

          'data-option-array-index': item.array_index

        });

        close_link.on('click.chosen', (function(_this) {

          return function(evt) {

            return _this.choice_destroy_link_click(evt);

          };

        })(this));

        choice.append(close_link);

      }

      return this.search_container.before(choice);

    };



    Chosen.prototype.choice_destroy_link_click = function(evt) {

      evt.preventDefault();

      evt.stopPropagation();

      if (!this.is_disabled) {

        return this.choice_destroy($(evt.target));

      }

    };



    Chosen.prototype.choice_destroy = function(link) {

      if (this.result_deselect(link[0].getAttribute("data-option-array-index"))) {

        if (this.active_field) {

          this.search_field.focus();

        } else {

          this.show_search_field_default();

        }

        if (this.is_multiple && this.choices_count() > 0 && this.get_search_field_value().length < 1) {

          this.results_hide();

        }

        link.parents('li').first().remove();

        return this.search_field_scale();

      }

    };



    Chosen.prototype.results_reset = function() {

      this.reset_single_select_options();

      this.form_field.options[0].selected = true;

      this.single_set_selected_text();

      this.show_search_field_default();

      this.results_reset_cleanup();

      this.trigger_form_field_change();

      if (this.active_field) {

        return this.results_hide();

      }

    };



    Chosen.prototype.results_reset_cleanup = function() {

      this.current_selectedIndex = this.form_field.selectedIndex;

      return this.selected_item.find("abbr").remove();

    };



    Chosen.prototype.result_select = function(evt) {

      var high, item;

      if (this.result_highlight) {

        high = this.result_highlight;

        this.result_clear_highlight();

        if (this.is_multiple && this.max_selected_options <= this.choices_count()) {

          this.form_field_jq.trigger("chosen:maxselected", {

            chosen: this

          });

          return false;

        }

        if (this.is_multiple) {

          high.removeClass("active-result");

        } else {

          this.reset_single_select_options();

        }

        high.addClass("result-selected");

        item = this.results_data[high[0].getAttribute("data-option-array-index")];

        item.selected = true;

        this.form_field.options[item.options_index].selected = true;

        this.selected_option_count = null;

        if (this.is_multiple) {

          this.choice_build(item);

        } else {

          this.single_set_selected_text(this.choice_label(item));

        }

        if (this.is_multiple && (!this.hide_results_on_select || (evt.metaKey || evt.ctrlKey))) {

          if (evt.metaKey || evt.ctrlKey) {

            this.winnow_results({

              skip_highlight: true

            });

          } else {

            this.search_field.val("");

            this.winnow_results();

          }

        } else {

          this.results_hide();

          this.show_search_field_default();

        }

        if (this.is_multiple || this.form_field.selectedIndex !== this.current_selectedIndex) {

          this.trigger_form_field_change({

            selected: this.form_field.options[item.options_index].value

          });

        }

        this.current_selectedIndex = this.form_field.selectedIndex;

        evt.preventDefault();

        return this.search_field_scale();

      }

    };



    Chosen.prototype.single_set_selected_text = function(text) {

      if (text == null) {

        text = this.default_text;

      }

      if (text === this.default_text) {

        this.selected_item.addClass("chosen-default");

      } else {

        this.single_deselect_control_build();

        this.selected_item.removeClass("chosen-default");

      }

      return this.selected_item.find("span").html(text);

    };



    Chosen.prototype.result_deselect = function(pos) {

      var result_data;

      result_data = this.results_data[pos];

      if (!this.form_field.options[result_data.options_index].disabled) {

        result_data.selected = false;

        this.form_field.options[result_data.options_index].selected = false;

        this.selected_option_count = null;

        this.result_clear_highlight();

        if (this.results_showing) {

          this.winnow_results();

        }

        this.trigger_form_field_change({

          deselected: this.form_field.options[result_data.options_index].value

        });

        this.search_field_scale();

        return true;

      } else {

        return false;

      }

    };



    Chosen.prototype.single_deselect_control_build = function() {

      if (!this.allow_single_deselect) {

        return;

      }

      if (!this.selected_item.find("abbr").length) {

        this.selected_item.find("span").first().after("<abbr class=\"search-choice-close\"></abbr>");

      }

      return this.selected_item.addClass("chosen-single-with-deselect");

    };



    Chosen.prototype.get_search_field_value = function() {

      return this.search_field.val();

    };



    Chosen.prototype.get_search_text = function() {

      return $.trim(this.get_search_field_value());

    };



    Chosen.prototype.escape_html = function(text) {

      return $('<div/>').text(text).html();

    };



    Chosen.prototype.winnow_results_set_highlight = function() {

      var do_high, selected_results;

      selected_results = !this.is_multiple ? this.search_results.find(".result-selected.active-result") : [];

      do_high = selected_results.length ? selected_results.first() : this.search_results.find(".active-result").first();

      if (do_high != null) {

        return this.result_do_highlight(do_high);

      }

    };



    Chosen.prototype.no_results = function(terms) {

      var no_results_html;

      no_results_html = this.get_no_results_html(terms);

      this.search_results.append(no_results_html);

      return this.form_field_jq.trigger("chosen:no_results", {

        chosen: this

      });

    };



    Chosen.prototype.no_results_clear = function() {

      return this.search_results.find(".no-results").remove();

    };



    Chosen.prototype.keydown_arrow = function() {

      var next_sib;

      if (this.results_showing && this.result_highlight) {

        next_sib = this.result_highlight.nextAll("li.active-result").first();

        if (next_sib) {

          return this.result_do_highlight(next_sib);

        }

      } else {

        return this.results_show();

      }

    };



    Chosen.prototype.keyup_arrow = function() {

      var prev_sibs;

      if (!this.results_showing && !this.is_multiple) {

        return this.results_show();

      } else if (this.result_highlight) {

        prev_sibs = this.result_highlight.prevAll("li.active-result");

        if (prev_sibs.length) {

          return this.result_do_highlight(prev_sibs.first());

        } else {

          if (this.choices_count() > 0) {

            this.results_hide();

          }

          return this.result_clear_highlight();

        }

      }

    };



    Chosen.prototype.keydown_backstroke = function() {

      var next_available_destroy;

      if (this.pending_backstroke) {

        this.choice_destroy(this.pending_backstroke.find("a").first());

        return this.clear_backstroke();

      } else {

        next_available_destroy = this.search_container.siblings("li.search-choice").last();

        if (next_available_destroy.length && !next_available_destroy.hasClass("search-choice-disabled")) {

          this.pending_backstroke = next_available_destroy;

          if (this.single_backstroke_delete) {

            return this.keydown_backstroke();

          } else {

            return this.pending_backstroke.addClass("search-choice-focus");

          }

        }

      }

    };



    Chosen.prototype.clear_backstroke = function() {

      if (this.pending_backstroke) {

        this.pending_backstroke.removeClass("search-choice-focus");

      }

      return this.pending_backstroke = null;

    };



    Chosen.prototype.search_field_scale = function() {

      var div, i, len, style, style_block, styles, width;

      if (!this.is_multiple) {

        return;

      }

      style_block = {

        position: 'absolute',

        left: '-1000px',

        top: '-1000px',

        display: 'none',

        whiteSpace: 'pre'

      };

      styles = ['fontSize', 'fontStyle', 'fontWeight', 'fontFamily', 'lineHeight', 'textTransform', 'letterSpacing'];

      for (i = 0, len = styles.length; i < len; i++) {

        style = styles[i];

        style_block[style] = this.search_field.css(style);

      }

      div = $('<div />').css(style_block);

      div.text(this.get_search_field_value());

      $('body').append(div);

      width = div.width() + 25;

      div.remove();

      if (this.container.is(':visible')) {

        width = Math.min(this.container.outerWidth() - 10, width);

      }

      return this.search_field.width(width);

    };



    Chosen.prototype.trigger_form_field_change = function(extra) {

      this.form_field_jq.trigger("input", extra);

      return this.form_field_jq.trigger("change", extra);

    };



    return Chosen;



  })(AbstractChosen);



}).call(this);

;/**

*

* jQuery Interdependencies library

* http://miohtama.github.com/jquery-interdependencies/

* Copyright 2012-2013 Mikko Ohtamaa, others

*

* Customized by Codestar

*

*/

(function($) {



  'use strict';



  function Rule(controller, condition, value) {

    this.init(controller, condition, value);

  }



  $.extend(Rule.prototype, {



    init: function(controller, condition, value) {



      this.controller = controller;

      this.condition  = condition;

      this.value      = value;

      this.rules      = [];

      this.controls   = [];



    },



    evalCondition: function(context, control, condition, val1, val2) {



      if( condition == '==' ) {



        return this.checkBoolean(val1) == this.checkBoolean(val2);



      } else if( condition == '!=' ) {



        return this.checkBoolean(val1) != this.checkBoolean(val2);



      } else if( condition == '>=' ) {



        return Number(val2) >= Number(val1);



      } else if( condition == '<=' ) {



        return Number(val2) <= Number(val1);



      } else if( condition == '>' ) {



        return Number(val2) > Number(val1);



      } else if( condition == '<' ) {



        return Number(val2) < Number(val1);



      } else if( condition == '()' ) {



        return window[val1](context, control, val2);



      } else if( condition == 'any' ) {



        if( $.isArray( val2 ) ) {

          for (var i = val2.length - 1; i >= 0; i--) {

            if( $.inArray( val2[i], val1.split(',') ) !== -1 ) {

              return true;

            }

          }

        } else {

          if( $.inArray( val2, val1.split(',') ) !== -1 ) {

            return true;

          }

        }



      } else if( condition == 'not-any' ) {



        if( $.isArray( val2 ) ) {

          for (var i = val2.length - 1; i >= 0; i--) {

            if( $.inArray( val2[i], val1.split(',') ) == -1 ) {

              return true;

            }

          }

        } else {

          if( $.inArray( val2, val1.split(',') ) == -1 ) {

            return true;

          }

        }



      }



      return false;



    },



    checkBoolean: function(value) {



      switch( value ) {



        case true:

        case 'true':

        case 1:

        case '1':

          value = true;

        break;



        case null:

        case false:

        case 'false':

        case 0:

        case '0':

          value = false;

        break;



      }



      return value;

    },



    checkCondition: function( context ) {



      if( !this.condition ) {

        return true;

      }



      var control = context.find(this.controller);



      var control_value = this.getControlValue(context, control);



      if( control_value === undefined ) {

        return false;

      }



      control_value = this.normalizeValue(control, this.value, control_value);



      return this.evalCondition(context, control, this.condition, this.value, control_value);

    },



    normalizeValue: function( control, baseValue, control_value ) {



      if( typeof baseValue == 'number' ) {

        return parseFloat( control_value );

      }



      return control_value;

    },



    getControlValue: function(context, control) {



      if( control.length > 1 && ( control.attr('type') == 'radio' || control.attr('type') == 'checkbox' ) ) {



        return control.filter(':checked').map(function() { return this.value; }).get();



      } else if ( control.attr('type') == 'checkbox' || control.attr('type') == 'radio' ) {



        return control.is(':checked');



      }



      return control.val();



    },



    createRule: function(controller, condition, value) {

      var rule = new Rule(controller, condition, value);

      this.rules.push(rule);

      return rule;

    },



    include: function(input) {

      this.controls.push(input);

    },



    applyRule: function(context, enforced) {



      var result;



      if( typeof( enforced ) == 'undefined' ) {

        result = this.checkCondition(context);

      } else {

        result = enforced;

      }



      var controls = $.map(this.controls, function(elem, idx) {

        return context.find(elem);

      });



      if( result ) {



        $(controls).each(function() {

          $(this).removeClass('csf-depend-on');

        });



        $(this.rules).each(function() {

          this.applyRule(context);

        });



      } else {



        $(controls).each(function() {

          $(this).addClass('csf-depend-on');

        });



        $(this.rules).each(function() {

          this.applyRule(context, false);

        });



      }

    }

  });



  function Ruleset() {

    this.rules = [];

  };



  $.extend(Ruleset.prototype, {



    createRule: function(controller, condition, value) {

      var rule = new Rule(controller, condition, value);

      this.rules.push(rule);

      return rule;

    },



    applyRules: function(context) {

      $(this.rules).each(function() {

        this.applyRule(context);

      });

    }

  });



  $.csf_deps = {



    createRuleset: function() {

      return new Ruleset();

    },



    enable: function(selection, ruleset, depends) {



      selection.on('change keyup', function(elem) {



        var depend_id = elem.target.getAttribute('data-depend-id') || elem.target.getAttribute('data-sub-depend-id');



        if( depends.indexOf( depend_id ) !== -1 ) {

          ruleset.applyRules(selection);

        }



      });



      ruleset.applyRules(selection);



      return true;

    }

  };



})(jQuery);

;/**

 *

 * jQuery serializeObject

 *

 * @copyright 2014, macek <paulmacek@gmail.com>

 * @link https://github.com/macek/jquery-serialize-object

 * @license BSD

 * @version 2.5.0

 *

 * Customized by Codestar

 *

 */

(function(root, factory) {



  // AMD

  if (typeof define === "function" && define.amd) {

    define(["exports", "jquery"], function(exports, $) {

      return factory(exports, $);

    });

  }



  // CommonJS

  else if (typeof exports !== "undefined") {

    var $ = require("jquery");

    factory(exports, $);

  }



  // Browser

  else {

    factory(root, (root.jQuery || root.Zepto || root.ender || root.$));

  }



}(this, function(exports, $) {



  //

  // Codestar: Added custom patterns for spesific validate

  //

  var patterns = {

    validate: /^(?!(_nonce|_pseudo))[a-zA-Z0-9_-]*(?:\[(?:\d*|(?!(_nonce|_pseudo))[a-zA-Z0-9_-]+)\])*$/i,

    key: /[a-zA-Z0-9_-]+|(?=\[\])/g,

    named: /^[a-zA-Z0-9_-]+$/,

    push: /^$/,

    fixed: /^\d+$/

  };



  function FormSerializer(helper, $form) {



    // private variables

    var data     = {},

        pushes   = {};



    // private API

    function build(base, key, value) {

      base[key] = value;

      return base;

    }



    function makeObject(root, value) {



      var keys = root.match(patterns.key), k;



      // nest, nest, ..., nest

      while ((k = keys.pop()) !== undefined) {

        // foo[]

        if (patterns.push.test(k)) {

          var idx = incrementPush(root.replace(/\[\]$/, ''));

          value = build([], idx, value);

        }



        // foo[n]

        else if (patterns.fixed.test(k)) {

          value = build([], k, value);

        }



        // foo; foo[bar]

        else if (patterns.named.test(k)) {

          value = build({}, k, value);

        }

      }



      return value;

    }



    function incrementPush(key) {

      if (pushes[key] === undefined) {

        pushes[key] = 0;

      }

      return pushes[key]++;

    }



    function addPair(pair) {

      if (!patterns.validate.test(pair.name)) return this;

      var obj = makeObject(pair.name, pair.value);

      data = helper.extend(true, data, obj);

      return this;

    }



    function addPairs(pairs) {

      if (!helper.isArray(pairs)) {

        throw new Error("formSerializer.addPairs expects an Array");

      }

      for (var i=0, len=pairs.length; i<len; i++) {

        this.addPair(pairs[i]);

      }

      return this;

    }



    function serialize() {

      return data;

    }



    function serializeJSON() {

      return JSON.stringify(serialize());

    }



    // public API

    this.addPair = addPair;

    this.addPairs = addPairs;

    this.serialize = serialize;

    this.serializeJSON = serializeJSON;

  }



  FormSerializer.patterns = patterns;



  FormSerializer.serializeObject = function serializeObject() {

    return new FormSerializer($, this).

      addPairs(this.serializeArray()).

      serialize();

  };



  FormSerializer.serializeJSON = function serializeJSON() {

    return new FormSerializer($, this).

      addPairs(this.serializeArray()).

      serializeJSON();

  };



  //

  // Codestar: Renamed function names for avoid conflicts

  //



  if (typeof $.fn !== "undefined") {

    $.fn.serializeObjectCSF = FormSerializer.serializeObject;

    $.fn.serializeJSONCSF   = FormSerializer.serializeJSON;

  }



  exports.FormSerializer = FormSerializer;



  return FormSerializer;

}));

