<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 * @version 4.2.4
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
global $post;
$event_id = get_the_ID();

$data    = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single' )->get();
$options = towngov_WSH()->option();


$event_thumbnail_id = get_post_thumbnail_id($event_id);
$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id);
$time_format          = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
$start_datetime = tribe_get_start_date();
$start_date = tribe_get_start_date( null, false );

$start_date_d = tribe_get_start_date( null, false, 'd' );
$start_date_m = tribe_get_start_date( null, false, 'M' );
$start_date_y = tribe_get_start_date( null, false, 'Y' );

$start_time = tribe_get_start_date( null, false, $time_format );
$start_ts = tribe_get_start_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

$end_datetime = tribe_get_end_date();
$end_date = tribe_get_display_end_date( null, false );
$end_time = tribe_get_end_date( null, false, $time_format );
$end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

$location = tribe_get_venue(  );
$website = tribe_get_event_website_link();
$cost = tribe_get_formatted_cost();
?>

<!-- Page Title -->
<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->
<!-- End Page Title -->

<!-- event-details -->
<section class="event-details-section">
    <div class="container">
        <div class="row">
        	<?php 
				while ( have_posts() ) : the_post(); 
				$towngov_event_meta = get_post_meta( get_the_ID(), 'towngov_meta_event', true );
			?>
            <div class="col-lg-12">
                <div class="event-details-inner-box">
                    <div class="img-fluid"><?php the_post_thumbnail('full', array( 'class' => 'img-fluid' )); ?></div>
                    <div class="event-details-meta">
                        <div class="event-details-meta-number">
                            <span><?php echo wp_kses($start_date_d, true); ?></span>
                        </div><!-- event-details-meta-number -->
                        <div class="event-details-meta-date">
                            <span><?php echo wp_kses($start_date_m, true); ?> <?php echo wp_kses($start_date_y, true); ?></span>
                        </div><!-- event-details-meta-date -->
                    </div><!-- event-details-meta -->
                </div><!-- event-details-inner-box -->
            </div><!-- col-lg-12 -->
            
            <div class="content-side col-lg-8">
                	
                <div class="event-details-content-box">
                    <h4><?php the_title(); ?></h4>
					
					<?php do_action( 'tribe_events_single_event_before_the_content' ) ?>
					<div class="text"><?php the_content();?></div>
                    <?php do_action( 'tribe_events_single_event_after_the_content' ) ?>
                    
                    <?php if($towngov_event_meta['show_speakers_info']){ ?>
                    <h3 class="event-details-title"><?php echo wp_kses($towngov_event_meta['speakers_main_heading'], true ); ?></h3>
                    <div class="event-details-speaker-box">
                        <div class="row row-gutter-30">
                            <?php 						
								foreach($towngov_event_meta['speakers_info'] as $key => $towngov_set):	
								$towngov_event_meta = get_post_meta(get_the_ID(), 'towngov_meta_event', true );										
							?>
                            <div class="col-xl-3 col-md-6">
                                <div class="event-speaker-list">
                                    <div class="event-speaker-list-img">
                                        <img src="<?php echo wp_get_attachment_url($towngov_set['speaker_image']['id'], true);?>" class="img-fluid" alt="<?php esc_attr_e('Awesome Image', 'towngov'); ?>">
                                    </div><!-- event-speaker-list-img -->
                                    <h5> <a href="<?php echo esc_url( $towngov_set['speaker_link']);?>"><?php echo wp_kses( $towngov_set['speaker_title'], true );?></a></h5>
                                    <p><?php echo wp_kses( $towngov_set['speaker_designation'], true );?></p>
                                </div><!-- event-speaker-list -->
                            </div><!-- col-xl-3 col-md-6 -->
                            <?php endforeach; ?>
                        </div><!-- row -->
                    </div><!-- event-details-speaker-box -->
					<?php } ?>
                    
                    <?php if($towngov_event_meta['show_gallery_info']){ ?>
                    <div class="event-details-gallery-box">
                        <h3><?php echo wp_kses($towngov_event_meta['gallery_main_heading'], true ); ?></h3>
                        <div class="event-details-carousel owl-carousel owl-theme">
                            <?php $gall_images = $towngov_event_meta['gallery_imgs'];
								 $gall_images = explode(',', $gall_images);
								 if ($gall_images) :
								 foreach ($gall_images as $gall) :
							?>
							<div class="item">
								<?php echo wp_get_attachment_image($gall, 'full', array('class'=>'img-fluid'));  ?>
							</div>
							<?php endforeach; endif; ?>
                            
                        </div><!-- event-details-carousel -->
                    </div><!-- event-details-gallery-box -->
                    <?php } ?> 
                    
				</div>
                    
            </div>
        	
            <!-- sidebar area -->
			<div class="col-lg-4">
                <div class="sidebar event-sidebar">
                	<div class="sidebar-widget-event-meta-box">
                    	
                        <?php do_action( 'tribe_events_single_meta_details_section_start' );?>
                        	
                            <div class="sidebar-widget-event-meta-details">
                                <div class="sidebar-widget-event-box">
                                    <h6><?php esc_html_e( 'Start Date: ', 'towngov' );?></h6>
                                    <p><?php echo wp_kses( $start_datetime, true ) ?></p>
                                </div><!-- sidebar-widget-event-box -->
                                <div class="sidebar-widget-event-box">
                                    <h6><?php esc_html_e( 'End Date: ', 'towngov' );?></h6>
                                    <p><?php echo wp_kses( $end_datetime, true ) ?></p>
                                </div><!-- sidebar-widget-event-box -->
                                <div class="sidebar-widget-event-box">
                                    <?php
									echo str_replace( 'Categroy: ', '', tribe_get_event_categories(
										get_the_id(), array(
											'echo'         => false,
											'before'       => '',
											'sep'          => ', ',
											'after'        => '',
											'label'        => Null, // An appropriate plural/singular label will be provided
											'label_before' => '<h6>',
											'label_after'  => '</h6>',
											'wrap_before'  => '<p>',
											'wrap_after'   => '</p>',
										)
									));
									?>
                                    
                                </div><!-- sidebar-widget-event-box -->
                                <div class="sidebar-widget-event-box">
                                    <h6><?php esc_html_e( 'Website: ', 'towngov' );?></h6>
                                    <span><?php echo $website;?></span>
                                </div><!-- sidebar-widget-event-box -->
                                <div class="sidebar-widget-event-box">
                                    <h6><?php esc_html_e( 'Location: ', 'towngov' );?></h6>
                                    <p><?php echo $location;?></p>
                                </div><!-- sidebar-widget-event-box -->
                                
                                <div class="sidebar-widget-event-box">
									<?php
                                    // Event Cost
                                    if ( ! empty( $cost ) ) : ?>
                            
                                        <h6> <?php esc_html_e( 'Cost:', 'towngov' ) ?></h6>
                                        <p> <?php echo wp_kses( $cost, true ); ?> </p>
                                    <?php endif ?>
                                </div>
                                
                            </div>
                            
                            <div class="sidebar-widget-event-meta-map">
                                <div class="google-map">
                                    <?php $map = tribe_get_embedded_map();?>
                                    <?php
									// Display the map.
									do_action( 'tribe_events_single_meta_map_section_start' );
									echo $map;
									do_action( 'tribe_events_single_meta_map_section_end' );
									?>
                                </div><!-- google-map -->
                            </div>
                            <?php
								$icons = $towngov_event_meta['event_social_profile'];
								if ( ! empty( $icons ) ) :								
							?>
                            <div class="sidebar-widget-event-meta-socials">
								<?php foreach ( $icons as $h_icon ) {		
									$icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); 
								?>
								<a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>"<?php endif;?>><i class="fa-brands <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a>
								<?php } ?>
                            </div><!-- sidebar-widget-event-meta-socials -->
                            <?php endif; ?>
                            
                        <?php do_action( 'tribe_events_single_meta_details_section_end' ) ?>
                        
                    </div>
                </div>
            </div>
            
			<?php endwhile; ?>
        </div>
    </div>
</section>
<!--End blog area-->
