<?php
$options = towngov_WSH()->option(); 
//Light Color Logo Settings
$light_image_logo = $options->get( 'light_image_logo' );
$light_logo_dimension = $options->get( 'light_logo_dimension' );
$logo_type = '';
$logo_text = '';
$logo_typography = ''; 
?>
<?php if( $options->get( 'theme_preloader' ) ):?>
<div id="pre-loader">
    <div id="loader-logo"></div>
    <div id="loader-circle"></div>
    <div class="loader-section section-left"></div>
    <div class="loader-section section-right"></div>
</div>
<?php endif; ?>
<?php if( $options->get('show_search_icon_v2') ):?>
<div class="search-popup">
    <div class="search-popup-overlay search-toggler"></div>
    <?php get_template_part('searchform1')?>            
</div>
<?php endif; ?>
<div class="mobile-nav-wrapper">
    <div class="mobile-nav-overlay mobile-nav-toggler"></div>
    <div class="mobile-nav-content">
        <a href="#" class="mobile-nav-close mobile-nav-toggler">
            <span></span>
            <span></span>
        </a><!-- mobile-nav-close -->
        <div class="logo-box">
            <?php echo towngov_logo( $logo_type, $light_image_logo, $light_logo_dimension, $logo_text, $logo_typography ); ?>
        </div><!-- logo-box -->
        <div class="mobile-nav-container"></div>
        <ul class="mobile-nav-contact list-unstyled">
            <?php if( $options->get('show_phone_no2') ):?>
            <li>
                <i class="fa-solid fa-phone"></i>
                <a href="tel:<?php echo esc_attr($options->get('phone_no_v2'));?>"><?php echo wp_kses($options->get('phone_no_v2'), true);?></a>
            </li><!-- li -->
            <?php endif; ?>
            <?php if( $options->get('show_email_address2') ):?>
            <li>
                <i class="fa-solid fa-envelope"></i>
                <a href="mailto:<?php echo esc_attr($options->get('email_address_v2'));?>"><?php echo wp_kses($options->get('email_address_v2'), true);?></a>
            </li><!-- li -->
            <?php endif; ?>
            <?php if( $options->get('show_address2') ):?>
            <li>
                <i class="fa-solid fa-map-marker-alt"></i>
                <?php echo wp_kses($options->get('address_v2'), true);?>
            </li><!-- li -->
            <?php endif; ?>
        </ul><!-- mobile-nav-contact -->
        <?php if($options->get( 'show_social_media_v2' )) {
        $icons = $options->get( 'social_media_v2' );
        if ( ! empty( $icons ) ) { ?>
        <ul class="mobile-nav-social list-unstyled">
            <?php foreach ( $icons as $h_icon ) {                   
            $icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); ?>
            <li><a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>" <?php endif;?> target="_blank"><i class="fa-brands <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a></li>
            <?php } ?>
        </ul>
        <?php } } ?>
    </div><!-- mobile-nav-content -->
</div><!--mobile-nav-wrapper--> 
<header class="header header-two">
    <?php if( $options->get( 'show_topbar2' ) ):?>
    <div class="topbar-one">
        <div class="topbar-one-left">
            <div class="menu-logo">
                <?php echo towngov_logo( $logo_type, $light_image_logo, $light_logo_dimension, $logo_text, $logo_typography ); ?>
            </div><!-- menu-logo -->
        </div><!-- topbar-one-left -->
        <div class="container">
            <div class="topbar-one-middle">
                <div class="topbar-info">
                    <ul>
                        <?php if( $options->get('show_email_address2') ):?>
                        <li>
                            <div class="topbar-icon">
                                <i class="fa-solid fa-envelope"></i>
                            </div><!-- topbar-icon -->
                            <div class="topbar-text">
                                <a href="mailto:<?php echo esc_attr($options->get('email_address_v2'));?>"><?php echo wp_kses($options->get('email_address_v2'), true);?></a>
                            </div><!-- topbar-text -->
                        </li><!-- li -->
                        <?php endif; ?>
                        <?php if( $options->get('show_working_hours_v2') ):?>                        
                        <li>
                            <div class="topbar-icon">
                                <i class="fa-solid fa-clock"></i>
                            </div><!-- topbar-icon -->
                            <div class="topbar-text">
                                <span><?php echo wp_kses($options->get('working_hours_v2'), true);?></span>
                            </div><!-- topbar-text -->
                        </li><!-- li -->
                        <?php endif; ?>
                    </ul><!-- ul -->
                </div><!--topbar-info-->
                <?php if( $options->get('show_top_menu_v2') ):?>
                <div class="topbar-right">
                    <ul>
                        <?php wp_nav_menu( array( 'theme_location' => 'top_menu', 'container_id' => 'navbar-collapse-1',
                            'container_class'=>'navbar-collapse collapse navbar-right',
                            'menu_class'=>'nav navbar-nav',
                            'fallback_cb'=>false, 
                            'items_wrap' => '%3$s', 
                            'container'=>false,
                            'depth'=>'1',
                            'walker'=> new Bootstrap_walker()  
                        ) ); ?>
                    </ul><!-- ul -->
                </div><!--topbar-right-->
                <?php endif; ?>
            </div><!--topbar-one-middle-->  
            <div class="main-menu menu-two sticky-header">
                <div class="main-menu-one-inner">
                    <div class="main-menu-left">
                        <div class="navigation">
                            <ul class="main-menu-list list-unstyled">
                                <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                    'container_class'=>'navbar-collapse collapse navbar-right',
                                    'menu_class'=>'nav navbar-nav',
                                    'fallback_cb'=>false, 
                                    'items_wrap' => '%3$s', 
                                    'container'=>false,
                                    'depth'=>'3',
                                    'walker'=> new Bootstrap_walker()  
                                ) ); ?>
                            </ul><!-- main-menu-list -->
                        </div><!-- navigation -->
                    </div><!-- main-menu-left -->
                    <div class="main-menu-right">
                        <div class="mobile-menu-button mobile-nav-toggler">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div><!-- mobile-menu-button -->
                        <?php if( $options->get('show_search_icon_v2') ):?>
                        <div class="search-box">
                            <a href="#" class="search-toggler">
                                <i class="flaticon-search-interface-symbol"></i>
                            </a><!-- search-toggler -->
                        </div><!-- search-box -->
                        <?php endif; ?>
                    </div><!-- main-menu-right -->
                </div><!-- main-menu-one-inner -->
            </div><!-- main-menu menu-two -->
        </div><!-- container -->
        <?php if( $options->get('show_btn_info_v2') ):?>
        <div class="topbar-one-button">
            <a href="<?php echo esc_url($options->get('btn_link_v2'));?>" class="btn btn-primary"><?php echo wp_kses($options->get('btn_title_v2'), true);?></a>
        </div><!-- topbar-one-button -->
        <?php endif; ?>
    </div><!-- topbar-one -->
    <?php endif; ?>
</header><!--header-->      
<div class="page-wrapper">
        