<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage TOWNGOV
 * @author     Udayraj
 * @version    1.0
 */

if ( class_exists( 'Towngov_Resizer' ) ) {
	$img_obj = new Towngov_Resizer();
} else {
	$img_obj = array();
}
$allowed_tags = wp_kses_allowed_html('post');
global $post;
?>
<div <?php post_class(); ?>>
	
    <div class="blog-classic-page">
		<?php if( has_post_thumbnail() ){?>
        <div class="news-details-box-image">
            <div class="news-details-box-image-inner">
                <div class="img-fluid"><?php the_post_thumbnail('full'); ?></div>
                <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>" class="news-details-box-date"><?php echo get_the_date('d'); ?> <?php echo get_the_date('M'); ?></a>
            </div><!-- news-details-box-image-inner -->
        </div><!-- news-details-box-image -->
        <?php };?>
        <div class="news-details-meta-box">
            <div class="news-details-meta-box-inner">
                <span class="author">
                    <?php esc_html_e('by', 'towngov'); ?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><?php the_author(); ?></a>
                </span><!-- author -->
                <span class="comment">
                    <a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><?php comments_number( wp_kses(__('0 Comments' , 'towngov'), true), wp_kses(__('01 Comment' , 'towngov'), true), wp_kses(__('0% Comments' , 'towngov'), true)); ?></a>
                </span><!-- comment -->
            </div><!-- news-details-meta-box-inner -->
        </div><!-- news-details-meta-box -->
        <div class="news-details-content-box">
            <h4><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
            <?php the_excerpt(); ?>
        </div><!-- /.news-details-content-box -->
    </div>

</div>