<?php
/**
 * Blog Post Main File.
 *
 * @package TOWNGOV
 * @author  Udayraj
 * @version 1.0
 */

get_header();
$data    = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8 col-xl-8';
$options = towngov_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
	?>
<?php if ( $data->get( 'enable_banner' ) ) : ?>
	<?php do_action( 'towngov_banner', $data );?>
<?php else:?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->

<?php endif;?>


<!-- Sidebar Page Container -->
<section class="news-details-section">
    <div class="container">
        <div class="row">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'towngov_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">            	
				<?php while ( have_posts() ) : the_post(); ?>
                <div class="thm-unit-test">
					<?php if( has_post_thumbnail() ){?>
                    <div class="news-details-box-image">
                        <div class="news-details-box-image-inner">
                            <div class="img-fluid"><?php the_post_thumbnail('full'); ?></div>
                            <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>" class="news-details-box-date"><?php echo get_the_date('d'); ?> <?php echo get_the_date('M'); ?></a>
                        </div><!-- news-details-box-image-inner -->
                    </div><!-- news-details-box-image -->
                    <?php };?>
                    <div class="news-details-meta-box">
                        <div class="news-details-meta-box-inner">
                            <span class="author">
                                <?php esc_html_e('by', 'towngov'); ?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><?php the_author(); ?></a>
                            </span><!-- author -->
                            <span class="comment">
                                <a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><?php comments_number( wp_kses(__('0 Comments' , 'towngov'), true), wp_kses(__('01 Comment' , 'towngov'), true), wp_kses(__('0% Comments' , 'towngov'), true)); ?></a>
                            </span>
                        </div><!-- news-details-meta-box-inner -->
                    </div><!-- news-details-meta-box -->
                    
                    <div class="news-details-content-box">
                        <div class="text"><?php the_content(); ?></div>
                        <div class="clearfix"></div>
                        <?php wp_link_pages(array('before'=>'<div class="paginate-links m-t30">'.esc_html__('Pages: ', 'towngov'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>
                    </div><!-- /.news-details-content-box -->
                    <?php if(function_exists('bunch_share_us_two') || has_tag()):?>
                    <div class="news-details-share-box">
                        <div class="news-details-inner">
                            <?php if(has_tag()){ ?>
                            <div class="news-details-list">
                                <div class="news-details-list-title">
                                    <h4><?php esc_html_e('Tags', 'towngov'); ?></h4>
                                </div><!-- news-details-list-title -->
                                <div class="news-details-list-button">
                                    <?php the_tags( '', '' ); ?>
                                </div><!-- news-details-list-button -->
                            </div><!--news-details-list-->
                            <?php } ?>
                            <?php if(function_exists('bunch_share_us_two')):?>
                            <div class="news-details-list">
                                <div class="news-details-socials">
                                    <?php echo wp_kses(bunch_share_us_two(get_the_id(),$post->post_name ), true);?>
                                </div><!-- news-details-socials -->
                            </div><!-- news-details-list -->
                            <?php endif;?>
                        </div><!-- news-details-inner -->
                    </div><!-- news-details-share-box -->
                    <?php endif;?>	
                    <?php if( $options->get( 'single_post_author_box' ) ):?>
                    <div class="news-details-author-box">
                        <div class="news-details-author-image">
                            <?php echo get_avatar(get_the_author_meta('ID'), 100); ?>
                        </div><!-- news-details-author-image -->
                        <div class="news-details-author-content">
                            <h4><?php the_author(); ?></h4>
                            <p><?php the_author_meta( 'description', get_the_author_meta('ID') ); ?></p>
                        </div><!-- news-details-author-content -->
                    </div><!--news-details-author-box -->
                    <?php endif;?>	
                    
                    <!-- Comments Area -->
                    <?php comments_template(); ?>
                
                </div>
				<?php endwhile; ?>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'towngov_sidebar', $data );
				}
			?>
        </div>
    </div>
</section> 
<!--End blog area--> 

<?php
}
get_footer();
