<?php get_header(); 
$data = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single-team' )->get(); 

$show_skills_area = get_post_meta(get_the_ID(), 'show_skills_area', true);
?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->
<?php 
	while( have_posts() ) : the_post(); 
	$towngov_team_meta = get_post_meta(get_the_ID(), 'towngov_meta_team', true );
?>

<section class="team-details-section">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-12 col-lg-6">
                <div class="team-details-image">
                    <div class="img-fluid"><?php the_post_thumbnail('towngov_550x583'); ?></div>
                    <div class="team-details-name"><?php echo wp_kses($towngov_team_meta['team_image_caption'], true ); ?></div>
                </div><!--team-details-image-->
            </div><!--col-12 col-lg-6-->
            <div class="col-12 col-lg-5">
                <div class="team-details-title-one">
                    <h2><?php the_title(); ?></h2>
                    <span><?php echo wp_kses($towngov_team_meta['team_designation'], true ); ?></span>
                </div><!--team-details-title-one-->
                <?php
					$icons = $towngov_team_meta['social_profile'];
					if ( ! empty( $icons ) ) :								
				?>
				<!-- Social Box -->
				<div class="team-details-socials">
					<?php foreach ( $icons as $h_icon ) {
	
						$icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); 
					?>
					<a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>"<?php endif;?>><i class="fa-brands <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a>
					<?php } ?>
				</div>
				<?php endif; ?>
                <div class="team-details-info">
                    <ul class="list-unstyled">
                        <li><?php echo wp_kses($towngov_team_meta['team_age_title'], true ); ?> <span><?php echo wp_kses($towngov_team_meta['team_age'], true ); ?></span></li>
                        <li><?php echo wp_kses($towngov_team_meta['team_email_title'], true ); ?> <span><a href="mailto:<?php echo esc_attr($towngov_team_meta['team_email']); ?>"><?php echo wp_kses($towngov_team_meta['team_email'], true ); ?></a></span></li>
                        <li><?php echo wp_kses($towngov_team_meta['team_phone_title'], true ); ?> <span><a href="tel:<?php echo esc_attr($towngov_team_meta['team_phone_no']); ?>"><?php echo wp_kses($towngov_team_meta['team_phone_no'], true ); ?></a></span></li>
                    </ul><!-- list-unstyled -->
                </div><!--team-details-info-->
                <div class="team-details-text">
                    <p><?php the_content();?></p>
                </div><!--team-details-text-->
                <?php if($towngov_team_meta['show_education_info']){ ?>
                <div class="team-details-list">
                    <h3><?php echo wp_kses($towngov_team_meta['education_title'], true ); ?></h3>
                    <div class="team-details-list-item">
                        <div class="row">
                            <?php 						
								foreach($towngov_team_meta['team_education'] as $key => $towngov_set):                    
								$towngov_team_meta = get_post_meta(get_the_ID(), 'towngov_meta_team', true );											
							?>
                            <div class="col-sm-12 col-lg-6 col-xl-6">
                                <div class="team-details-box">
                                    <div class="team-details-year"><?php echo wp_kses( $towngov_set['education_period'], true );?></div>
                                    <h4 class="team-details-title"><?php echo wp_kses( $towngov_set['education_degree'], true );?></h4>
                                    <p><?php echo wp_kses( $towngov_set['university'], true );?></p>
                                </div><!--team-details-box-->
                            </div><!--col-sm-6 col-lg-6 col-xl-6-->
                            <?php endforeach; ?>
                        </div><!-- row -->
                    </div><!--team-details-list-item-->
                </div><!--team-details-list-->
                <?php } ?>
            </div><!--col-12 col-lg-12-->
        </div><!-- row -->
    </div><!-- container -->
</section><!--team-details-section-->

<?php endwhile; ?>
<?php if($towngov_team_meta['show_biography_section']){ ?>
<section class="team-details-biography-section">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-12">
                <div class="team-details-biography-content">
                    <div class="team-details-title">
                        <h3><?php echo wp_kses($towngov_team_meta['team_biography_title'], true ); ?></h3>
                    </div>
                    <p><?php echo wp_kses($towngov_team_meta['team_biography_description'], true ); ?></p>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<!------ team-skills area ------->
<?php if($towngov_team_meta['show_skills_area']){ ?>
<section class="team-progress-section">
    <div class="container">
        <h3><?php echo wp_kses($towngov_team_meta['team_skills_title'], true ); ?></h3>
        <div class="row row-gutter-y-30">
            <?php 						
				foreach($towngov_team_meta['team_skills'] as $key => $towngov_set):                    
				$towngov_team_meta = get_post_meta(get_the_ID(), 'towngov_meta_team', true );											
			?>
            <div class="col-lg-6">
                <div class="team-progressbar-text"><?php echo wp_kses( $towngov_set['team_skills_title1'], true );?></div>
                <div class="team-progressbar">
                    <div class="team-progressbar-inner count-box-one" data-percentage="<?php echo wp_kses( $towngov_set['team_skills_counter_value'], true );?>">
                        <div class="team-progressbar-inner-text count-text-one"><?php echo wp_kses( $towngov_set['team_skills_counter_value'], true );?></div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php } ?>
<!------ team-estimate-form-section ------->
<?php if($towngov_team_meta['show_contact_me']){ ?>
<section class="team-details-contact" style="background-image:url('<?php echo wp_get_attachment_url($towngov_team_meta['team_form_image']['id'], true);?>')">
    <div class="container">
        <div class="row justify-content-md-center">
            <div class="align-self-center col-lg-8">
                <div class="section-title-box text-center">
                    <div class="section-tagline">
                        <?php echo wp_kses($towngov_team_meta['team_form_sub_title'], true ); ?>
                    </div>
                    <h2 class="section-title"><?php echo wp_kses($towngov_team_meta['team_form_title'], true ); ?></h2>
                </div>
            </div>
            <div class="align-self-center col-lg-8">
                <div class="contact-form-one contact-form-validated">
                    <div class="te-custom-form">
                        <?php echo do_shortcode( $towngov_team_meta['team_form_url'] );?>                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php get_footer(); ?>