<?php get_header(); 
	$data = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single-service' )->get(); 
	
	$layout = $data->get('layout');
    $sidebar = $data->get('sidebar');
    $layout = ($layout) ? $layout : 'right';
    $sidebar = ($sidebar) ? $sidebar : 'default-sidebar';
    if (is_active_sidebar($sidebar)) {
        $layout = 'right';
    } else {
        $layout = 'full';
    }
    $class = (!$layout || $layout == 'full') ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
    $options = towngov_WSH()->option();
    
    $allowed_tags = wp_kses_allowed_html('post');

?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->

<!--  Service details -->
<section class="service-details-section">
    <div class="container">
        <div class="row">
            <?php
            if ($data->get('layout') == 'left') {
                do_action('towngov_sidebar', $data);
            } ?>
			<?php 
				while( have_posts() ) : the_post();
				$towngov_service_meta = get_post_meta( get_the_ID(), 'towngov_meta_service', true );
			?>
			<div class="content-side <?php echo esc_attr( $class ); ?>">
				<?php if( has_post_thumbnail() ):?>
                <div class="service-details-image">
                    <div class="img-fluid"><?php the_post_thumbnail('towngov_1170x451'); ?></div>
                </div><!-- service-details-image -->
                <?php endif;?>
                <div class="service-details-content-box">
                	<?php the_content();?>
                </div>
                <h2 class="service-details-title"><?php 
                if($towngov_service_meta)
                {
                    echo wp_kses($towngov_service_meta['service_feature_list_title'], true );     
                }
                ?></h2>
                <?php 
                if($towngov_service_meta)
                {
					$features_list = $towngov_service_meta['service_feature_list'];
					if(!empty($features_list)){
					$features_list = explode("\n", ($features_list)); 
				?>
				<ul class="list-unstyled list-style-two">
					<?php foreach($features_list as $features): ?>
                    <li>
                    	<i class="fa-solid fa-circle-arrow-right"></i>
						<h5><?php echo wp_kses($features, true); ?></h5>
                    </li>
					<?php endforeach; ?>
				</ul>
				<?php }

                 ?>
                <?php if($towngov_service_meta['show_feature_box']){ ?>
                <div class="service-details-box-inner">
                    <div class="row g-0">
                        <?php 						
							foreach($towngov_service_meta['servce_features'] as $key => $towngov_set):                    
							$towngov_service_meta = get_post_meta(get_the_ID(), 'towngov_meta_service', true );											
						?>
                        <div class="col-lg-6">
                            <div class="service-details-box">
                                <div class="service-details-icon">
                                    <a href="<?php echo esc_url($towngov_set['service_feature_box_url']); ?>"><i class="<?php echo $towngov_set['feature_icon']; ?>"></i></a>
                                </div><!-- service-details-icon -->
                                <div class="service-details-content">
                                    <h4><a href="<?php echo esc_url($towngov_set['service_feature_box_url']); ?>"><?php echo wp_kses($towngov_set['service_feature_title'], true ); ?></a></h4>
                                    <p><?php echo wp_kses($towngov_set['service_feature_description'], true ); ?></p>
                                </div><!-- service-details-content -->
                            </div><!-- service-details-box -->
                        </div><!--col-lg-6-->
                        <?php endforeach; ?>
                    </div><!-- row g-0 -->
                </div><!-- service-details-box-inner -->
                <?php } ?>
                <p><?php echo wp_kses($towngov_service_meta['service_bottom_content'], true ); ?></p>
            <?php } ?>
			</div>
			<?php endwhile; ?>
                        
            <?php
            if ($data->get('layout') == 'right') {
                do_action('towngov_sidebar', $data);
            } ?>
                        
        </div><!-- /.row gutter-y-60 -->
    </div><!-- /.container -->
</section>
<!--  Service details end-->
<?php get_footer(); ?>