<?php get_header(); 
$data = \TOWNGOV\Includes\Classes\Common::instance()->data('single-project')->get(); 

$query_number = get_post_meta( get_the_id(), 'query_number', true );
$query_orderby = get_post_meta( get_the_id(), 'query_orderby', true );
$query_order = get_post_meta( get_the_id(), 'query_order', true );
$query_category = get_post_meta( get_the_id(), 'query_category', true );
$args = array(
	'post_type'      => 'project',
	'posts_per_page' => $query_number,
	'orderby'        => $query_orderby,
	'order'          => $query_order,
);

if( $query_category  ) $args['project_cat'] = $query_category;
$related_query = new \WP_Query( $args );

?>
<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->
<?php 
	while( have_posts() ) : the_post(); 
	$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
	$towngov_projects_meta = get_post_meta( get_the_ID(), 'towngov_meta_projects', true );
	$layout = $towngov_projects_meta['layout_style'];
?>

<!--
=====================================================
    Portfolio Details
=====================================================
-->
<!-- portfolio-details -->
<section class="portfolio-details">
    <div class="container">
        <div class="img-fluid"><?php the_post_thumbnail('towngov_1168x510'); ?></div>
        <?php if( $layout == 'two' ):?>
        	<div  class="portfolio-details-content-inner">
                <div class="row row-gutter-30">
                    <div class="col-lg-8">
                        <div class="portfolio-details-content  portfolio-details-content-list">
                            <div class="portfolio-details-content-title">
                                <h3><?php the_title();?></h3>
                            </div><!-- portfolio-details-content-title -->
                            <div class="portfolio-details-content-text">
                            	<?php the_content();?>
                            </div><!-- portfolio-details-content-text -->
                        </div><!-- portfolio-details-content-list -->
                    </div><!-- col-lg-8 -->
                    <div class="col-lg-4">
                        <div class="portfolio-details-info portfolio-details-item">
                            
                            <div class="portfolio-details-info-item portfolio-details-info-item-two">
                                <span><?php echo wp_kses($towngov_projects_meta['project_cat_title'], true ); ?></span>
                                <p class="lead"><?php echo implode( ', ', (array)$term_list );?></p>
                            </div><!-- portfolio-details-info-item-two -->
                            
                            <div class="portfolio-details-info-item portfolio-details-info-item-two">
                                <span><?php echo wp_kses($towngov_projects_meta['project_title'], true ); ?></span>
                    			<p class="lead"><?php echo wp_kses($towngov_projects_meta['project_name'], true ); ?></p>
                            </div><!-- portfolio-details-info-item-two -->
                            
                            <div class="portfolio-details-info-item portfolio-details-info-item-two">
                                <span><?php echo wp_kses($towngov_projects_meta['project_date_title'], true ); ?></span>
                    			<p class="lead"><?php echo wp_kses($towngov_projects_meta['project_date'], true ); ?></p>
                            </div><!-- portfolio-details-info-item-two -->
                            
                            <div class="portfolio-details-info-item portfolio-details-info-item-two">
                                <span><?php echo wp_kses($towngov_projects_meta['project_address_title'], true ); ?></span>
                    			<p class="lead"><?php echo wp_kses($towngov_projects_meta['project_address'], true ); ?></p>
                            </div><!-- portfolio-details-info-item-two -->
                            
                            <?php
								$icons = $towngov_projects_meta['social_profile2'];
								if ( ! empty( $icons ) ) :								
							?>
							<!-- Social Box -->
							<div class="portfolio-details-info-item portfolio-details-info-socials">
								<?php foreach ( $icons as $h_icon ) {
				
									$icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); 
								?>
								<a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>"<?php endif;?>><i class="fa-brands <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a>
								<?php } ?>
							</div>
							<?php endif; ?>
                            
                        </div><!-- portfolio-details-info -->
                    </div><!-- col-lg-4 -->
                </div><!-- row -->
            </div>
            
        <?php else:?>
            
            <div class="portfolio-details-info">
                <div class="portfolio-details-info-item">
                    <span><?php echo wp_kses($towngov_projects_meta['project_cat_title'], true ); ?></span>
                    <p><?php echo implode( ', ', (array)$term_list );?></p>
                </div><!-- portfolio-details-info-item -->
                <div class="portfolio-details-info-item">
                    <span><?php echo wp_kses($towngov_projects_meta['project_title'], true ); ?></span>
                    <p><?php echo wp_kses($towngov_projects_meta['project_name'], true ); ?></p>
                </div><!-- portfolio-details-info-item -->
                <div class="portfolio-details-info-item">
                    <span><?php echo wp_kses($towngov_projects_meta['project_date_title'], true ); ?></span>
                    <p><?php echo wp_kses($towngov_projects_meta['project_date'], true ); ?></p>
                </div><!-- portfolio-details-info-item -->
                <div class="portfolio-details-info-item">
                    <span><?php echo wp_kses($towngov_projects_meta['project_address_title'], true ); ?></span>
                    <p><?php echo wp_kses($towngov_projects_meta['project_address'], true ); ?></p>
                </div><!-- portfolio-details-info-item -->            
                <?php
                    $icons = $towngov_projects_meta['social_profile2'];
                    if ( ! empty( $icons ) ) :								
                ?>
                <!-- Social Box -->
                <div class="portfolio-details-info-item portfolio-details-info-socials">
                    <?php foreach ( $icons as $h_icon ) {
    
                        $icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); 
                    ?>
                    <a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>"<?php endif;?>><i class="fa-brands <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a>
                    <?php } ?>
                </div>
                <?php endif; ?>
            </div><!--/.portfolio-details-info-->
            <div class="portfolio-details-content">            
                <div class="portfolio-details-content-text">
                    <?php the_content();?>
                </div><!-- portfolio-details-content-text -->
            </div><!-- portfolio-details-content -->
        
        <?php endif;?>
        
    </div><!-- container -->
</section><!-- portfolio-details -->


<?php if((get_previous_post()) || (get_next_post())): ?>
<section class="portfolio-details-nav">
    <div class="container">
        <div class="portfolio-details-nav-inner">
            <?php global $post; $prev_post = get_previous_post();
				if (!empty($prev_post)):
			?>
            <div class="portfolio-details-nav-item prev-item">
                <div class="portfolio-details-nav-icon">
                    <a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>"><i class="fa-solid fa-arrow-left-long"></i></a>
                </div><!-- portfolio-details-nav-icon -->
                <div class="portfolio-details-nav-content">
                    <span><?php esc_html_e('Previous Post', 'towngov');?></span>
                    <h5><a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>"><?php echo wp_kses_post($prev_post->post_title); ?></a></h5>
                </div><!-- portfolio-details-nav-content -->
            </div><!-- portfolio-details-nav-item prev-item -->
            <?php endif; ?>
            
			<?php global $post; $next_post = get_next_post();
				if (!empty($next_post)):
			?>
            <div class="portfolio-details-nav-item next-item">
                <div class="portfolio-details-nav-icon">
                    <a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><i class="fa-solid fa-arrow-right-long"></i></a>
                </div><!-- portfolio-details-nav-icon -->
                <div class="portfolio-details-nav-content">
                    <span><?php esc_html_e('Next Post', 'towngov');?></span>
                    <h5><a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><?php echo wp_kses_post($next_post->post_title); ?></a></h5>
                </div><!-- portfolio-details-nav-content -->
            </div><!-- portfolio-details-nav-item next-item -->
            <?php endif; ?>
        </div><!-- portfolio-details-nav-inner -->
    </div><!-- container -->
</section><!-- portfolio-details-nav -->
<?php endif; ?>
<?php endwhile; ?>

<!------ project-client-section ------->
<?php if($towngov_projects_meta['show_recent_project']){ ?>
<section class="portfolio-section">
    <div class="section-title-box text-center">
        <div class="section-tagline"><?php echo wp_kses($towngov_projects_meta['recent_project_sub_title'], true ); ?></div>
        <h2 class="section-title"><?php echo wp_kses($towngov_projects_meta['recent_project_title'], true ); ?></h2>
    </div><!-- section-title-box -->
    <div class="portfolio-content conatainer-fluid">
        <div class="portfolio-carousel-one owl-carousel owl-theme">
            <?php 
				while ( $related_query->have_posts() ) : $related_query->the_post(); 
				$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
				$towngov_projects_meta = get_post_meta( get_the_ID(), 'towngov_meta_projects', true );
			?>
            <div class="item">
                <div class="portfolio-card">
                    <div class="img-fluid"><?php the_post_thumbnail('towngov_555x525'); ?></div>
                    <div class="portfolio-card-meta">
                        <div class="portfolio-card-text"><?php echo implode( ', ', (array)$term_list );?></div>
                        <div class="portfolio-card-title"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></div>
                    </div><!-- portfolio-card-meta -->
                </div><!--portfolio-card-->
            </div><!-- item -->
            <?php endwhile; ?>
        </div><!--portfolio-carousel-->
    </div><!--portfolio-content-->	
</section><!--portfolio-section-->
<?php } ?>
<?php get_footer(); ?>