<?php get_header(); 
	$data = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single-documentations' )->get(); 
	
	$layout = $data->get('layout');
    $sidebar = $data->get('sidebar');
    $layout = ($layout) ? $layout : 'right';
    $sidebar = ($sidebar) ? $sidebar : 'default-sidebar';
    if (is_active_sidebar($sidebar)) {
        $layout = 'right';
    } else {
        $layout = 'full';
    }
    $class = (!$layout || $layout == 'full') ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
    $options = towngov_WSH()->option();
    
    $allowed_tags = wp_kses_allowed_html('post');

?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->

<!--  Service details -->
<section class="department-details-section">
    <div class="container">
        <div class="row">
            <?php
            if ($data->get('layout') == 'left') {
                do_action('towngov_sidebar', $data);
            } ?>
			<?php 
				while( have_posts() ) : the_post();
				$towngov_doc_meta = get_post_meta( get_the_ID(), 'towngov_meta_documentation', true );
			?>
			<div class="content-side <?php echo esc_attr( $class ); ?>">
				<?php if( has_post_thumbnail() ):?>
                <div class="department-details-imgbox mb-5">
                    <?php the_post_thumbnail('towngov_1170x451'); ?>
                </div><!-- service-details-image -->
                <?php endif;?>
                <div class="department-details-box">
                	<?php the_content();?>
                </div>
                
                <?php if($towngov_doc_meta['show_doc_box']){ ?>
                <div class="document-details-inner">
                	<h3><?php echo wp_kses( $towngov_doc_meta['doc_title'], true );?></h3>
                    
                    <?php 						
						foreach($towngov_doc_meta['doc_features'] as $key => $towngov_set):                    
					?>
                    
                    <div class="document-details">
                        <div class="document-details-list">
                            <div class="document-details-icon">
                            	<i class="<?php echo $towngov_set['doc_feature_icon']; ?>"></i>
                            </div>
                            <div class="document-details-content">
                                <h5><a href="<?php echo esc_url($towngov_set['doc_feature_box_url']); ?>"><?php echo wp_kses($towngov_set['doc_feature_title'], true ); ?></a></h5>
                                <p><?php echo wp_kses($towngov_set['doc_feature_description'], true ); ?></p>
                            </div>
                        </div><!-- document-details-list -->
                        <div class="document-details-button">
                        	<a href="<?php echo esc_url($towngov_set['doc_feature_box_url']); ?>" title="download"><i class="fa-solid fa-arrow-down"></i></a>
                        </div>	
                    </div><!-- document-details -->
                    
					<?php endforeach; ?>
                    
                </div><!-- document-details-inner -->
                <?php } ?>
                
                
			</div>
			<?php endwhile; ?>
                        
            <?php
            if ($data->get('layout') == 'right') {
                do_action('towngov_sidebar', $data);
            } ?>
                        
        </div><!-- /.row gutter-y-60 -->
    </div><!-- /.container -->
</section>
<!--  Service details end-->
<?php get_footer(); ?>