<?php get_header(); 
	$data = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single-department' )->get(); 
	
	$layout = $data->get('layout');
    $sidebar = $data->get('sidebar');
    $layout = ($layout) ? $layout : 'right';
    $sidebar = ($sidebar) ? $sidebar : 'default-sidebar';
    if (is_active_sidebar($sidebar)) {
        $layout = 'right';
    } else {
        $layout = 'full';
    }
    $class = (!$layout || $layout == 'full') ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
    $options = towngov_WSH()->option();
	
	$allowed_tags = wp_kses_allowed_html('post');

?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->

<!--  Departments details -->
<section class="department-details-section">
    <div class="container">
        <div class="row">
            <!-- sidebar area -->
			<?php if( $data->get('layout') == 'left' ): ?>
            <div class="col-12 col-lg-4 col-xl-4">
                <div class="sidebar department-sidebar">
                	<?php dynamic_sidebar( $sidebar ); ?>
                </div>
            </div>
			<?php endif; ?>
            
			<?php 
				while( have_posts() ) : the_post();
				$towngov_department_meta = get_post_meta( get_the_ID(), 'towngov_meta_department', true );
			?>
			<div class="content-side <?php echo esc_attr( $class ); ?>">
				<?php if( has_post_thumbnail() ):?>
                <div class="department-details-imgbox">
                    <div class="img-fluid"><?php the_post_thumbnail('towngov_1170x451'); ?></div>
                    
                    <div class="department-details-img-icon">
                        <i class="<?php echo $towngov_department_meta['department_icon']; ?>"></i>
                    </div><!-- department-details-img-icon -->
                </div><!-- department-details-imgbox -->
				<?php endif;?>
                <?php the_content();?>
                <?php if($towngov_department_meta['show_feature_box2']){ ?>
                <div class="department-details-law-box">
                    <h4><?php echo wp_kses($towngov_department_meta['department_law_title'], true ); ?></h4>
                    <p><?php echo wp_kses($towngov_department_meta['department_law_description'], true ); ?></p>
                </div><!-- department-details-law-box -->
                <div class="department-details-skill-box">
                    <div class="row">
                        <?php 						
							foreach($towngov_department_meta['department_features'] as $key => $towngov_set):                    
							$towngov_department_meta = get_post_meta(get_the_ID(), 'towngov_meta_department', true );											
						?>
                        <div class="col-12 col-lg-6">
                            <div class="service-one-card">
                                <div class="service-one-icon">
                                    <a href="<?php echo esc_url($towngov_set['feature_box_url']); ?>"><i class="<?php echo $towngov_set['feature_icon2']; ?>"></i></a>
                                </div><!-- service-one-icon -->
                                <div class="service-one-card-content">
                                    <h4><a href="<?php echo esc_url($towngov_set['feature_box_url']); ?>"><?php echo wp_kses($towngov_set['feature_box_title'], true ); ?></a></h4>
                                    <p><?php echo wp_kses($towngov_set['feature_box_description'], true ); ?></p>
                                </div><!-- service-one-card-content -->
                            </div><!--service-one-card-->
                        </div><!--col-12 col-lg-4-->
                        <?php endforeach; ?>
                    </div><!-- row -->
                </div><!-- service-one-inner -->
                <?php } ?>
                <?php if($towngov_department_meta['show_faqs_section']){ ?>
                <div class="accordian-box">
                    <?php 						
						$i = 1;
						foreach($towngov_department_meta['department_faq'] as $key => $towngov_set):                    
						$towngov_department_meta = get_post_meta(get_the_ID(), 'towngov_meta_department', true );											
					?>
                    <div class="accordian-box-item <?php if($i == 2 ) echo 'active'; ?>">
                        <div class="accordian-title">
                            <h5><?php echo wp_kses($towngov_set['faqs_section_title'], true ); ?></h5>
                            <i class="fa-solid fa-angle-right"></i>
                        </div><!-- accordian-title -->
                        <div class="accordian-content">
                            <p><?php echo wp_kses($towngov_set['faqs_section_description'], true ); ?></p>
                        </div><!-- accordian-content -->
                    </div><!-- accordian-box-item -->
                    <?php $i++; endforeach; ?>
                </div><!-- accordian-box -->
                <?php } ?>                
			</div>
			<?php endwhile; ?>
                        
            <?php if( $data->get('layout') == 'right' ): ?>
            <div class="col-12 col-lg-4 col-xl-4">
                <div class="sidebar department-sidebar">
                	<?php dynamic_sidebar( $sidebar ); ?>
                </div>
            </div>
			<?php endif; ?>
                        
        </div><!-- /.row gutter-y-60 -->
    </div><!-- /.container -->
</section>
<!--  Service details end-->
<?php get_footer(); ?>