<?php
/**
 * Blog Post Main File.
 *
 * @package TOWNGOV
 * @author  Udayraj
 * @version 1.0
 */

get_header();
$data    = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8 col-xl-8';
$options = towngov_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
	?>
<?php if ( $data->get( 'enable_banner' ) ) : ?>
	<?php do_action( 'towngov_banner', $data );?>
<?php else:?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->

<?php endif;?>


<!-- Sidebar Page Container -->
<section class="causes-details-section">
    <div class="container">
        <div class="row">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'towngov_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">            	
				<?php 
					while ( have_posts() ) : the_post(); 
					$campaign = charitable_get_current_campaign(); 
				?>
                <div class="thm-unit-test">
					<?php if( has_post_thumbnail() ){?>
                    <div class="causes-details-box-img">
                        <?php the_post_thumbnail('full', array( 'class' => 'img-fluid' )); ?>
                    </div>
                    <?php };?>
                    
                    <div class="causes-details-content-box">
                    
                    	<div class="causes-details-funding">
                            <div class="causes-details-progressbar">
                                <div class="causes-details-progressbar-inner count-box te-count-box" data-percentage="<?php echo esc_attr($campaign->get_percent_donated_raw());?>%">
                                    <div class="causes-details-progressbar-text count-text"></div>
                                </div><!-- causes-details-progressbar-inner count-box -->
                            </div><!-- causes-details-progressbar -->
                            
                            <?php if ( $campaign->has_goal() ){ ?>
                            <div class="causes-card-funding-list">
                                <?php echo wp_kses( $campaign->get_donation_summary(), true ); ?>
                            </div>
                            <?php } ?>
                        </div><!-- causes-details-funding -->
                    	
                        <div class="text"><?php the_content(); ?></div>
                        
                    </div>
                
                </div>
				<?php endwhile; ?>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'towngov_sidebar', $data );
				}
			?>
        </div>
    </div>
</section> 
<!--End blog area--> 

<?php
}
get_footer();
