<?php

/**

 * Default Template Main File.

 *

 * @package TOWNGOV

 * @author  Udayraj

 * @version 1.0

 */



get_header();

$data  = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single' )->get();

$layout = $data->get( 'layout' );

$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'blog-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}

$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8 col-xl-8';

?>



<?php if ( $data->get( 'enable_banner' ) ) : ?>

	<?php do_action( 'towngov_banner', $data );?>

<?php else:?>



<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">

    <div class="container">

        <div class="page-breadcrumbs">

            <ul class="list-unstyled">

                <?php echo towngov_the_breadcrumb(); ?>

            </ul><!-- list-unstyled -->

        </div><!-- page-breadcrumbs -->

        <div class="page-banner-title">

            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>

        </div><!-- page-banner-title -->

    </div><!-- container -->			

</section><!--page-banner-->



<?php endif;?>



<!-- Sidebar Page Container -->

<section class="news-details-section">

    <div class="container">

        <div class="row">		

        	<?php

				if ( $data->get( 'layout' ) == 'left' ) {

					do_action( 'towngov_sidebar', $data );

				}

            ?>

            <div class="content-side <?php echo esc_attr( $class ); ?>">

                <div class="blog-details"> 

                    <div class="thm-unit-test">

                        

                        <?php while ( have_posts() ): the_post(); ?>

                            <div class="blog-details__content thm-unit-single">

								<div class="text">

									<?php the_content(); ?>

                                </div>

                            </div>

                        <?php endwhile; ?>

                        

                        <div class="clearfix"></div>

                        <?php

                        $defaults = array(

                            'before' => '<div class="paginate-links">' . esc_html__( 'Pages:', 'towngov' ),

                            'after'  => '</div>',

        

                        );

                        wp_link_pages( $defaults );

                        ?>

                        <?php comments_template() ?>

                    </div>

                </div>

            </div>

            <?php

            if ( $layout == 'right' ) {

                $data->set('sidebar', 'default-sidebar');

                do_action( 'towngov_sidebar', $data );

            }

            ?>        

        </div>

	</div>

</section><!-- blog section with pagination -->

<?php get_footer(); ?>

