<?php

return array(

	'title'      => esc_html__( 'Logo Setting', 'towngov' ),

	'id'         => 'logo_setting',

	'desc'       => '',

	'subsection' => false,

	'fields'     => array(

		array(

			'id'       => 'image_favicon',

			'type'     => 'media',

			'url'      => true,

			'title'    => esc_html__( 'Favicon', 'towngov' ),

			'subtitle' => esc_html__( 'Insert site favicon image', 'towngov' ),

			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/favicon/favicon.Icon' ),

		),

		array(

            'id' => 'normal_logo_show',

            'type' => 'switcher',

            'title' => esc_html__('Enable Light Color Logo', 'towngov'),

            'default' => true,

        ),

		array(

			'id'       => 'light_image_logo',

			'type'     => 'media',

			'url'      => true,

			'title'    => esc_html__( 'Light Color Logo', 'towngov' ),

			'subtitle' => esc_html__( 'Insert site Light Color Logo image', 'towngov' ),

			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-light.png' ),

			'dependency' => array( 'normal_logo_show', '==', true ),

		),

		array(

			'id'       => 'light_logo_dimension',

			'type'     => 'dimensions',

			'title'    => esc_html__( 'Light Color Logo Dimentions', 'towngov' ),

			'subtitle' => esc_html__( 'Select Light Color Logo Dimentions', 'towngov' ),

			'units'    => array( 'em', 'px', '%' ),

			'default'  => array( 'Width' => '', 'Height' => '' ),

			'dependency' => array( 'normal_logo_show', '==', true ),

		),

		array(

            'id' => 'normal_logo_show2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Dark Color Logo', 'towngov'),

            'default' => true,

        ),

		array(

			'id'       => 'dark_image_logo',

			'type'     => 'media',

			'url'      => true,

			'title'    => esc_html__( 'Dark Color Logo', 'towngov' ),

			'subtitle' => esc_html__( 'Insert site Dark Color logo image', 'towngov' ),

			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-dark.png' ),

			'dependency' => array( 'normal_logo_show2', '==', true ),

		),

		array(

			'id'       => 'dark_logo_dimension',

			'type'     => 'dimensions',

			'title'    => esc_html__( 'Dark Color Logo Dimentions', 'towngov' ),

			'subtitle' => esc_html__( 'Select Dark Color Logo Dimentions', 'towngov' ),

			'units'    => array( 'em', 'px', '%' ),

			'default'  => array( 'Width' => '', 'Height' => '' ),

			'dependency' => array( 'normal_logo_show2', '==', true ),

		),

	),

);

