<?php

return array(

	'title'      => esc_html__( 'Header Setting', 'towngov' ),

	'id'         => 'headers_setting',

	'desc'       => '',

	'subsection' => false,

	'fields'     => array(

		array(

			'id'      => 'header_source_type',

			'type'    => 'button_set',

			'title'   => esc_html__( 'Header Source Type', 'towngov' ),

			'options' => array(

				'd' => esc_html__( 'Default', 'towngov' ),

				'e' => esc_html__( 'Elementor', 'towngov' ),

			),

			'default' => 'd',

		),

		array(

			'id'       => 'header_elementor_template',

			'type'     => 'select',

			'title'    => __( 'Template', 'towngov' ),

			'options'     => 'posts',

			'query_args'     => [

				'post_type' => [ 'elementor_library' ],

				'posts_per_page'	=> -1

			],

			'chosen'	=> true,

			'ajax'	=> true,

			'settings'	=> array(

				'min_length'	=> 1,

			),

			'dependency' => [ 'header_source_type', '==', 'e' ],

		),

		

		array(

		    'id'       => 'header_style_settings',

		    'type'     => 'image_select',

		    'title'    => esc_html__( 'Choose Header Styles', 'towngov' ),

		    'subtitle' => esc_html__( 'Choose Header Styles', 'towngov' ),

		    'options'  => array(

			    'header_v1'  => get_template_directory_uri() . '/assets/images/redux/header/header1.png',

			    'header_v2'  => get_template_directory_uri() . '/assets/images/redux/header/header2.png',

			),

			'dependency' => array( 'header_source_type', '==', 'd' ),

			'default' => 'header_v1',

	    ),

		

		/***********************************************************************

								Header Version 1 Start

		************************************************************************/		

		array(

			'id'       => 'header_v1_settings_section_start',

			'type'     => 'heading',

			'indent'      => true,

			'content'    => esc_html__( 'Header Style One Settings', 'towngov' ),

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Topbar Info

		array(

            'id' => 'show_topbar',

            'type' => 'switcher',

            'title' => esc_html__('Enable Header Topbar', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		//Social Media

		array(

			'id'       => 'show_social_media_v1',

			'type'     => 'switcher',

			'title'    => esc_html__( 'Enable Social Media', 'towngov' ),

			'desc'     => esc_html__( 'Enable/Disable Social Media.', 'towngov' ),

			'default'  => '',

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		array(

			'id'    => 'social_media_v1',

			'type'  => 'repeater',

			'title' => esc_html__( 'Social Media', 'towngov' ),

			'fields'	=> array(

				array(

					'id'       => 'url',

					'type'     => 'text',

					'title'    => esc_html__( 'URL', 'towngov' ),

					'desc'     => esc_html__( 'Enter the URL of social Profile', 'towngov' ),

				),

				array(

					'id'       => 'icon',

					'type'     => 'icon',

					'title'    => esc_html__( 'Icon', 'towngov' ),

					'desc'     => esc_html__( 'Choose the icon', 'towngov' ),

				),

				array(

					'id'       => 'color',

					'type'     => 'color',

					'title'    => esc_html__( 'Color', 'towngov' ),

					'desc'     => esc_html__( 'Choose the color', 'towngov' ),

				),

				array(

					'id'       => 'background',

					'type'     => 'color',

					'title'    => esc_html__( 'Background Color', 'towngov' ),

					'desc'     => esc_html__( 'Choose the background color', 'towngov' ),

				),

			),

			'dependency' => array(

				array( 'show_social_media_v1', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Email Address

		array(

            'id' => 'show_email_address',

            'type' => 'switcher',

            'title' => esc_html__('Enable Email Address', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'email_address_v1',

			'type'     => 'text',

			'title'    => esc_html__( 'Email Address', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Email Address', 'towngov' ),

			'dependency' => array(

				array( 'show_email_address', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Working Hours

		array(

            'id' => 'show_working_hours_v1',

            'type' => 'switcher',

            'title' => esc_html__('Enable Working Hours', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'working_hours_v1',

			'type'     => 'text',

			'title'    => esc_html__( 'Working Hours', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Working Hours', 'towngov' ),

			'dependency' => array(

				array( 'show_working_hours_v1', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Topbar Menu

		array(

            'id' => 'show_top_menu_v1',

            'type' => 'switcher',

            'title' => esc_html__('Enable Topbar Menu', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),				

		//Search Icon

		array(

            'id' => 'show_search_icon_v1',

            'type' => 'switcher',

            'title' => esc_html__('Enable Search Icon', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		//Button Info

		array(

            'id' => 'show_btn_info_v1',

            'type' => 'switcher',

            'title' => esc_html__('Enable Get A Quote Button', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'btn_title_v1',

			'type'     => 'text',

			'title'    => esc_html__( 'Button Title', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Button Title', 'towngov' ),

			'dependency' => array(

				array( 'show_btn_info_v1', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		array(

			'id'       => 'btn_link_v1',

			'type'     => 'text',

			'title'    => esc_html__( 'Button Link', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Button Link', 'towngov' ),

			'dependency' => array(

				array( 'show_btn_info_v1', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),		

		//Phone Number

		array(

            'id' => 'show_phone_no',

            'type' => 'switcher',

            'title' => esc_html__('Enable Phone Number', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'phone_no_v1',

			'type'     => 'text',

			'title'    => esc_html__( 'Phone Number', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Phone Number', 'towngov' ),

			'dependency' => array(

				array( 'show_phone_no', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Address

		array(

            'id' => 'show_address',

            'type' => 'switcher',

            'title' => esc_html__('Enable Address', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v1' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'address_v1',

			'type'     => 'text',

			'title'    => esc_html__( 'Address', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Address', 'towngov' ),

			'dependency' => array(

				array( 'show_address', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		/***********************************************************************

								Header Version 2 Start

		************************************************************************/

		array(

			'id'       => 'header_v2_settings_section_start',

			'type'     => 'heading',

			'indent'      => true,

			'content'    => esc_html__( 'Header Style Two Settings', 'towngov' ),

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

			

		),

		//Topbar Info

		array(

            'id' => 'show_topbar2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Header Topbar', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		//Social Media

		array(

			'id'       => 'show_social_media_v2',

			'type'     => 'switcher',

			'title'    => esc_html__( 'Enable Social Media', 'towngov' ),

			'desc'     => esc_html__( 'Enable/Disable Social Media.', 'towngov' ),

			'default'  => '',

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		array(

			'id'    => 'social_media_v2',

			'type'  => 'repeater',

			'title' => esc_html__( 'Social Media', 'towngov' ),

			'fields'	=> array(

				array(

					'id'       => 'url',

					'type'     => 'text',

					'title'    => esc_html__( 'URL', 'towngov' ),

					'desc'     => esc_html__( 'Enter the URL of social Profile', 'towngov' ),

				),

				array(

					'id'       => 'icon',

					'type'     => 'icon',

					'title'    => esc_html__( 'Icon', 'towngov' ),

					'desc'     => esc_html__( 'Choose the icon', 'towngov' ),

				),

				array(

					'id'       => 'color',

					'type'     => 'color',

					'title'    => esc_html__( 'Color', 'towngov' ),

					'desc'     => esc_html__( 'Choose the color', 'towngov' ),

				),

				array(

					'id'       => 'background',

					'type'     => 'color',

					'title'    => esc_html__( 'Background Color', 'towngov' ),

					'desc'     => esc_html__( 'Choose the background color', 'towngov' ),

				),

			),

			'dependency' => array(

				array( 'show_social_media_v2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Email Address

		array(

            'id' => 'show_email_address2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Email Address', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'email_address_v2',

			'type'     => 'text',

			'title'    => esc_html__( 'Email Address', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Email Address', 'towngov' ),

			'dependency' => array(

				array( 'show_email_address2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Working Hours

		array(

            'id' => 'show_working_hours_v2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Working Hours', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'working_hours_v2',

			'type'     => 'text',

			'title'    => esc_html__( 'Working Hours', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Working Hours', 'towngov' ),

			'dependency' => array(

				array( 'show_working_hours_v2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Topbar Menu

		array(

            'id' => 'show_top_menu_v2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Topbar Menu', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),				

		//Search Icon

		array(

            'id' => 'show_search_icon_v2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Search Icon', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		//Button Info

		array(

            'id' => 'show_btn_info_v2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Get A Quote Button', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'btn_title_v2',

			'type'     => 'text',

			'title'    => esc_html__( 'Button Title', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Button Title', 'towngov' ),

			'dependency' => array(

				array( 'show_btn_info_v2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		array(

			'id'       => 'btn_link_v2',

			'type'     => 'text',

			'title'    => esc_html__( 'Button Link', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Button Link', 'towngov' ),

			'dependency' => array(

				array( 'show_btn_info_v2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),		

		//Phone Number

		array(

            'id' => 'show_phone_no2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Phone Number', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'phone_no_v2',

			'type'     => 'text',

			'title'    => esc_html__( 'Phone Number', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Phone Number', 'towngov' ),

			'dependency' => array(

				array( 'show_phone_no2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),

		//Address

		array(

            'id' => 'show_address2',

            'type' => 'switcher',

            'title' => esc_html__('Enable Address', 'towngov'),

            'default' => false,

			'dependency' => array(

				array( 'header_style_settings', '==', 'header_v2' ),

				array( 'header_source_type', '==', 'd' )

			),

        ),

		array(

			'id'       => 'address_v2',

			'type'     => 'text',

			'title'    => esc_html__( 'Address', 'towngov' ),

			'desc'     => esc_html__( 'Enter The Address', 'towngov' ),

			'dependency' => array(

				array( 'show_address2', '==', true ),

				array( 'header_source_type', '==', 'd' )

			),

		),		



	),

);

