<?php
$styles = [];
foreach(range(1, 28) as $val) {
    $styles[$val] = sprintf(esc_html__('Style %s', 'towngov'), $val);
}
return  array(
    'title'      => esc_html__( 'General Setting', 'towngov' ),
    'id'         => 'general_setting',
    'desc'       => '',
    'icon'       => 'el el-wrench',
    'fields'     => array(
        array(
            'id' => 'theme_preloader',
            'type' => 'switcher',
            'title' => esc_html__('Enable Preloader', 'towngov'),
            'default' => false,
        ),
//Primary Color
            array(
                'type'      => 'heading',
                'title'     => esc_html__('Base Color Settings','towngov'),
            ),
            array(
                'id'        => 'base_colors',
                'title'     => esc_html__('Select Base Colors','towngov'),
                'type'      => 'color_group',
                'options'   => array(
                    'primary_color'             => esc_html__('Primary Color','towngov'),
                    'secondary_color'           => esc_html__('Secondary Color','towngov'),
                    'text_color'                => esc_html__('Text Color','towngov'),
                    'black_color'               => esc_html__('Black Color','towngov'),
                    'dark_black_color'          => esc_html__('Dark Black Color','towngov'),
                    'gray_color'                => esc_html__('Gray Color','towngov'),
                    'light_bg_color'            => esc_html__('Light Bg Color','towngov'),
                    'border_color'              => esc_html__('Border Color','towngov'),
                ),
                'default'   => array(
                    'primary_color'             => '#2dcd7c',
                    'secondary_color'           => '#9cb7bd',
                    'text_color'                => '#838e91',
                    'black_color'               => '#003b49',
                    'dark_black_color'          => '#01313c',
                    'gray_color'                => '#838e91',
                    'light_bg_color'            => '#f3f6f7',
                    'border_color'              => '#e1e8ea',
                ),
            ),

    //Header Menu Color
//Primary Color
            array(
                'type'      => 'heading',
                'title'     => esc_html__('Menu Color Settings','towngov'),
            ),            
            array(
                'id'        => 'header_menu_colors',
                'title'     => esc_html__('Menu Color','towngov'),
                'type'      => 'color_group',
                'options'   => array(
                    'header_menu_link_color'            => esc_html__('Menu Text Color','towngov'),
                    'header_menu_link_color_hover'  => esc_html__('Text Link Hover/Active Color','towngov'),
                    'header_menu_line_color'            => esc_html__('Line Color','towngov'),
                ),
                'default'   => array(
                    'header_menu_link_color'        => '#838e91',
                    'header_menu_link_color_hover'  => '#003b49',
                    'header_menu_line_color'    => '#2dcd7c'
                )
            ),  

            array(
                'id'        => 'header_submenu_colors',
                'title'     => esc_html__('Submenu Color','towngov'),
                'type'      => 'color_group',
                'options'   => array(
                    'header_submenu_bg_color'           => esc_html__('Submenu BG Color','towngov'),
                    'header_submenu_link_color'         => esc_html__('Submenu Text Color','towngov'),
                    'header_submenu_bg_color_hover'     => esc_html__('Submenu Hover BG','towngov'),
                    'header_submenu_link_color_hover'   => esc_html__('Submenu Hover/Active Text Color','towngov'),
                ),
                'default'   => array(
                    'header_submenu_link_color'         => '#838e91',
                    'header_submenu_link_color_hover'   => '#ffffff',
                    'header_submenu_bg_color'           => '#ffffff',
                    'header_submenu_bg_color_hover'     => '#2dcd7c'
                )
            ),      

    ),
);
