<?php



return array(

	'title'      => esc_html__( 'Footer Setting', 'towngov' ),

	'id'         => 'footer_setting',

	'desc'       => '',

	'subsection' => false,

	'fields'     => array(

		array(

			'id'      => 'footer_source_type',

			'type'    => 'button_set',

			'title'   => esc_html__( 'Footer Source Type', 'towngov' ),

			'options' => array(

				'd' => esc_html__( 'Default', 'towngov' ),

				'e' => esc_html__( 'Elementor', 'towngov' ),

			),

			'default' => 'd',

		),

		array(

			'id'       => 'footer_elementor_template',

			'type'     => 'select',

			'title'    => __( 'Template', 'towngov' ),

			'options'     => 'posts',

			'query_args'     => [

				'post_type' => [ 'elementor_library' ],

				'posts_per_page'	=> -1

			],

			'dependency' => [ 'footer_source_type', '==', 'e' ],

		),

		array(

		    'id'       => 'footer_style_settings',

		    'type'     => 'image_select',

		    'title'    => esc_html__( 'Choose Footer Styles', 'towngov' ),

		    'subtitle' => esc_html__( 'Choose Footer Styles', 'towngov' ),

		    'options'  => array(

			    'footer_v1'  => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',

				'footer_v2'  => get_template_directory_uri() . '/assets/images/redux/footer/footer2.png',

			),

			'dependency' => array( 'footer_source_type', '==', 'd' ),

			'default' => 'footer_v1',

	    ),

		

		

		/***********************************************************************

								Footer Version 1 Start

		************************************************************************/

		array(

			'id'       => 'footer_v1_settings_section_start',

			'type'     => 'heading',

			'indent'      => true,

			'content'    => esc_html__( 'Footer Style One Settings', 'towngov' ),

			'dependency' => array(

				array( 'footer_style_settings', '==', 'footer_v1' ),

				array( 'footer_source_type', '==', 'd' )

			),

		),

		array(

			'id'       => 'footer_bg_img_v1',

			'type'     => 'media',

			'url'      => true,

			'title'    => esc_html__( 'Footer BG Image', 'towngov' ),

			'subtitle' => esc_html__( 'Insert Footer BG Image', 'towngov' ),

			'dependency' => array(

				array( 'footer_style_settings', '==', 'footer_v1' ),

				array( 'footer_source_type', '==', 'd' )

			),

		),

		//Copy Rights Text

		array(

			'id'      => 'copyright_text1',

			'type'    => 'textarea',

			'title'   => __( 'Copyright Text', 'towngov' ),

			'desc'    => esc_html__( 'Enter the Copyright Details Here,  shortcode [thisyear]  for current year', 'towngov' ),

			'dependency' => array(

				array( 'footer_style_settings', '==', 'footer_v1' ),

				array( 'footer_source_type', '==', 'd' )

			),

		),

		

		

	),

);

