<?php







return array(



	'title'      => esc_html__( 'Archive Page Settings', 'towngov' ),



	'id'         => 'archive_setting',



	'desc'       => '',



	'subsection' => true,



	'fields'     => array(



		array(



			'id'      => 'archive_source_type',



			'type'    => 'button_set',



			'title'   => esc_html__( 'Archive Source Type', 'towngov' ),



			'options' => array(



				'd' => esc_html__( 'Default', 'towngov' ),



				'e' => esc_html__( 'Elementor', 'towngov' ),



			),



			'default' => 'd',



		),



		array(



			'id'       => 'archive_elementor_template',



			'type'     => 'select',



			'title'    => __( 'Template', 'towngov' ),



			'options'     => 'posts',



			'query_args'     => [



				'post_type' => [ 'elementor_library' ],



				'posts_per_page'=> -1,



			],



			'dependency' => [ 'archive_source_type', '==', 'e' ],



		),







		array(



			'id'       => 'archive_default_st',



			'type'     => 'heading',



			'content'    => esc_html__( 'Archive Default', 'towngov' ),



			'indent'   => true,



			'dependency' => [ 'archive_source_type', '==', 'd' ],



		),



		array(



			'id'      => 'archive_page_banner',



			'type'    => 'switcher',



			'title'   => esc_html__( 'Show Banner', 'towngov' ),



			'desc'    => esc_html__( 'Enable to show banner on blog', 'towngov' ),



			'default' => true,



			'dependency' => [ 'archive_source_type', '==', 'd' ],



		),



		array(



			'id'       => 'archive_banner_title',



			'type'     => 'text',



			'title'    => esc_html__( 'Banner Section Title', 'towngov' ),



			'desc'     => esc_html__( 'Enter the title to show in banner section', 'towngov' ),



			'dependency' => [



				array( 'archive_page_banner', '==', true ),



				[ 'archive_source_type', '==', 'd' ],



			],



		),



		array(



			'id'       => 'archive_page_background',



			'type'     => 'media',



			'url'      => true,



			'title'    => esc_html__( 'Background Image', 'towngov' ),



			'desc'     => esc_html__( 'Insert background image for banner', 'towngov' ),



			'default'  => array(



				'url' => TOWNGOV_URI . 'assets/images/background/1.jpg',



			),



			'dependency' => [



				array( 'archive_page_banner', '==', true ),



				[ 'archive_source_type', '==', 'd' ],



			],



		),







		array(



			'id'       => 'archive_sidebar_layout',



			'type'     => 'image_select',



			'title'    => esc_html__( 'Layout', 'towngov' ),



			'subtitle' => esc_html__( 'Select main content and sidebar alignment.', 'towngov' ),



			'options'  => array(







				'left'  => get_template_directory_uri() . '/assets/images/redux/2cl.png',



				'full' => get_template_directory_uri() . '/assets/images/redux/1col.png',



				'right' => get_template_directory_uri() . '/assets/images/redux/2cr.png',



			),







			'default' => 'right',



			'dependency' => [ 'archive_source_type', '==', 'd' ],



		),







		array(



			'id'       => 'archive_page_sidebar',



			'type'     => 'select',



			'title'    => esc_html__( 'Sidebar', 'towngov' ),



			'desc'     => esc_html__( 'Select sidebar to show at blog listing page', 'towngov' ),



			'dependency' => array(



				array( 'archive_sidebar_layout', '!=', 'full' ),



				[ 'archive_source_type', '==', 'd' ],



			),



			'options'  => 'sidebars',



		),



	),



);























