<?php

return array(

	'title'      => esc_html__( '404 Page Settings', 'towngov' ),

	'id'         => '404_setting',

	'desc'       => '',

	'subsection' => true,

	'fields'     => array(

		array(

			'id'      => '404_source_type',

			'type'    => 'button_set',

			'title'   => esc_html__( '404 Source Type', 'towngov' ),

			'options' => array(

				'd' => esc_html__( 'Default', 'towngov' ),

				'e' => esc_html__( 'Elementor', 'towngov' ),

			),

			'default' => 'd',

		),

		array(

			'id'       => '404_elementor_template',

			'type'     => 'select',

			'title'    => __( 'Template', 'towngov' ),

			'options'     => 'posts',

			'query_args'     => [

				'post_type' => [ 'elementor_library' ],

			],

			'dependency' => array( '404_source_type', '==', 'e' ),

		),

		array(

			'id'       => '404_default_st',

			'type'     => 'heading',

			'content'    => esc_html__( '404 Default', 'towngov' ),

			'dependency' => [ '404_source_type', '==', 'd' ],

		),

		

		array(

			'id'       => 'error_page_image',

			'type'     => 'media',

			'url'      => true,

			'title'    => esc_html__( 'Error Image', 'towngov' ),

			'desc'     => esc_html__( 'Insert error image', 'towngov' ),

			'default'  => '',

			'dependency' => array( '404_source_type', '==', 'd' ),

		),

		array(

			'id'    => '404-page_title',

			'type'  => 'text',

			'title' => esc_html__( '404 Title', 'towngov' ),

			'desc'  => esc_html__( 'Enter 404 section title that you want to show', 'towngov' ),

			'dependency'	=> array( '404_source_type', '==', 'd' ),

		),

		array(

			'id'    => 'back_home_btn',

			'type'  => 'switcher',

			'title' => esc_html__( 'Show Button', 'towngov' ),

			'desc'  => esc_html__( 'Enable to show back to home button.', 'towngov' ),

			'default'  => true,

			'dependency'	=> array( '404_source_type', '==', 'd' ),

		),

		array(

			'id'       => 'back_home_btn_label',

			'type'     => 'text',

			'title'    => esc_html__( 'Button Label', 'towngov' ),

			'desc'     => esc_html__( 'Enter back to home button label that you want to show.', 'towngov' ),

			'default'  => esc_html__( 'Go To Home', 'towngov' ),

			'dependency' => array( 

				array( 'back_home_btn', '==', true ),

				array( '404_source_type', '==', 'd' ),

			),

		),

	),

);