<?php
/**
 * The Template for displaying all single Give Forms.
 *
 * Override this template by copying it to yourtheme/give/single-give-forms.php
 *
 * @package       Give/Templates
 * @version       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();

$data    = \TOWNGOV\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-8';
$options = towngov_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
	?>
<?php if ( $data->get( 'enable_banner' ) ) : ?>
	<?php do_action( 'towngov_banner', $data );?>
<?php else:?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->

<?php endif;?>

<?php do_action( 'give_before_main_content' );?>

    <section class="causes-details-section">
    	<div class="container">
        	<div class="row">
				
                <?php
					if ( $data->get( 'layout' ) == 'left' ) {
						do_action( 'towngov_sidebar', $data );
					}
				?>
				<div class="content-side <?php echo esc_attr( $class ); ?>"> 
					<?php
                        while ( have_posts() ) :
                            the_post();
                        
                            give_get_template_part( 'single-give-form/content', 'single-give-form' );
                        
                        endwhile; // end of the loop.
                    ?>
                </div>
                
                <?php
					if ( $data->get( 'layout' ) == 'right' ) {
						do_action( 'towngov_sidebar', $data );
					}
				?>
                
            </div>
    	</div>
    </section>

<?php do_action( 'give_after_main_content' );?>

<?php
}
get_footer();
