<?php

require_once get_template_directory() . '/includes/loader.php';

add_action( 'after_setup_theme', 'towngov_setup_theme' );
add_action( 'after_setup_theme', 'towngov_load_default_hooks' );


function towngov_setup_theme() {

	load_theme_textdomain( 'towngov', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );
	add_theme_support('woocommerce');
	add_theme_support('wc-product-gallery-lightbox');

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );


	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
	add_image_size( 'towngov_91x91', 91, 91, true ); //'towngov_91x91 Testimonials Carousel'
	add_image_size( 'towngov_403x381', 403, 381, true ); //'towngov_403x381 Project Carousel'
	add_image_size( 'towngov_372x282', 372, 282, true ); //'towngov_372x282 Project Carousel'
	add_image_size( 'towngov_372x352', 372, 352, true ); //'towngov_372x352 Project Grid'
	add_image_size( 'towngov_375x288', 375, 288, true ); //'towngov_375x288 Service Grid'
	add_image_size( 'towngov_372x286', 372, 286, true ); //'towngov_372x286 Causes Grid'
	add_image_size( 'towngov_376x251', 376, 251, true ); //'towngov_376x251 Department Grid'
	add_image_size( 'towngov_250x250', 250, 250, true ); //'towngov_250x250 Events'
	add_image_size( 'towngov_465x375', 465, 375, true ); //'towngov_465x375 Our Blog'	
	add_image_size( 'towngov_190x190', 190, 190, true ); //'towngov_190x190 Team Grid'
	add_image_size( 'towngov_550x583', 550, 583, true ); //'towngov_550x583 Team Single'
	add_image_size( 'towngov_1170x451', 1170, 451, true ); //'towngov_1170x451 Service Detials'
	add_image_size( 'towngov_1168x510', 1168, 510, true ); //'towngov_1168x510 Portfolio Single'
	add_image_size( 'towngov_69x69', 69, 69, true ); //'towngov_69x69 Blog Sidebar'
	add_image_size( 'towngov_1170x515', 1170, 515, true ); //'towngov_1170x515 Events Detials'
	add_image_size( 'towngov_1170x414', 1170, 414, true ); //'towngov_1170x414 Blog Detials'

	/*---------- Register image sizes ends ----------*/
	
	
	
	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'towngov' ),
		'top_menu' => esc_html__( 'Top Header Menu', 'towngov' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'towngov_admin_init', 2000000 );
}

/**
 * [towngov_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function towngov_admin_init() {
	
}

/*---------- Sidebar settings ----------*/

/**
 * [towngov_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function towngov_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'towngov' . '_options-mods' );

	register_sidebar( array(
		'name'          => esc_html__( 'Default Sidebar', 'towngov' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'towngov' ),
		'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4>',
		'after_title'   => '</h4>',
	) );
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'towngov'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'towngov'),
		'before_widget'=>'<div class="col-lg-3 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h4 class="footer-widget-title">',
		'after_title' => '</h4>'
	));
	if ( class_exists( '\Elementor\Plugin' )){	
	register_sidebar(array(
		'name' => esc_html__('Services Widget', 'towngov'),
		'id' => 'service-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Services Area.', 'towngov'),
		'before_widget'=>'<div id="%1$s" class="service-widget %2$s">',
		'after_widget'=>'</div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
		'name' => esc_html__('Causes Widget', 'towngov'),
		'id' => 'causes-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Causes Area.', 'towngov'),
		'before_widget'=>'<div id="%1$s" class="cause-widget sidebar-widget %2$s">',
		'after_widget'=>'</div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'towngov' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'towngov' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<h4>',
	  'after_title' => '</h4>'
	));
	}
	if ( ! is_object( towngov_WSH() ) ) {
		return;
	}

	$sidebars = towngov_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( towngov_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar['sidebar'];
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget sidebar-widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4>',
			'after_title'   => '</h4>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'towngov_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings ----------*/

function towngov_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'towngov' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'towngov' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'towngov' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'towngov' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'towngov' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'towngov' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'towngov' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'towngov' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'towngov' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'towngov_gutenberg_editor_palette_styles' );

/*---------- Gutenberg settings ends ----------*/

/*---------- Enqueue Styles and Scripts ----------*/

function towngov_enqueue_scripts() {
	
	//styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/vendor/bootstrap/bootstrap.min.css' );
	wp_enqueue_style( 'towngov-stylesheet', get_template_directory_uri() . '/assets/vendor/reey-font/stylesheet.css' );
	wp_enqueue_style( 'towngov-all', get_template_directory_uri() . '/assets/vendor/font-awesome/css/all.min.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/vendor/animate/animate.min.css' );
	wp_enqueue_style( 'flaticon_towngov', get_template_directory_uri() . '/assets/vendor/flaticon/css/flaticon_towngov.css' );
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/vendor/owl-carousel/owl.carousel.min.css' );
	wp_enqueue_style( 'swiper-bundle', get_template_directory_uri() . '/assets/vendor/swiper/swiper-bundle.min.css' );
	wp_enqueue_style( 'youtube-popup', get_template_directory_uri() . '/assets/vendor/youtube-popup/youtube-popup.css' );
	wp_enqueue_style( 'towngov-main', get_stylesheet_uri() );
	wp_enqueue_style( 'towngov-main-style', get_template_directory_uri() . '/assets/css/style.css' );
	wp_enqueue_style( 'towngov-custom', get_template_directory_uri() . '/assets/css/custom.css' );
	wp_enqueue_style( 'towngov-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css' );
	
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core');	
	wp_enqueue_script( 'bootstrap-bundle', get_template_directory_uri().'/assets/vendor/bootstrap/bootstrap.bundle.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-appear', get_template_directory_uri().'/assets/vendor/jquery-appear/jquery.appear.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'swiper-bundle', get_template_directory_uri().'/assets/vendor/swiper/swiper-bundle.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri().'/assets/vendor/owl-carousel/owl.carousel.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-waypoints', get_template_directory_uri().'/assets/vendor/waypoints/jquery.waypoints.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-counterup', get_template_directory_uri().'/assets/vendor/counter-up/jquery.counterup.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'youtube-popup-jquery', get_template_directory_uri().'/assets/vendor/youtube-popup/youtube-popup.jquery.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'towngov-main-theme', get_template_directory_uri().'/assets/js/theme.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'towngov_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function towngov_fonts_url() {
	
	$fonts_url = '';
		
		$font_families['Manrope']       = 'Manrope:wght@400,500,600,700,800&display=swap';
		$font_families['Red+Hat+Display'] = 'Red Hat Display:ital,wght@400,500,600,700&display=swap';
		

		$font_families = apply_filters( 'TOWNGOV/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);

}

function towngov_theme_styles() {
    wp_enqueue_style( 'towngov-theme-fonts', towngov_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'towngov_theme_styles' );
add_action( 'admin_enqueue_scripts', 'towngov_theme_styles' );

/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) towngov_set function

/**
 * [towngov_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'towngov_set' ) ) {
	function towngov_set( $var, $key, $def = '' ) {

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) towngov_add_editor_styles function

function towngov_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'towngov_add_editor_styles' );

// 3) Add specific CSS class by filter body class.

$options = towngov_WSH()->option(); 
if( towngov_set($options, 'boxed_wrapper') ){

add_filter( 'body_class', function( $classes ) {
    $classes[] = 'boxed_wrapper';
    return $classes;
} );
}

if( !function_exists('towngov_hexcode_to_rgb') ){
function towngov_hexcode_to_rgb($hex) {
	$hex = str_replace("#", "", $hex);

	if(strlen($hex) == 3) {
		$r = hexdec(substr($hex,0,1).substr($hex,0,1));
		$g = hexdec(substr($hex,1,1).substr($hex,1,1));
		$b = hexdec(substr($hex,2,1).substr($hex,2,1));
	} else {
		$r = hexdec(substr($hex,0,2));
		$g = hexdec(substr($hex,2,2));
		$b = hexdec(substr($hex,4,2));
	}
	$rgb = array($r, $g, $b);
	return implode(",", $rgb); // returns the rgb values separated by commas
}
}


if ( !function_exists( 'towngov_options' ) ) {
	function towngov_options( $option = '', $default = null ) {
		$defaults = array();
		$options = get_option( 'towngov_options' );
		$default = ( !isset( $default ) && isset( $defaults[$option] ) ) ? $defaults[$option] : $default;
		return ( isset( $options[$option] ) ) ? $options[$option] : $default;
	}
}

function towngov_inline_css_colors_init(){
    $custom_css ='';

    
    if (class_exists('CSF')) {

		$header_menu_colors = towngov_options('header_menu_colors' );   
		$header_submenu_colors = towngov_options('header_submenu_colors' );   

		$base_colors = towngov_options('base_colors');

	 if (!empty($base_colors)) {
			$primary_rgb = towngov_hexcode_to_rgb($base_colors['primary_color']);
			$secondary_rgb = towngov_hexcode_to_rgb($base_colors['secondary_color']);
			$text_rgb = towngov_hexcode_to_rgb($base_colors['text_color']);
			$black_rgb = towngov_hexcode_to_rgb($base_colors['black_color']);
			$dark_black_rgb = towngov_hexcode_to_rgb($base_colors['dark_black_color']);
			$gray_rgb = towngov_hexcode_to_rgb($base_colors['gray_color']);
			$light_bg_color_rgb = towngov_hexcode_to_rgb($base_colors['light_bg_color']);
			$border_rgb = towngov_hexcode_to_rgb($base_colors['border_color']);


			$custom_css .= ":root {
				--thm-primary: {$base_colors['primary_color']};
				--thm-primary-rgb: {$primary_rgb};
				--thm-secondary: {$base_colors['primary_color']};
				--thm-secondary-rgb: {$secondary_rgb};
				--thm-white: #ffffff;
				--thm-white-rgb: 255, 255, 255;
				--thm-gray:	{$base_colors['gray_color']};
				--thm-gray-rgb: {$gray_rgb};
				--thm-border: {$base_colors['border_color']};
				--thm-border-rgb: {$border_rgb};
				--thm-black: {$base_colors['black_color']};
				--thm-black-rgb:{$black_rgb};
				--thm-dark-black: {$base_colors['dark_black_color']};
				--thm-dark-black-rgb: {$dark_black_rgb};
				--thm-light-bg: {$base_colors['light_bg_color']};
				--thm-light-bg-rgb: {$light_bg_color_rgb};
			}";

		}

        if (!empty($header_menu_colors)) {
            $custom_css .= ".main-menu .main-menu-list > li > a {
                color: {$header_menu_colors['header_menu_link_color']};
            }
            .main-menu .main-menu-list > li.active > a, .main-menu .main-menu-list > li > a:hover {
                color: {$header_menu_colors['header_menu_link_color_hover']};
            }
            .main-menu .main-menu-list > li > a:before {
                background-color: {$header_menu_colors['header_menu_line_color']};
            }           
            ";
        }

        if (!empty($header_submenu_colors)) {
            $custom_css .= ".main-menu .main-menu-list > li ul > li > a {
                color: {$header_submenu_colors['header_submenu_link_color']};
                background-color:{$header_submenu_colors['header_submenu_bg_color']};
            }
            .main-menu .main-menu-list > li ul > li > a:hover {
                color: {$header_submenu_colors['header_submenu_link_color_hover']};
                background-color:{$header_submenu_colors['header_submenu_bg_color_hover']};
            }
            ";
        }


    }
    wp_enqueue_style('towngov-inline' ,get_template_directory_uri().'/assets/css/inline-css.css');
    wp_add_inline_style('towngov-inline',$custom_css);

}


add_action('wp_enqueue_scripts','towngov_inline_css_colors_init');



function towngov_current_year() {
    $year = date('Y');
    return $year;
}

add_shortcode('thisyear', 'towngov_current_year');

/*---------- More functions ends ----------*/