<?php
/**
 * Archive Main File.
 *
 * @package TOWNGOV
 * @author  Udayraj
 * @version 1.0
 */
get_header();
global $wp_query;
$data  = \TOWNGOV\Includes\Classes\Common::instance()->data( 'archive' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'default-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8 col-xl-8';
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>
<?php if ( $data->get( 'enable_banner' ) ) : ?>
	<?php do_action( 'towngov_banner', $data );?>
<?php else:?>
<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">
    <div class="container">
        <div class="page-breadcrumbs">
            <ul class="list-unstyled">
                <?php echo towngov_the_breadcrumb(); ?>
            </ul><!-- list-unstyled -->
        </div><!-- page-breadcrumbs -->
        <div class="page-banner-title">
            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>
        </div><!-- page-banner-title -->
    </div><!-- container -->			
</section><!--page-banner-->
<?php endif;?>
<!-- Sidebar Page Container -->
<section class="news-details-section">
    <div class="container">
        <div class="row">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'towngov_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">                
                <div class="thm-unit-test">                
                    <?php
                        while ( have_posts() ) :
                            the_post();
                            towngov_template_load( 'templates/blog/blog.php', compact( 'data' ) );
                        endwhile;
                        wp_reset_postdata();
                    ?>                    
                </div>            
                <!--Pagination-->
                <div class="styled-pagination">
                    <?php towngov_the_pagination( $wp_query->max_num_pages );?>
                </div>
            </div>            
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'towngov_sidebar', $data );
				}
			?>
        </div>
    </div>
</section> 
<!--End blog area--> 
<?php
}
get_footer();
