<?php

/**

 * 404 page file

 *

 * @package    WordPress

 * @subpackage Towngov

 * @author     Udayraj

 * @version    1.0

 */

$text = sprintf(__('It seems we can\'t find what you\'re looking for. Perhaps searching can help or go back to <a href="%s">Homepage</a>', 'towngov'), esc_html(home_url('/')));

$error_page_img    = $options->get( 'error_page_image' );

$error_page_img    = towngov_set( $error_page_img, 'url' );

$allowed_html = wp_kses_allowed_html( 'post' );

?>

<?php get_header();

$data = \TOWNGOV\Includes\Classes\Common::instance()->data( '404' )->get();

$options = towngov_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {

	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );

} else {

?>

<?php if ( $data->get( 'enable_banner' ) ) : ?>

	<?php do_action( 'towngov_banner', $data );?>

<?php else:?>

<section class="page-banner" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>');">

    <div class="container">

        <div class="page-breadcrumbs">

            <ul class="list-unstyled">

                <?php echo towngov_the_breadcrumb(); ?>

            </ul><!-- list-unstyled -->

        </div><!-- page-breadcrumbs -->

        <div class="page-banner-title">

            <h3><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h3>

        </div><!-- page-banner-title -->

    </div><!-- container -->			

</section><!--page-banner-->

<?php endif;?>   

    

    <section class="error-page">

        <div class="container">

			<?php if( $error_page_img ):?>

            	<img src="<?php echo esc_url($error_page_img); ?>" alt="<?php esc_attr_e('Awesome Image', 'towngov');?>" class="img-fluid float-bob-x">

			<?php else:?>

            	<h2 class="error-title"><?php esc_html_e( '404', 'towngov' );?></h2>

			<?php endif;?>

            <h3 class="error-page__title <?php if( ! $error_page_img ) echo 'm-t0';?>">

            	<?php 

					if( $options->get( '404-page_title' ) ){

						echo wp_kses( $options->get( '404-page_title' ), true );

					}else{

						esc_html_e( 'OPPS! This Page are can’t be found', 'towngov' );

					}

				?>            

            </h3><!-- /.error-page__title -->

            <?php if ( $options->get( 'back_home_btn', true ) ) : ?>

            <a href="<?php echo( home_url( '/' ) ); ?>" class="thm-btn">

                <span>

                    <?php echo wp_kses( $options->get('back_home_btn_label'), $allowed_html ) ? wp_kses( $options->get('back_home_btn_label'), $allowed_html ) : esc_html_e( 'Go To Home', 'towngov' ); ?>

                    <i class="far fa-arrow-right"></i>

                </span>

            </a><!-- /.thm-btn -->

            <?php endif; ?>

        </div><!-- /.container -->

    </section><!-- /.error-page -->

     

<?php

}

get_footer(); ?>

