<?php

namespace TOWNGOVPLUGIN\Inc;

use TOWNGOVPLUGIN\Inc\Abstracts\Taxonomy;

class Taxonomies extends Taxonomy {

	public static function init() {

		$labels = array(

			'name'              => _x( 'Project Category', 'wptowngov' ),

			'singular_name'     => _x( 'Project Category', 'wptowngov' ),

			'search_items'      => __( 'Search Category', 'wptowngov' ),

			'all_items'         => __( 'All Categories', 'wptowngov' ),

			'parent_item'       => __( 'Parent Category', 'wptowngov' ),

			'parent_item_colon' => __( 'Parent Category:', 'wptowngov' ),

			'edit_item'         => __( 'Edit Category', 'wptowngov' ),

			'update_item'       => __( 'Update Category', 'wptowngov' ),

			'add_new_item'      => __( 'Add New Category', 'wptowngov' ),

			'new_item_name'     => __( 'New Category Name', 'wptowngov' ),

			'menu_name'         => __( 'Project Category', 'wptowngov' ),

		);

		$args   = array(

			'hierarchical'       => true,

			'labels'             => $labels,

			'show_ui'            => true,

			'show_admin_column'  => true,

			'query_var'          => true,

			'public'             => true,

			'publicly_queryable' => true,

			'rewrite'            => array( 'slug' => 'project_cat' ),

		);

		register_taxonomy( 'project_cat', 'project', $args );

		

		//Services Taxonomy Start

		$labels = array(

			'name'              => _x( 'Service Category', 'wptowngov' ),

			'singular_name'     => _x( 'Service Category', 'wptowngov' ),

			'search_items'      => __( 'Search Category', 'wptowngov' ),

			'all_items'         => __( 'All Categories', 'wptowngov' ),

			'parent_item'       => __( 'Parent Category', 'wptowngov' ),

			'parent_item_colon' => __( 'Parent Category:', 'wptowngov' ),

			'edit_item'         => __( 'Edit Category', 'wptowngov' ),

			'update_item'       => __( 'Update Category', 'wptowngov' ),

			'add_new_item'      => __( 'Add New Category', 'wptowngov' ),

			'new_item_name'     => __( 'New Category Name', 'wptowngov' ),

			'menu_name'         => __( 'Service Category', 'wptowngov' ),

		);

		$args   = array(

			'hierarchical'       => true,

			'labels'             => $labels,

			'show_ui'            => true,

			'show_admin_column'  => true,

			'query_var'          => true,

			'public'             => true,

			'publicly_queryable' => true,

			'rewrite'            => array( 'slug' => 'service_cat' ),

		);

		register_taxonomy( 'service_cat', 'service', $args );

		

		//Departments Taxonomy Start

		$labels = array(

			'name'              => _x( 'Department Category', 'wptowngov' ),

			'singular_name'     => _x( 'Department Category', 'wptowngov' ),

			'search_items'      => __( 'Search Category', 'wptowngov' ),

			'all_items'         => __( 'All Categories', 'wptowngov' ),

			'parent_item'       => __( 'Parent Category', 'wptowngov' ),

			'parent_item_colon' => __( 'Parent Category:', 'wptowngov' ),

			'edit_item'         => __( 'Edit Category', 'wptowngov' ),

			'update_item'       => __( 'Update Category', 'wptowngov' ),

			'add_new_item'      => __( 'Add New Category', 'wptowngov' ),

			'new_item_name'     => __( 'New Category Name', 'wptowngov' ),

			'menu_name'         => __( 'Department Category', 'wptowngov' ),

		);

		$args   = array(

			'hierarchical'       => true,

			'labels'             => $labels,

			'show_ui'            => true,

			'show_admin_column'  => true,

			'query_var'          => true,

			'public'             => true,

			'publicly_queryable' => true,

			'rewrite'            => array( 'slug' => 'department_cat' ),

		);

		register_taxonomy( 'department_cat', 'department', $args );

		

		//Testimonials Taxonomy Start

		$labels = array(

			'name'              => _x( 'Testimonials Category', 'wptowngov' ),

			'singular_name'     => _x( 'Testimonials Category', 'wptowngov' ),

			'search_items'      => __( 'Search Category', 'wptowngov' ),

			'all_items'         => __( 'All Categories', 'wptowngov' ),

			'parent_item'       => __( 'Parent Category', 'wptowngov' ),

			'parent_item_colon' => __( 'Parent Category:', 'wptowngov' ),

			'edit_item'         => __( 'Edit Category', 'wptowngov' ),

			'update_item'       => __( 'Update Category', 'wptowngov' ),

			'add_new_item'      => __( 'Add New Category', 'wptowngov' ),

			'new_item_name'     => __( 'New Category Name', 'wptowngov' ),

			'menu_name'         => __( 'Testimonials Category', 'wptowngov' ),

		);

		$args   = array(

			'hierarchical'       => true,

			'labels'             => $labels,

			'show_ui'            => true,

			'show_admin_column'  => true,

			'query_var'          => true,

			'public'             => true,

			'publicly_queryable' => true,

			'rewrite'            => array( 'slug' => 'testimonials_cat' ),

		);

		register_taxonomy( 'testimonials_cat', 'testimonials', $args );

		

		

		//Team Taxonomy Start

		$labels = array(

			'name'              => _x( 'Team Category', 'wptowngov' ),

			'singular_name'     => _x( 'Team Category', 'wptowngov' ),

			'search_items'      => __( 'Search Category', 'wptowngov' ),

			'all_items'         => __( 'All Categories', 'wptowngov' ),

			'parent_item'       => __( 'Parent Category', 'wptowngov' ),

			'parent_item_colon' => __( 'Parent Category:', 'wptowngov' ),

			'edit_item'         => __( 'Edit Category', 'wptowngov' ),

			'update_item'       => __( 'Update Category', 'wptowngov' ),

			'add_new_item'      => __( 'Add New Category', 'wptowngov' ),

			'new_item_name'     => __( 'New Category Name', 'wptowngov' ),

			'menu_name'         => __( 'Team Category', 'wptowngov' ),

		);

		$args   = array(

			'hierarchical'       => true,

			'labels'             => $labels,

			'show_ui'            => true,

			'show_admin_column'  => true,

			'query_var'          => true,

			'public'             => true,

			'publicly_queryable' => true,

			'rewrite'            => array( 'slug' => 'team_cat' ),

		);

		register_taxonomy( 'team_cat', 'team', $args );

		

		//Faqs Taxonomy Start

		$labels = array(

			'name'              => _x( 'Documentations Category', 'wptowngov' ),

			'singular_name'     => _x( 'Documentation Category', 'wptowngov' ),

			'search_items'      => __( 'Search Category', 'wptowngov' ),

			'all_items'         => __( 'All Categories', 'wptowngov' ),

			'parent_item'       => __( 'Parent Category', 'wptowngov' ),

			'parent_item_colon' => __( 'Parent Category:', 'wptowngov' ),

			'edit_item'         => __( 'Edit Category', 'wptowngov' ),

			'update_item'       => __( 'Update Category', 'wptowngov' ),

			'add_new_item'      => __( 'Add New Category', 'wptowngov' ),

			'new_item_name'     => __( 'New Category Name', 'wptowngov' ),

			'menu_name'         => __( 'Documentation Category', 'wptowngov' ),

		);

		$args   = array(

			'hierarchical'       => true,

			'labels'             => $labels,

			'show_ui'            => true,

			'show_admin_column'  => true,

			'query_var'          => true,

			'public'             => true,

			'publicly_queryable' => true,

			'rewrite'            => array( 'slug' => 'documentations_cat' ),

		);

		register_taxonomy( 'documentations_cat', 'documentations', $args );

	}

	

}

