<?php
//
// Set a unique slug-like ID
$prefix = 'towngov_meta_team';
//
// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'      	=> 'Towngov Team Setting',
	'icon'       	=> 'el el-cogs',
	'position'   	=> 'normal',
	'priority'   	=> 'core',
	'post_type' 	=> array( 'team' ),
	'show_restore'       => false,
	'context'            => 'advanced',
	'nav'                => 'normal',
	'theme'              => 'dark',
	'class'              => '',
) );
//
// Create a section
CSF::createSection($prefix, array(
	'fields' => array(
		array(
			'id'    => 'team_image_caption',
			'type'  => 'text',
			'title' => esc_html__( 'Image BG Caption', 'towngov' ),
		),
		array(
			'id'    => 'team_designation',
			'type'  => 'text',
			'title' => esc_html__( 'Designation', 'towngov' ),
		),
		array(
			'id'    => 'team_age_title',
			'type'  => 'text',
			'title' => esc_html__( 'Age Title', 'towngov' ),
		),
		array(
			'id'    => 'team_age',
			'type'  => 'text',
			'title' => esc_html__( 'Age', 'towngov' ),
		),
		array(
			'id'    => 'team_email_title',
			'type'  => 'text',
			'title' => esc_html__( 'Email Title', 'towngov' ),
		),
		array(
			'id'    => 'team_email',
			'type'  => 'text',
			'title' => esc_html__( 'Email Address', 'towngov' ),
		),
		array(
			'id'    => 'team_phone_title',
			'type'  => 'text',
			'title' => esc_html__( 'Phone Title', 'towngov' ),
		),
		array(
			'id'    => 'team_phone_no',
			'type'  => 'text',
			'title' => esc_html__( 'Phone Number', 'towngov' ),
		),
		array(
			'id'    => 'social_profile',
			'type'  => 'group',
			'title' => esc_html__( 'Social Profiles', 'towngov' ),
			'fields'	=> array(
				array(
					'id'    => 'url',
					'type'  => 'text',
					'title' => esc_html__( 'URL', 'towngov' ),
				),
				array(
					'id'    => 'icon',
					'type'  => 'icon',
					'title' => esc_html__( 'Icon', 'towngov' ),
				),
				array(
					'id'    => 'background',
					'type'  => 'color',
					'title' => esc_html__( 'Background Color', 'towngov' ),
				),
				array(
					'id'    => 'color',
					'type'  => 'color',
					'title' => esc_html__( 'Color', 'towngov' ),
				),
			)
		),
		//Education
		array(
			'id' => 'show_education_info',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Education Information', 'towngov'),
			'desc' => esc_html__('Enable to Show Education Information', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'education_title',
			'type'  => 'text',
			'title' => esc_html__( 'Education Title', 'towngov' ),
			'dependency' => array('show_education_info', '==', true),
		),
		array(
			'id'    => 'team_education',
			'type'  => 'group',
			'dependency' => array('show_education_info', '==', true),			
			'title' => esc_html__( 'Eduction Detail', 'towngov' ),
			'fields'	=> array(
				array(
					'id'    => 'education_period',
					'type'  => 'text',
					'title' => esc_html__( 'Education Years', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Education Years', 'towngov' ),
				),
				array(
					'id'    => 'education_degree',
					'type'  => 'text',
					'title' => esc_html__( 'Master In', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Master In', 'towngov' ),
				),
				array(
					'id'    => 'university',
					'type'  => 'text',
					'title' => esc_html__( 'Education University', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Education University', 'towngov' ),
				),
			),
		),
		//Biography Section
		array(
			'id' => 'show_biography_section',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Biography Section', 'towngov'),
			'desc' => esc_html__('Enable to Show Biography Section', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'team_biography_title',
			'type'  => 'text',
			'title' => esc_html__( 'Biography Title', 'towngov' ),
			'dependency' => array('show_biography_section', '==', true),
		),
		array(
			'id'    => 'team_biography_description',
			'type'  => 'textarea',
			'title' => esc_html__( 'Biography Description', 'towngov' ),
			'dependency' => array('show_biography_section', '==', true),
		),		
		//Skills Section
		array(
			'id' => 'show_skills_area',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Skills Information', 'towngov'),
			'desc' => esc_html__('Enable to Show Skills Information', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'team_skills_title',
			'type'  => 'text',
			'title' => esc_html__( 'Skills Title', 'towngov' ),
			'dependency' => array('show_skills_area', '==', true),
		),
		array(
			'id'    => 'team_skills',
			'type'  => 'group',
			'dependency' => array('show_skills_area', '==', true),			
			'title' => esc_html__( 'Skills', 'towngov' ),
			'fields'	=> array(
				array(
					'id'       => 'team_skills_title1',
					'type'     => 'text',
					'title'    => esc_html__( 'Skills Counter Title', 'towngov' ),
					'desc'     => esc_html__( 'Enter the Skills Counter Title', 'towngov' ),
				),
				array(
					'id'       => 'team_skills_counter_value',
					'type'     => 'text',
					'title'    => esc_html__( 'Skills Counter Value', 'towngov' ),
					'desc'     => esc_html__( 'Enter the Skills Counter Value', 'towngov' ),
				),
			),
		),
		//Contact with Me Section
		array(
			'id' => 'show_contact_me',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Contact with Me Section', 'towngov'),
			'desc' => esc_html__('Enable to Show Contact with Me Section', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'team_form_image',
			'type'  => 'media',
			'url'      => true,
			'title' => esc_html__( 'Form Background Image', 'towngov' ),
			'default'  => array(
				'url' => get_template_directory_uri() . '/assets/images/bg/team-contact-1.png',
			),
			'dependency' => array('show_contact_me', '==', true),
		),
		array(
			'id'    => 'team_form_sub_title',
			'type'  => 'text',
			'title' => esc_html__( 'Contact Form Sub Title', 'towngov' ),
			'dependency' => array('show_contact_me', '==', true),
		),
		array(
			'id'    => 'team_form_title',
			'type'  => 'text',
			'title' => esc_html__( 'Contact Form Title', 'towngov' ),
			'dependency' => array('show_contact_me', '==', true),
		),
		array(
			'id'    => 'team_form_url',
			'type'  => 'text',
			'title' => esc_html__( 'Contact Form Url', 'towngov' ),
			'dependency' => array('show_contact_me', '==', true),
		),	
	)
));
