<?php

//

// Create a section

CSF::createSection($prefix, array(

	'title'  => esc_html__("Towngov footer Settings", "konia"),

	'fields' => array(

		array(

			'id'      => 'footer_source_type',

			'type'    => 'button_set',

			'title'   => esc_html__('Footer Source Type', 'towngov'),

			'options' => array(

				'd'    => esc_html__('Default', 'towngov'),

				'e'    => esc_html__('Elementor', 'towngov'),

			),

			'default' => '',

		),

		array(

			'id'       => 'footer_elementor_template',

			'type'     => 'select',

			'title'    => __('Template', 'viral-buzz'),

			'options'     => 'posts',

			'query_args'     => [

				'post_type' => ['elementor_library'],

				'posts_per_page' => -1,

				'orderby'  => 'title',

				'order'     => 'DESC'

			],

			'dependency' => ['footer_source_type', '==', 'e'],

		),

		array(

			'id'       => 'footer_style_settings',

			'type'     => 'image_select',

			'title'    => esc_html__('Choose Footer Styles', 'towngov'),

			'options'  => array(

				'footer_v1' => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',

			),

			'dependency' => array(array('footer_source_type', '==', 'd')),

		),

	)

));

