<?php
// Set a unique slug-like ID
$prefix = 'towngov_meta_event';
//
// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'      	=> 'Towngov Event Setting',
	'icon'       	=> 'el el-cogs',
	'position'   	=> 'normal',
	'priority'   	=> 'core',
	'post_type' 	=> array( 'tribe_events' ),
	'show_restore'       => false,
	'context'            => 'advanced',
	'nav'                => 'normal',
	'theme'              => 'dark',
	'class'              => '',
) );
//
// Create a section
CSF::createSection($prefix, array(
	'fields' => array(
		array(
			'id'    => 'video',
			'type'  => 'text',
			'title' => esc_html__( 'Video Link', 'towngov' ),
		),
		
		//Speakers Info
		array(
			'id' => 'show_speakers_info',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Speakers Information', 'towngov'),
			'desc' => esc_html__('Enable to Show Speakers Information', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'speakers_main_heading',
			'type'  => 'text',
			'title' => esc_html__( 'Title/Heading', 'towngov' ),
			'dependency' => array('show_speakers_info', '==', true),
		),
		array(
			'id'    => 'speakers_info',
			'type'  => 'group',
			'dependency' => array('show_speakers_info', '==', true),			
			'title' => esc_html__( 'Chief Guests', 'towngov' ),
			'fields'	=> array(
				array(
					'id'    => 'speaker_image',
					'type'  => 'media',
					'url'      => true,
					'title' => esc_html__( 'Speaker Image', 'towngov' ),
				),
				array(
					'id'    => 'speaker_title',
					'type'  => 'text',
					'title' => esc_html__( 'Speaker Name', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Speaker Name', 'towngov' ),
				),
				array(
					'id'    => 'speaker_designation',
					'type'  => 'text',
					'title' => esc_html__( 'Speaker Designation', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Speaker Designation', 'towngov' ),
				),
				array(
					'id'    => 'speaker_link',
					'type'  => 'text',
					'title' => esc_html__( 'Speaker Link', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Speaker Link', 'towngov' ),
				),
			),
		),
		
		//Gallery Info
		array(
			'id' => 'show_gallery_info',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Gallery Information', 'towngov'),
			'desc' => esc_html__('Enable to Show Gallery Information', 'towngov'),
			'default'  => false,
		),
		array(
			'id'    => 'gallery_main_heading',
			'type'  => 'text',
			'title' => esc_html__( 'Title/Heading', 'towngov' ),
			'dependency' => array('show_gallery_info', '==', true),
		),
		array(
			'id'       => 'gallery_imgs',
			'type'     => 'gallery',
			'url'      => true,
			'title'    => esc_html__('Slider Image', 'towngov'),
			'desc'     => esc_html__('Insert Event Single Page Slide Image URl', 'towngov'),
			'dependency' => array('show_gallery_info', '==', true),
		),
		
		//social Icons
		array(
			'id'    => 'event_social_profile',
			'type'  => 'group',
			'title' => esc_html__( 'Social Profiles', 'towngov' ),
			'fields'	=> array(
				array(
					'id'    => 'url',
					'type'  => 'text',
					'title' => esc_html__( 'URL', 'towngov' ),
				),
				array(
					'id'    => 'icon',
					'type'  => 'icon',
					'title' => esc_html__( 'Icon', 'towngov' ),
				),
				array(
					'id'    => 'background',
					'type'  => 'color',
					'title' => esc_html__( 'Background Color', 'towngov' ),
				),
				array(
					'id'    => 'color',
					'type'  => 'color',
					'title' => esc_html__( 'Color', 'towngov' ),
				),
			)
		),
		
		
	)
));
