<?php
//
// Set a unique slug-like ID
$prefix = 'towngov_meta_documentation';
//
// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'      	=> 'Towngov Documentation Setting',
	'icon'       	=> 'el el-cogs',
	'position'   	=> 'normal',
	'priority'   	=> 'core',
	'post_type' 	=> array( 'documentations' ),
	'show_restore'       => false,
	'context'            => 'advanced',
	'nav'                => 'normal',
	'theme'              => 'dark',
	'class'              => '',
) );
//
// Create a section
CSF::createSection($prefix, array(
	'fields' => array(
		array(
			'id'       => 'doc_icon',
			'type'     => 'select',
			'title'    => esc_html__( 'Icons', 'towngov' ),
			'options'  => get_fontawesome_icons(),
		),
		//Features Box
		array(
			'id' => 'show_doc_box',
			'type' => 'switcher',
			'title' => esc_html__('Show/Hide Documentation Box Info', 'towngov'),
			'desc' => esc_html__('Enable to Show Documentation Box Info', 'towngov'),
			'default'  => false,
		),
		
		array(
			'id'    => 'doc_title',
			'type'  => 'text',
			
			'dependency' => array('show_doc_box', '==', true),	
			'default' => esc_html__( 'Download Documents', 'towngov' ),
			'title' => esc_html__( 'Enter Title', 'towngov' ),
		),
		array(
			'id'    => 'doc_features',
			'type'  => 'group',
			'dependency' => array('show_doc_box', '==', true),			
			'title' => esc_html__( 'Documentation Box Info', 'towngov' ),
			'fields'	=> array(
				array(
					'id'       => 'doc_feature_icon',
					'type'     => 'select',
					'title'    => esc_html__( 'Icons', 'towngov' ),
					'options'  => get_fontawesome_icons(),
				),
				array(
					'id'    => 'doc_feature_title',
					'type'  => 'text',
					'title' => esc_html__( 'Title', 'towngov' ),
					'default' => esc_html__( 'Proin Tempus', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Title', 'towngov' ),
				),
				array(
					'id'    => 'doc_feature_description',
					'type'  => 'textarea',
					'title' => esc_html__( 'Description', 'towngov' ),
					'desc'  => esc_html__( 'Enter the Description', 'towngov' ),
				),
				array(
					'id'    => 'doc_feature_box_url',
					'type'  => 'text',
					'title' => esc_html__( 'External Url', 'towngov' ),
					'desc'  => esc_html__( 'Enter the External Url', 'towngov' ),
				),
			),
		),
	)
));