<?php



//

// Create a section

CSF::createSection($prefix, array(

	'title'  => esc_html__("Towngov Banner Settings", "konia"),

	'fields' => array(

		array(

			'id'      => 'banner_source_type',

			'type'    => 'button_set',

			'title'   => esc_html__('Banner Source Type', 'towngov'),

			'options' => array(

				'd' => esc_html__('Default', 'towngov'),

				'e' => esc_html__('Elementor', 'towngov'),

			),

			'default' => '',

		),

		array(

			'id'       => 'banner_elementor_template',

			'type'     => 'select',

			'title'    => __('Template', 'viral-buzz'),

			'options'     => 'posts',

			'query_args'     => [

				'post_type' => ['elementor_library'],

				'posts_per_page' => -1,

			],

			'dependency' => ['banner_source_type', '==', 'e'],

		),

		array(

			'id'       => 'banner_page_banner',

			'type'     => 'switcher',

			'title'    => esc_html__('Show Banner', 'towngov'),

			'default'  => false,

			'dependency' => ['banner_source_type', '==', 'd'],

		),

		array(

			'id'       => 'banner_banner_title',

			'type'     => 'text',

			'title'    => esc_html__('Banner Section Title', 'towngov'),

			'desc'     => esc_html__('Enter the title to show in banner section', 'towngov'),

			'dependency' => array('banner_page_banner', '==', true),

		),

		array(

			'id'       => 'banner_page_background',

			'type'     => 'media',

			'url'      => true,

			'title'    => esc_html__('Background Image', 'towngov'),

			'desc'     => esc_html__('Insert background image for banner', 'towngov'),

			'default'  => '',

			'dependency' => array('banner_page_banner', '==', true),

		),

	)

));



