<?php

namespace TOWNGOVPLUGIN\Inc;

class Metaboxes
{

    /**
     * Post metaboxes fields.
     * 
     * @var $posts
     */
    protected $posts = [
        'page.php',
        'projects.php',
        'service.php',
		'department.php',
		'documentation.php',
        'team.php',
        'testimonials.php',
        'event.php',
    ];

    /**
     * Taxonomy metaboxes fields.
     * See example in inc/tax-metaboxes/example.php
     * 
     * @var $tax
     */
    protected $tax = [
        // 'example.php',
    ];

    /**
     * Taxonomy metaboxes fields.
     * See example in inc/tax-metaboxes/example.php
     * 
     * @var $tax
     */
    protected $widgets = [
        'yt-about-company-2.php',
		'yt-contact-us.php',
		'yt-get-any-help.php',
		'yt-download-profile.php',
		'yt-organizer-widget.php',
		'yt-popular-posts.php',
    ];

    public function boot()
    {
        $this->post_metaboxes();
        $this->tax_metaboxes();
        $this->nav_fields();
        $this->user_fields();
        $this->widget_fields();
        $this->comment_fields();
    }

    /**
     * Register posts metaboxes using code start framework
     * 
     * @return void
     */
    private function post_metaboxes()
    {
        foreach ( $this->posts as $file ) {
			$this->load_file( TOWNGOVPLUGIN_PLUGIN_PATH . '/inc/metaboxes/' . $file );
		}
    }

    /**
     * Register taxonomy metaboxes using code start framework
     * 
     * @return void
     */
    private function tax_metaboxes()
    {
        foreach ( $this->tax as $file ) {
			$this->load_file( TOWNGOVPLUGIN_PLUGIN_PATH . '/inc/tax-metaboxes/' . $file );
		}
    }

    /**
     * Register nav menu fields using code start framework
     * 
     * @return void
     */
    private function nav_fields()
    {
        $this->load_file( TOWNGOVPLUGIN_PLUGIN_PATH . '/inc/nav-fields.php' );
    }

    /**
     * Register user edit screen fields using code start framework
     * 
     * @return void
     */
    private function user_fields()
    {
        $this->load_file( TOWNGOVPLUGIN_PLUGIN_PATH . '/inc/user-fields.php' );
    }

    /**
     * Register comment form fields using code start framework
     * 
     * @return void
     */
    private function comment_fields()
    {
        $this->load_file( TOWNGOVPLUGIN_PLUGIN_PATH . '/inc/comment-fields.php' );
    }

    /**
     * Register WordPress widgets using code start framework
     * 
     * @return void
     */
    private function widget_fields()
    {
        foreach ( $this->widgets as $file ) {
			$this->load_file( TOWNGOVPLUGIN_PLUGIN_PATH . '/inc/widgets/' . $file );
		}
    }

    /**
     * Check if file exists then load it.
     * 
     * @return void
     */
    protected function load_file($file) {
        if ( file_exists( $file ) ) {
            require $file;
        }
    }
}


(new Metaboxes)->boot();