<?php namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Stroke;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Team extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'towngov_team';
	}
	
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Towngov Team', 'towngov' );
	}
	
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-icon-box town';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'towngov' ];
	}	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'team',
			[
				'label' => esc_html__( 'Towngov Team', 'towngov' ),
			]
		);
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'towngov' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/team/team1.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/team/team3.png'
					],
				],
			]
		);
		
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'greenture' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 12,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'greenture' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'greenture' ),
                    'title'      => esc_html__( 'Title', 'greenture' ),
                    'menu_order' => esc_html__( 'Menu Order', 'greenture' ),
                    'rand'       => esc_html__( 'Random', 'greenture' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'greenture' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'greenture' ),
                    'ASC'  => esc_html__( 'ASC', 'greenture' ),
                ),
            ]
        );
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label_block' => true,
			  'label' => esc_html__('Category', 'towngov'),
			  'options' => get_team_categories()
			]
		);
		$this->end_controls_section();
		
		/**Grid Setting Start**/
		$this->start_controls_section(
			'grid',
			[
				'label' => esc_html__( 'Grid Setting', 'towngov' ),			
			]
		);
		$this->add_control(
			'col_grid',
			[
				'label'   => esc_html__( 'Choose Column', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'four',
				'options' => array(
					'one' => esc_html__( 'One Column Grid ', 'towngov'),
					'two'  => esc_html__( 'Two Column Grid', 'towngov' ),
					'three'  => esc_html__( 'Three Column Grid', 'towngov' ),
					'four'  => esc_html__( 'Four Column Grid', 'towngov' ),
					'five'  => esc_html__( 'Six Column Grid', 'towngov' ),
				),				
			]
		);
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Loop Style**/
		$this->start_controls_section(
			'loop_style',
			[
				'label' => esc_html__('LOOP CONTENT STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		//Loop Background Color Style
		$this->add_control(
			'show_loop_loop_style',
			[
				'label'       => __( 'ON/OFF  Loop Content Background Color Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);		
		$this->add_control(
            'loop_loop_bgcolor',
            [
                'label' => __('Loop Background Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-content-box' => 'background-color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_loop_style'    => 'yes',
				]
            ]
        );	
		//Icon Style
		$this->add_control(
			'show_loop_icon_style',
			[
				'label'       => __( 'ON/OFF  Icon Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'condition' => [ 'layout_control' => '2', ],
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_icon_typography',
                'label' => __('Icon Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .tg-icon-box',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_icon_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_icon_color',
            [
                'label' => __('Icon Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-icon-box' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_icon_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_icon_hover_color',
            [
                'label' => __('Icon Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-icon-box a:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_icon_style'    => 'yes',
				]
            ]
        );
		//Title Style
		$this->add_control(
			'show_loop_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_title_typography',
                'label' => __('Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .tg-service-title,
								 .tg-service-title a',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_color',
            [
                'label' => __('Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-service-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .tg-service-title a' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_title_hover_color',
            [
                'label' => __('Title Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-service-title:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .tg-service-title a:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_title_style'    => 'yes',
				]
            ]
        );
		//Content Style
		$this->add_control(
			'show_loop_content_style',
			[
				'label'       => __( 'ON/OFF  Content Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_content_typography',
                'label' => __('Content Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .tg-service-text',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_content_color',
            [
                'label' => __('Content Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-service-text' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_content_style'    => 'yes',
				]
            ]
        );
		//Button Style
		$this->add_control(
			'show_loop_btn_style',
			[
				'label'       => __( 'ON/OFF  Button Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'condition' => [ 'layout_control' => '1', ],
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'loop_btn_typography',
                'label' => __('Button Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .tg-service-btn a,
								 .tg-service-btn a span',                 
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_color',
            [
                'label' => __('Button Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-service-btn a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .tg-service-btn a span' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'loop_btn_hover_color',
            [
                'label' => __('Button Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .tg-service-btn a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .tg-service-btn a span:hover' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_loop_btn_style'    => 'yes',
				]
            ]
        );		
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		$grid_col = $settings['col_grid'];
		
        $paged = towngov_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-towngov' );
		$args = array(
			'post_type'      =>  'team',
			'posts_per_page' => towngov_set( $settings, 'query_number' ),
			'orderby'        => towngov_set( $settings, 'query_orderby' ),
			'order'          => towngov_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
				
		if( towngov_set( $settings, 'query_category' ) ) $args['team_cat'] = towngov_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		if ( $query->have_posts() ) 
		{ 
	?>
    
    <?php if($settings['layout_control'] == 'two') : ?>
              
    <div class="row">
        <?php while ( $query->have_posts() ) : $query->the_post(); ?>
        <?php $towngov_team_meta = get_post_meta( get_the_ID(), 'towngov_meta_team', true );?>
        <div class="col-md-6 col-lg-4 col-xl-3">
            <div class="team-card">
                <div class="team-card__image">
                    <?php the_post_thumbnail('towngov_300x285'); ?>
                    <div class="team-card__hover">
                        <h3 class="team-card__title"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                        <!-- /.team-card__title -->
                        <p class="team-card__designation"><?php echo wp_kses($towngov_team_meta['designation'], true ); ?></p><!-- /.team-card__designation -->
                        <?php
                            $icons = $towngov_team_meta['social_profile'];
                            if ( ! empty( $icons ) ) :								
                        ?>
                        <!-- Social Box -->
                        <ul class="list-unstyled team-card__social">
                            <?php foreach ( $icons as $h_icon ) {
            
                                $icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); 
                            ?>
                            <li><a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>"<?php endif;?>><i class="fab <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a></li>
                            <?php } ?>
                         </ul>
                         <?php endif; ?>
                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="team-card__hover__link">
                            <i class="far fa-arrow-right"></i>
                        </a><!-- /.team-card__hover__link -->
                    </div><!-- /.team-card__hover -->
                </div><!-- /.team-card__image -->
                <div class="team-card__content">
                    <h3 class="team-card__title"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                    <!-- /.team-card__title -->
                    <p class="team-card__designation"><?php echo wp_kses($towngov_team_meta['designation'], true ); ?></p><!-- /.team-card__designation -->
                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="team-card__content__link">
                        <i class="far fa-arrow-right"></i>
                    </a><!-- /.team-card__content__link -->
                </div><!-- /.team-card__content -->
            </div><!-- /.team-card -->
        </div><!-- /.col-md-6 col-lg-4 col-xl-3 -->
        <?php endwhile; ?>
    </div>
          
            
	<?php else: ?>
    
    <div class="row row-gutter-y-30">
        <?php 
			while ( $query->have_posts() ) : $query->the_post(); 
			
			if( $grid_col == 'one' ){
				$classes = 'col-xl-12 col-lg-12 col-md-12 col-sm-12';
			}elseif( $grid_col == 'two' ){
				$classes = 'col-xl-6 col-lg-6 col-md-6 col-sm-12';
			}elseif( $grid_col == 'three' ){
				$classes = 'col-xl-4 col-lg-4 col-md-6 col-sm-12';
			}elseif( $grid_col == 'five' ){
				$classes = 'col-xl-2 col-lg-2 col-md-6 col-sm-12';
			}else{
				$classes = 'col-xl-3 col-lg-3 col-md-6 col-sm-12';
			} 
		?>
        <?php $towngov_team_meta = get_post_meta( get_the_ID(), 'towngov_meta_team', true );?>
        <div class="<?php echo esc_attr( $classes );?>">
            <div class="team-card tg-content-box">
                <div class="team-card-img">
                    <div class="img-fluid"><?php the_post_thumbnail('towngov_190x190'); ?></div>
                    <?php
						$icons = $towngov_team_meta['social_profile'];
						if ( ! empty( $icons ) ) :								
					?>
					<div class="team-card-icon tg-service-btn">
						<?php foreach ( $icons as $h_icon ) {
		
							$icon_class = explode( '-', towngov_set( $h_icon, 'icon' ) ); 
						?>
						<a href="<?php echo esc_url(towngov_set( $h_icon, 'url' )); ?>" <?php if( towngov_set( $h_icon, 'background' ) || towngov_set( $h_icon, 'color' ) ):?>style="background-color:<?php echo esc_attr(towngov_set( $h_icon, 'background' )); ?>; color: <?php echo esc_attr(towngov_set( $h_icon, 'color' )); ?>"<?php endif;?>><i class="fa-brands <?php echo esc_attr( towngov_set( $h_icon, 'icon' ) ); ?>"></i></a>
						<?php } ?>
					</div>
					<?php endif; ?>
                </div><!-- team-card-img -->
                <div class="team-card-content">
                    <h4 class="tg-service-title"><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h4>
                    <p class="tg-service-text"><?php echo wp_kses($towngov_team_meta['team_designation'], true ); ?></p>
                </div><!-- team-card-content -->
            </div><!--team-card-->
        </div><!--col-12 col-md-6 col-xl-3-->
        <?php endwhile; ?>
    </div>
    
	<?php endif; ?>
      <?php }
		wp_reset_postdata();
	}
}