<?php namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Stroke;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Social_Media extends Widget_Base {
    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_social_media';
    }
    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Towngov Social Media', 'towngov' );
    }
    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-bullet-list town';
    }
    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'social_media',
            [
                'label' => esc_html__( 'Towngov Social Media', 'towngov' ),
            ]
        );
		
		$this->add_control(
			'layout_control',
			[
				'label'   => esc_html__( 'Layout Style', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Style One ', 'towngov'),
					'2' => esc_html__( 'Style Two ', 'towngov'),
					'3' => esc_html__( 'Style Three ', 'towngov'),
				),
			]
		);
		
		$this->add_control(
			'icons',
			[
				'label' => esc_html__('Enter The icons', 'towngov'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle-check',
					'library' => 'solid',
				],
			]
		);
		
		$this->add_control(
			'phone_title',
			[
				'label'       => __( 'Phone Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Phone Title', 'towngov' ),
			]
		);
		$this->add_control(
			'phone_no',
			[
				'label'       => __( 'Phone Number', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Phone Number', 'towngov' ),
			]
		);
		
		$this->add_control(
			'block_title',
			[
				'label'       => __( 'Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'condition' => [ 'layout_control' => '3', ],
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your  Title', 'towngov' ),
			]
		);
		$this->add_control(
			'block_text',
			[
				'label'       => __( 'Text', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'condition' => [ 'layout_control' => '3', ],
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'towngov' ),
			]
		);
		
		//Our Slider		
		$repeater = new Repeater();		
		$repeater->add_control(
			'social_icon',
			[
				'label' => esc_html__('Enter The icons', 'towngov'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa-brands fa-circle-check',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
            'social_link',
			[
				'label' => __( 'Button Url', 'towngov' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'towngov' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);	
		$this->add_control(
			'socail',
			[
				'label'                 => __('Add Social List', 'towngov'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);		
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
	?>
    	
        <?php if($settings['layout_control'] == '3') :?>
                
        <div class="cta-four-content">
            <i class="te-icon-box"><?php \Elementor\Icons_Manager::render_icon( $settings['icons'] ); ?></i>
            <div class="cta-four-content-box">
                <span><?php echo wp_kses($settings['block_title'], true);?></span>
                <p><?php echo wp_kses($settings['block_text'], true);?></p>
            </div>
        </div>                         
         
        <?php elseif($settings['layout_control'] == '2') :?>
                
        <div class="cta-four-content">
            <div class="cta-four-widget-socials">
                <?php foreach( $settings['socail'] as $key => $item ):?> 
                <a href="<?php echo esc_url($item['social_link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_icon'] ); ?></a>
                <?php endforeach; ?>
            </div>
        </div>           
        
        <?php else: ?>
        
        <div class="about-two-author-content author-box">
            <div class="about-two-author-content-box">
                <div class="about-two-author-content-icon">
                    <i class="te-icon-box"><?php \Elementor\Icons_Manager::render_icon( $settings['icons'] ); ?></i>
                </div><!-- about-two-author-content-icon -->
                <div class="about-two-author-content-contact">
                    <h5 class="bn-phone-title"><?php echo wp_kses($settings['phone_title'], true);?></h5>
                    <div class="bn-phone-number"><a href="tel:<?php echo esc_attr($settings['phone_no']); ?>"><?php echo wp_kses($settings['phone_no'], true);?></a></div>
                </div><!-- about-two-author-content-contact -->
            </div><!--about-two-author-content-box-->
            <div class="about-two-author-content-socials">
            	<?php foreach( $settings['socail'] as $key => $item ):?>                
                <a href="<?php echo esc_url($item['social_link']['url']); ?>"><i class="te-icon-box"><?php \Elementor\Icons_Manager::render_icon( $item['social_icon'] ); ?></i></a>   
                <?php endforeach; ?>             
            </div>
        </div>        
        
    <?php endif;
    }
}