<?php namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Stroke;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Newsletter extends Widget_Base {
    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_newsletter';
    }
    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Towngov Newsletter Form', 'towngov' );
    }
    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-icon-box town';
    }
    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'newsletter',
            [
                'label' => esc_html__( 'Towngov Newsletter Form', 'towngov' ),
            ]
        );
		
		$this->add_control(
			'layout_control',
			[
				'label'   => esc_html__( 'Layout Style', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Style One ', 'towngov'),
					'2' => esc_html__( 'Style Two ', 'towngov'),
					'3' => esc_html__( 'Style Three ', 'towngov'),
				),
			]
		);
		
		$this->add_control(
			'mailchimp_form_url',
			[
				'label'       => __( 'Mailchimp Form Url', 'towngov' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'condition' => [ 'layout_control' => ['1', '2', '3'], ],
				'placeholder' => __( 'Enter your Mailchimp Form Url', 'towngov' ),
			]
		);
		
		$this->add_control(
			'form_text',
			[
				'label'       => __( 'Form Description', 'towngov' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'condition' => [ 'layout_control' => '2', ],
				'placeholder' => __( 'Enter your Description', 'towngov' ),
			]
		);
		
		
		$this->end_controls_section();
		
		/**Service Box Style**/
		$this->start_controls_section(
			'general_box_style',
			[
				'label' => esc_html__('Box Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'general_box_tab' );
		
			$this->start_controls_tab(
				'general_box_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'general_box_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-newsletter-box',				
					]
				);
				$this->add_responsive_control(
					'general_box_space',
					[
						'label'              => __( 'Space', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-newsletter-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
							
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_responsive_control(
					'general_box_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-newsletter-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'general_box_border_type',
						'selector' => 
							'{{WRAPPER}} .te-newsletter-box',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'general_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-newsletter-box',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'general_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-newsletter-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'general_box_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'general_hover_bg_bgtype',
						'label' => __( 'Hover Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-newsletter-box:hover',				
					]
				);
				
				$this->add_control(
					'general_background_hover_transition',
					[
						'label' => esc_html__( 'Transition Duration', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'max' => 3,
								'step' => 0.1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-newsletter-box:hover' => 'transition-duration: {{SIZE}}s',
						],
					]
				);
		
				$this->add_control(
					'hover_animation',
					[
						'label' => esc_html__( 'Hover Animation', 'towngov' ),
						'type' => Controls_Manager::HOVER_ANIMATION,
					]
				);
				
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();
		
		/**Icon Box Style**/
		$this->start_controls_section(
			'icon_box_style',
			[
				'label' => esc_html__('Form Button Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'towngov_service_icon_tab' );
		
			$this->start_controls_tab(
				'towngov_service_icon_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'icon_box_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-form-btn'				
					]
				);
				$this->add_control(
					'service_icon_color',
					[
						'label' => __('Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .te-form-btn' => 'color: {{VALUE}}',
							'{{WRAPPER}} .te-form-btn a' => 'color: {{VALUE}}'
						],
						'separator' => 'before',
					]
				);
				
				$this->add_responsive_control(
				'btn_align',
				[
					'label' => esc_html__( 'Alignment', 'towngov' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'towngov' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'towngov' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'towngov' ),
							'icon' => 'eicon-text-align-right',
						],
						'justify' => [
							'title' => esc_html__( 'Justified', 'towngov' ),
							'icon' => 'eicon-text-align-justify',
						],
					],
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .te-form-btn' => 'text-align: {{VALUE}}',
					],
				]
			);
				
				$this->add_responsive_control(
					'icon_width_size',
					[
						'label' => __( 'Width', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-form-btn' => 'width: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_height_size',
					[
						'label' => __( 'Height', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-form-btn' => 'height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_line_height',
					[
						'label' => __( 'Line Height', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-form-btn' => 'line-height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_box_space',
					[
						'label'              => __( 'Space', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-form-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_responsive_control(
					'icon_box_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-form-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'service_icon_border_type',
						'selector' => 
							'{{WRAPPER}} .te-form-btn',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'service_icon_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-form-btn',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'service_icon_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-form-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'towngov_services_icon_box_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'service_icon_hover_bg_bgtype',
						'label' => __( 'Hover Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-form-btn:hover'				
					]
				);
				
				$this->add_control(
					'icon_hover_color',
					[
						'label' => __('Button Text Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .te-form-btn:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .te-form-btn:hover a' => 'color: {{VALUE}}',
						],
						'separator' => 'before',
					]
				);
				
				$this->add_control(
					'service_icon_hover_transition',
					[
						'label' => esc_html__( 'Transition Duration', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'max' => 3,
								'step' => 0.1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-form-btn:hover' => 'transition-duration: {{SIZE}}s'
						],
					]
				);
		
				$this->add_control(
					'icon_hover_animation',
					[
						'label' => esc_html__( 'Hover Animation', 'towngov' ),
						'type' => Controls_Manager::HOVER_ANIMATION,
					]
				);
				
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();	
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		$layout = $settings[ 'layout_control' ];	
	?>
    <?php if($settings['layout_control'] == '3') :?>
    <div class="te-newsletter-box">    
        <div class="cta-two-form">
            <?php echo do_shortcode($settings['mailchimp_form_url']);?>
        </div>
    </div>
    
    <?php elseif($settings['layout_control'] == '2') :?>
    
    <div class="event-details-card-content te-newsletter-box">
        <div class="contact-form">
            <?php echo do_shortcode($settings['mailchimp_form_url']);?>
            <p><?php echo wp_kses($settings['form_text'], true); ?></p>
        </div>
    </div>
    	
	<?php else : ?>
    
    <?php if($settings['mailchimp_form_url']) { ?>
    <div class="te-newsletter-box"> 
        <div class="department-search-form">
            <?php echo do_shortcode($settings['mailchimp_form_url']);?>
        </div>        
    </div>
    <?php } ?>
    <?php endif; ?>
    	
    <?php
    }
}