<?php namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Event_Grid extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_event_grid';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Towngov Event Grid', 'towngov' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open town';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'event_grid',
            [
                'label' => esc_html__( 'Towngov Event Grid', 'towngov' ),
			]
        );
		
		$this->add_control(
			'layout_control',
			[
				'label'   => esc_html__( 'Layout Style', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Style One ', 'towngov'),
					'2' => esc_html__( 'Style Two ', 'towngov'),
					'3' => esc_html__( 'Style Three ', 'towngov'),
				),
			]
		);
		
		$this->add_control(
			'col_grid',
			[
				'label'   => esc_html__( 'Choose Column', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default'  => esc_html__( 'Default', 'towngov' ),
					'one' => esc_html__( 'One Column Grid ', 'towngov'),
					'two'  => esc_html__( 'Two Column Grid', 'towngov' ),
					'three'  => esc_html__( 'Three Column Grid', 'towngov' ),
					'four'  => esc_html__( 'Four Column Grid', 'towngov' )
				),
				'condition' => [
					'layout_control'  => '2'
				] 
			]
		);
		
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'towngov' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'towngov' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'towngov' ),
                    'title'      => esc_html__( 'Title', 'towngov' ),
                    'menu_order' => esc_html__( 'Menu Order', 'towngov' ),
                    'rand'       => esc_html__( 'Random', 'towngov' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'towngov' ),
				'label_block' => true,
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'towngov' ),
                    'ASC'  => esc_html__( 'ASC', 'towngov' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'towngov'),
				'label_block' => true,
                'options' => get_events_categories()
            ]
        );
        $this->end_controls_section();
    }

   	 /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
		$grid_col = $settings[ 'col_grid' ];
		if( $grid_col == 'one' ){
			$classes = 'col-xxl-12 col-xl-12';
		}elseif( $grid_col == 'two' ){
			$classes = 'col-xxl-6 col-xl-6';
		}elseif( $grid_col == 'four' ){
			$classes = 'col-xxl-3 col-xl-3';
		}elseif( $grid_col == 'three' ){
			$classes = 'col-xxl-4 col-xl-4';
		}else{
			$classes = 'col-xxl-4 col-xl-6';
		}

        $paged = towngov_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-towngov' );
        $args = array(
            'post_type'      => 'tribe_events',
            'posts_per_page' => towngov_set( $settings, 'query_number' ),
            'orderby'        => towngov_set( $settings, 'query_orderby' ),
            'order'          => towngov_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if( towngov_set( $settings, 'query_category' ) ) $args['tribe_events_cat'] = towngov_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
		
        if ( $query->have_posts() ) { 
	?>
    
    <?php if($settings['layout_control'] == '3') : ?>
    
    <div class="row row-gutter-y-30">
        <?php 
			while ( $query->have_posts() ) : $query->the_post(); 
			global $post;
			$term_list = wp_get_post_terms(get_the_id(), 'tribe_events_cat', array("fields" => "names"));
			$event_thumbnail_id = get_post_thumbnail_id($post->ID);
			$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id); 
			$start_date = tribe_get_start_date( $post->ID, true, 'd' );
			$start_month = tribe_get_start_date( $post->ID, true, 'M' );
			$start_year = tribe_get_start_date( $post->ID, true, 'y' );
			$end_date = tribe_get_start_date( $post->ID, true, 'd' );
			$start_time = tribe_get_start_time ( $post->ID, 'h:i A' );
			$end_time = tribe_get_end_time ( $post->ID, 'h:i A' );			 
		?>        
        <div class="col-12 col-lg-6 col-xl-6">
            <div class="event-card">
                <div class="event-card-image">
                    <div class="event-card-image-inner">
                        <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><div class="img-fluid"><?php echo (get_the_post_thumbnail($post->ID, 'towngov_250x250')); ?></div></a>		
                        <div class="event-card-meta">
                            <div class="event-meta-number">
                                <span><?php echo wp_kses($start_date, true); ?></span>
                            </div><!-- event-meta-number -->
                            <div class="event-meta-date">
                                <span><?php echo wp_kses($start_month, true); ?> <?php echo wp_kses($start_year, true); ?></span>
                            </div><!-- event-meta-date -->
                        </div><!-- event-card-meta -->
                    </div><!-- event-card-image-inner -->
                </div><!--event-card-image-->
                <div class="event-card-content">
                    <div class="event-card-info">
                        <ul class="list-unstyled">
                            <li>
                                <i class="fa-solid fa-clock"></i>
                                <span><?php echo wp_kses($start_time, true); ?> - <?php echo wp_kses($end_time, true); ?></span>
                            </li><!-- li -->
                            <li>
                                <i class="fa-sharp fa-solid fa-location-pin"></i>
                                <span><?php echo tribe_get_venue( $post->ID ); ?></span>
                            </li><!-- li -->
                        </ul><!-- list-unstyled -->
                    </div><!--event-card-info-->
                    <div class="event-card-title">
                        <h4><a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php the_title();?></a></h4>
                    </div>
                </div>
            </div>
        </div>        
        <?php endwhile; ?> 
    </div>
    
    <?php elseif($settings['layout_control'] == '2') : ?>
    
    <div class="row row-gutter-y-60">
    	<?php 
			while ( $query->have_posts() ) : $query->the_post(); 
			global $post;
			$term_list = wp_get_post_terms(get_the_id(), 'tribe_events_cat', array("fields" => "names"));
			$event_thumbnail_id = get_post_thumbnail_id($post->ID);
			$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id); 
			$start_date = tribe_get_start_date( $post->ID, true, 'd' );
			$start_month = tribe_get_start_date( $post->ID, true, 'M' );
			$start_year = tribe_get_start_date( $post->ID, true, 'Y' );
			$end_date = tribe_get_start_date( $post->ID, true, 'd' );
			$start_time = tribe_get_start_time ( $post->ID, 'h:i A' );
			$end_time = tribe_get_end_time ( $post->ID, 'h:i A' );
		?>
        <div class="<?php echo esc_attr( $classes );?>">
            <div class="event-two-card">
                <div class="event-two-card-image">
                    <div class="event-two-card-image-inner">
                        <a href="<?php echo esc_url(get_permalink( get_the_id() )); ?>"><div class="img-fluid"><?php echo (get_the_post_thumbnail($post->ID, 'towngov_250x250')); ?></div></a>
                        <div class="event-two-card-meta">
                            <div class="event-two-meta-number">
                                <span><?php echo wp_kses($start_date, true); ?></span>
                            </div><!-- event-two-meta-number -->
                            <div class="event-two-meta-date">
                                <span><?php echo wp_kses($start_month, true); ?> <?php echo wp_kses($start_year, true); ?></span>
                            </div><!-- event-two-meta-date -->
                        </div><!-- event-two-card-meta -->
                    </div><!-- event-two-card-image-inner -->
                </div><!--event-two-card-image-->
                <div class="event-two-card-content">
                    <div class="event-card-info">
                        <ul class="list-unstyled">
                            <li>
                                <i class="fa-solid fa-clock"></i>
                                <span><?php echo wp_kses($start_time, true); ?> - <?php echo wp_kses($end_time, true); ?></span>
                            </li><!-- li -->
                            <li>
                                <i class="fa-sharp fa-solid fa-location-pin"></i>
                                <span><?php echo tribe_get_venue( $post->ID ); ?></span>
                            </li><!-- li -->
                        </ul><!-- list-unstyled -->
                    </div><!--event-card-info-->
                    <div class="event-two-card-title">
                        <h4><a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php the_title();?></a></h4>
                    </div><!-- event-two-card-title -->
                </div><!--"event-two-card-content-->
            </div><!--event-two-card-->
        </div><!--col-xxl-4 col-xl-6 -->
        <?php endwhile; ?>   
    </div>
    
    <?php else: ?>
    
    <?php 
		while ( $query->have_posts() ) : $query->the_post(); 
		global $post;
		$term_list = wp_get_post_terms(get_the_id(), 'tribe_events_cat', array("fields" => "names"));
		$event_thumbnail_id = get_post_thumbnail_id($post->ID);
		$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id); 
		$start_date = tribe_get_start_date( $post->ID, true, 'd' );
		$start_month = tribe_get_start_date( $post->ID, true, 'M' );
		$start_year = tribe_get_start_date( $post->ID, true, 'Y' );
		$end_date = tribe_get_start_date( $post->ID, true, 'd' );
		$start_time = tribe_get_start_time ( $post->ID, 'h:i A' );
		$end_time = tribe_get_end_time ( $post->ID, 'h:i A' );
	?>
    <div class="event-card">
        <div class="event-card-image">
            <div class="event-card-image-inner">
                <a href="<?php echo esc_url(get_permalink( get_the_id() )); ?>"><div class="img-fluid"><?php echo (get_the_post_thumbnail($post->ID, 'towngov_250x250')); ?></div></a>
                <div class="event-card-meta">
                    <div class="event-meta-number">
                        <span><?php echo wp_kses($start_date, true); ?></span>
                    </div><!-- event-meta-number -->
                    <div class="event-meta-date">
                        <span><?php echo wp_kses($start_month, true); ?> <?php echo wp_kses($start_year, true); ?></span>
                    </div><!-- event-meta-date -->
                </div><!-- event-card-meta -->
            </div><!-- event-card-image-inner -->
        </div><!--event-card-image-->
        <div class="event-card-content">
            <div class="event-card-info">
                <ul class="list-unstyled">
                    <li>
                        <i class="fa-solid fa-clock"></i>                                               
                        <span><?php echo wp_kses($start_time, true); ?> - <?php echo wp_kses($end_time, true); ?></span>
                    </li><!-- li -->
                    <li>                        
                        <i class="fa-sharp fa-solid fa-location-pin"></i>
                        <span><?php echo tribe_get_venue( $post->ID ); ?></span>
                    </li><!-- li -->
                </ul><!-- list-unstyled -->
            </div><!--event-card-info-->
            <div class="event-card-title">
                <h4><a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php the_title();?></a></h4>
            </div><!-- event-card-title -->
        </div><!--"event-card-content-->
    </div><!--event-card-->
    <?php endwhile; ?>   
    
    <?php endif; ?>    
        <?php }

        wp_reset_postdata();
    }
}
