<?php
namespace TOWNGOVPLUGIN\Element;
class Elementor {
	static $widgets = array(
		//Home Page
		'banner_carousel',
		'newsletter',
		'project_carousel',
		'project_grid',
		'client_section',
		'testimonials',
		'call_widget',
		'social_media',
		'event_grid',
		'call_to_action',
		'button_widget',
		'causes_grid',
		'team',
		'our_blog',
		'service_grid',		
		'department_grid',		
		'form',
		'google_map',
		
		//Rizu
		'hero_title',
		'icon_box',
		'about_image',
		'features',
		'author_box',
		'department_list',
		'counter',
		'float_image',
		'icon_list',
		'causes_grid_v2',
		'animation_image',
		'history_card',
		'documentation_grid'
		
	);
	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}
	static function loader() {
		foreach ( self::$widgets as $widget ) {
			$file = TOWNGOVPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}
			add_action( 'elementor/widgets/register', array( __CLASS__, 'register' ) );
		}
	}
	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\TOWNGOVPLUGIN\\Element\\' . ucwords( $widget );
			if ( class_exists( $class ) ) {
				$elemntor->register( new $class );
			}
		}
	}
	static function register_cats( $elements_manager ) {
		$elements_manager->add_category(
			'towngov',
			[
				'title' => esc_html__( 'Towngov', 'towngov' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'Udayraj', 'towngov' ),
				'icon'  => 'fa fa-plug',
			]
		);
	}
}
Elementor::init();