<?php namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Stroke;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Button_Widget extends Widget_Base {
    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_button_widget';
    }
    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Towngov Button Widget', 'towngov' );
    }
    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-button town';
    }
    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'button_widget',
            [
                'label' => esc_html__( 'Towngov Button Widget', 'towngov' ),
            ]
        );
		
		$this->add_control(
			'btn_style',
			[
				'label'   => esc_html__( 'Choose Button Style', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Style One ', 'towngov'),
					'2' => esc_html__( 'Style Two', 'towngov' ),
				),
			]
		);
		
		$this->add_responsive_control(
			'btn_align',
			[
				'label' => esc_html__( 'Alignment', 'towngov' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'towngov' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'towngov' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'towngov' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'towngov' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .link-btn' => 'text-align: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [ 'btn_style' => ['1', '2', '3', '5', '6'], ],
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'towngov' ),
			]
		);
		
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'towngov' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'condition' => [ 'btn_style' => ['1', '2', '3', '5', '6'], ],
				'placeholder' => __( 'https://your-link.com', 'towngov' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		$this->add_control(
            'show_icon',
            [
                'label'        => esc_html__( 'Show Icon', 'towngov' ),
                'type'         => Controls_Manager::SWITCHER,
				'condition' => [ 'btn_style' => ['1', '2', '3', '4', '6'], ],
                'label_on'     => esc_html__( 'On', 'towngov' ),
                'label_off'    => esc_html__( 'Off', 'towngov' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__('Enter The icons', 'towngov'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [ 'btn_style' => ['1', '2', '3', '4', '6'], ],
				'default' => [
					'value' => 'fas fa-arrow-right',
					'library' => 'solid',
				],
				'condition'   => [ 'show_icon' => 'yes' ]
			]
			
		);
		
		$this->end_controls_section();
		
		/**Button Style**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'towngov_tabs_btn' );
		
			$this->start_controls_tab(
				'towngov_tab_btn_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'btn_bgtype',
						'label' => __( 'Button Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .build-btn',				
					]
				);
				$this->add_responsive_control(
					'btn_width_size',
					[
						'label' => __( 'Width', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .build-btn' => 'width: {{SIZE}}{{UNIT}};',
						],
					]
				);
				$this->add_responsive_control(
					'btn_height_size',
					[
						'label' => __( 'Height', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .build-btn' => 'height: {{SIZE}}{{UNIT}};',
						],
					]
				);
				$this->add_responsive_control(
					'btn_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .build-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'btn_border_type',
						'selector' => 
							'{{WRAPPER}} .build-btn',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'border_box_shadow',
						'selector' => 
							'{{WRAPPER}} .build-btn',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'btn_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .build-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' => 'btn_title_typography',
						'label' => __('Button Text Typography', 'towngov'),
						'selector' => 
							'{{WRAPPER}} .build-btn',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'btn_title_color',
					[
						'label' => __('Button Text Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .build-btn' => 'color: {{VALUE}}',
						],
						'separator' => 'before',
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'towngov_tab_btn_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'btn_hover_bg_bgtype',
						'label' => __( 'Button Hover Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .build-btn:hover',				
					]
				);
				$this->add_control(
					'btn_border_hover_color',
					[
						'label' => __('Button Border Hover Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .build-btn:hover' => 'border-color: {{VALUE}}',
						],
						'separator' => 'before',
					]
				);
				$this->add_control(
					'btn_title_hover_color',
					[
						'label' => __('Button Text Hover Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .build-btn:hover' => 'color: {{VALUE}}',
						],
						'separator' => 'before',
					]
				);
			
			$this->end_controls_tab();			
		$this->end_controls_tabs();   
		$this->end_controls_section();
		
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		$icon = $settings[ 'icon' ];
		$btn_style = $settings[ 'btn_style' ];
	?>
       <?php if($btn_style == '6'): ?>
       <div class="link-btn">
           <ul class="list-2 fs_50 fw_sbold c_light lh_90">
                <li>
                    <a class="build-btn" href="<?php echo esc_url($settings['btn_link']['url']); ?>"><?php echo wp_kses($settings['btn_title'], true); ?> 
                        <?php if( $settings[ 'show_icon' ] === 'yes' ):?>
                            <?php \Elementor\Icons_Manager::render_icon( $icon ); ?>
                        <?php else:?>
                            <i class="flaticon-right-arrow fs_25 ml_25"></i>
                        <?php endif;?>                        
                    </a>
                </li>
            </ul> 
        </div>
        
		<?php elseif($btn_style == '5'): ?>
		<div class="link-btn">
        	<a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="build-btn c_primary td_underline ff_sec fw_bold tt_u fs_14 ls_1"><?php echo wp_kses($settings['btn_title'], true); ?>  </a>
        </div>
        
		<?php elseif($btn_style == '4'): ?>
        <div class="link-btn">
            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="build-btn box-btn-light">
                <?php if( $settings[ 'show_icon' ] === 'yes' ):?>
                    <?php \Elementor\Icons_Manager::render_icon( $icon ); ?>
                <?php else:?>
                    <i class="flaticon-right-1"></i>
                <?php endif;?>            
            </a>
        </div>
        
		<?php elseif($btn_style == '3'): ?>
        
		<?php if($settings['btn_title']) {?>
        <div class="link mb_30"><a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="build-btn ff_sec d-flex align-items-center fw_bold tt_u fs_14 ls_1 lh_20 c_dark">
            <?php if( $settings[ 'show_icon' ] === 'yes' ):?>
				<?php \Elementor\Icons_Manager::render_icon( $icon ); ?>
            <?php else:?>
                <i class="p_relative w_45 h_45 text-center lh_45 b_radius_50 bg_primary c_light mr_20 fs_25 ff_sec d_iblock fs_normal">+</i> 
            <?php endif;?>            
            <span class="d_iblock"><?php echo wp_kses($settings['btn_title'], true); ?></span> </a>
        </div>
        <?php } ?>
		
		<?php elseif($btn_style == '2'): ?>
        <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="build-btn c_light ff_sec fw_bold tt_u fs_14 ls_1 p_relative"><?php echo wp_kses($settings['btn_title'], true); ?> 
        	<?php if( $settings[ 'show_icon' ] === 'yes' ):?>
				<?php \Elementor\Icons_Manager::render_icon( $icon ); ?>
            <?php else:?>
                <i class="ml_10 fs_20 v_middle flaticon-right-1"></i>
            <?php endif;?>            
        </a>
        
        <?php else: ?>
        
        <div class="link-btn">
            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="build-btn btn btn-primary"><?php echo wp_kses($settings['btn_title'], true); ?> </a>             
        </div>
        <?php endif; ?>
    
    <?php
    }
}