<?php namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Banner_Carousel extends Widget_Base {
    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'towngov_banner_carousel';
    }
    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Towngov Banner Slider', 'towngov' );
    }
    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }
    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'towngov' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'banner-carousel', YT_URL . 'assets/js/banner-carousel.js', [ 'elementor-frontend' ], '1.0.0', true );
		return [ 'banner-carousel' ];
	}
	
    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'banner_carousel',
            [
                'label' => esc_html__( 'Towngov Banner Slider', 'towngov' ),
            ]
        );
		$this->add_control(
			'layout_control',
			[
				'label'       => __( 'Template Layout', 'towngov' ),
				'type'        => 'elementor-layout-control',
				'default' => '1',
				'options' => [
					'one' => [
						'label' => esc_html__('Layout 1', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner1.png'
					],
					'two' => [
						'label' => esc_html__('Layout 2', 'towngov' ),
						'image' => get_template_directory_uri() . '/assets/images/redux/layout/banner/banner2.png'
					],
				],
			]
		);
		//Our Slider		
		$repeater = new Repeater();		
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__('Slider Image ', 'towngov'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'towngov' ),
			]
		);
		$repeater->add_control(
			'title',
			[
				'label'       => __( 'Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'towngov' ),
			]
		);
		$repeater->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'towngov' ),
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => esc_html__('Button Url', 'towngov'),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'slides',
			[
				'label'                 => __('Add Slide Item', 'towngov'),
				'type'                  => Controls_Manager::REPEATER,
				'fields'                => $repeater->get_controls(),
			]
		);		
		$this->end_controls_section();
		
		/** Style Tab **/
		$this->register_style_background_controls();
    }
	
	/************************************************************************
								Tab Style Start
	*************************************************************************/
	
	protected function register_style_background_controls()
	{
		
		/**Sub Title Style**/
		$this->start_controls_section(
			'sub_title_style',
			[
				'label' => esc_html__('SUB TITLE STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_sub_title_style',
			[
				'label'       => __( 'ON/OFF Sub Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .slider-tagline,
								 .slider-tagline-two',                 
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .slider-tagline' => 'color: {{VALUE}}',
					'{{WRAPPER}} .slider-tagline-two' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_sub_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
		
		/**Title Style**/
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('TITLE STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_title_style',
			[
				'label'       => __( 'ON/OFF  Title Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'towngov'),
                'selector' => 
                    '{{WRAPPER}} .slider-content .section-title,
								 .slider-content-two .section-title',                 
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .slider-content .section-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .slider-content-two .section-title' => 'color: {{VALUE}}'
                ],
                'separator' => 'before',
				'condition'             => [
					'show_title_style'    => 'yes',
				]
            ]
        );
		$this->end_controls_section();
				
		
		/**Button Style One**/
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('BUTTON STYLE SETTING', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'show_btn_style',
			[
				'label'       => __( 'ON/OFF Button Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->add_control(
			'yt_btn_background',
			[
				'label'                 => __( 'Button Background', 'towngov' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bgtype',
				'label' => __( 'Button Background', 'towngov' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn.btn-primary',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'hover_background',
			[
				'label'                 => __( 'Button Hover Background', 'towngov' ),
				'type'                  => Controls_Manager::HEADING,
				'separator'             => 'before',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg_bgtype',
				'label' => __( 'Button Hover Background', 'towngov' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => 
					'{{WRAPPER}} .btn.btn-primary:hover',				
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
			'show_border_radius',
			[
				'label'       => __( 'ON/OFF Button Radius Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'towngov'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .btn.btn-primary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition'             => [
					'show_border_radius'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_border_type',
			[
				'label'       => __( 'ON/OFF Border Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_type',
                'selector' => 
					'{{WRAPPER}} .btn.btn-primary',				
				'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_border_hover_color',
            [
                'label' => __('Button Border Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn.btn-primary:hover' => 'border-color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_border_type'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_box_shadow',
			[
				'label'       => __( 'ON/OFF Box Shadow Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'border_box_shadow',
                'selector' => 
					'{{WRAPPER}} .btn.btn-primary',				
				'separator' => 'before',
				'condition'             => [
					'show_box_shadow'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_btn_padding',
			[
				'label'       => __( 'ON/OFF Padding Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_responsive_control(
            'btn_padding',
            [
                'label'              => __( 'Padding', 'towngov' ),
                'type'               => Controls_Manager::DIMENSIONS,
                'size_units'         => [ 'px', 'em', '%' ],
                'selectors'          => [
                    '{{WRAPPER}} .btn.btn-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
				
                'frontend_available' => true,
				'condition'             => [
					'show_btn_padding'    => 'yes',
				]
            ]
        );
		$this->add_control(
			'show_typo_color',
			[
				'label'       => __( 'ON/OFF Typography and Color Style', 'towngov' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'towngov' ),
				'label_off' => esc_html__( 'Hide', 'towngov' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition'             => [
					'show_btn_style'    => 'yes',
				]
			]
		);
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_title_typography',
                'label' => __('Button Text Typography', 'towngov'),
                'selector' => 
					'{{WRAPPER}} .btn.btn-primary',				
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_color',
            [
                'label' => __('Button Text Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn.btn-primary' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );
		$this->add_control(
            'btn_title_hover_color',
            [
                'label' => __('Button Text Hover Color', 'towngov'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .btn.btn-primary:hover' => 'color: {{VALUE}}!important',
                ],
                'separator' => 'before',
				'condition'             => [
					'show_typo_color'    => 'yes',
				]
            ]
        );		
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
	?>
    
   <?php if($settings['layout_control'] == 'two') : ?>
   
   <section class="main-slider main-slider-two">
        <div class="main-slider-two-swiper owl-carousel owl-theme">
            <?php foreach($settings['slides'] as $key => $item):?>
            <div class="item">
                <?php if($item['image']){ ?>
                <div class="item-slider-bg" style="background-image: url(<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>)"></div>
                <?php } ?>
                <div class="container">
                    <div class="row">
                        <div class="col-12 col-md-12 col-lg-12">
                            <div class="slider-content-two text-center">
                                <div class="slider-tagline-two"><?php echo wp_kses($item['sub_title'], true);?></div>
                                <h1 class="section-title"><?php echo wp_kses($item['title'], true);?></h1>
                                <?php if($item['btn_title']){ ?>
                                <a href="<?php echo esc_url($item['btn_link']['url']);?>" class="btn btn-primary"><?php echo wp_kses($item['btn_title'], true);?></a>
                                <?php } ?>
                            </div><!-- slider-content-two -->
                        </div><!-- col-12 col-md-12 col-lg-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div><!--item-->
            <?php endforeach; ?>
        </div><!-- main-slider-two-swiper -->
   </section><!--main-slider-->
   
   <?php else: ?>
   
   <section class="main-slider">
		<div class="main-slider-swiper owl-carousel owl-theme">
			<?php foreach($settings['slides'] as $key => $item):?>
            <div class="item">
				<?php if($item['image']){ ?>
                <div class="item-slider-bg"  style="background-image: url(<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>)"></div>
                <?php } ?>
				<div class="container">
					<div class="row">
						<div class="col-md-12">
							<div class="slider-content">
								<div class="slider-tagline"><?php echo wp_kses($item['sub_title'], true);?></div>
								<h1 class="section-title"><?php echo wp_kses($item['title'], true);?></h1>
								<?php if($item['btn_title']){ ?>
                                <a href="<?php echo esc_url($item['btn_link']['url']);?>" class="btn btn-primary"><?php echo wp_kses($item['btn_title'], true);?></a>
                                <?php } ?>
							</div><!-- slider-content -->
						</div><!-- col-md-12 -->
					</div><!-- row -->
				</div><!-- container -->
			</div><!--item-->
			<?php endforeach; ?>
		</div><!-- main-slider-swiper -->
	</section><!--main-slider-->
    
    <?php endif; ?>
      <?php
    }
}