<?php
namespace TOWNGOVPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Image extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'towngov_about_image';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Towngov About Image', 'towngov' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-image-rollover town';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'towngov' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'about_image',
			[
				'label' => esc_html__( 'Towngov About Image', 'towngov' ),
			]
		);
		
		$this->add_control(
			'layout_control',
			[
				'label'   => esc_html__( 'Layout Style', 'towngov' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Style One ', 'towngov'),
					'2' => esc_html__( 'Style Two ', 'towngov'),
					'3' => esc_html__( 'Style Three ', 'towngov'),
					'4' => esc_html__( 'Style Four ', 'towngov'),
					'5' => esc_html__( 'Style Five ', 'towngov'),
				),
			]
		);
		
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'towngov' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [ 'layout_control' => ['1', '5'], ],
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->add_control(
			'image1',
			[
				'label' => esc_html__( 'Choose Image', 'towngov' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [ 'layout_control' => ['3', '4'], ],
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' => 'large',
				'separator' => 'none',
				'condition' => [ 'layout_control' => '1', ],
			]
		);
		
		$this->add_control(
			'video_link',
			[
				'label' => __( 'Video Link', 'towngov' ),
				'type' => Controls_Manager::URL,
				'condition' => [ 'layout_control' => '3', ],
				'label_block' => true, 
				'placeholder' => __( 'youtube link here', 'towngov' ),
				'show_external' => true,
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__('Enter The icons', 'towngov'),
				'condition' => [ 'layout_control' => '2', ],
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'flaticon-envelope',
					'library' => 'flaticon',
				],
			]
			
		);
		
		$this->add_control(
			'shape_image',
			[
			  	'label' => __( 'Pattern Image', 'towngov' ),
			  	'type' => Controls_Manager::MEDIA,
				'condition' => [ 'layout_control' => ['1', '2', '3', '4'], ],
			  	'label_block' => true,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		
		$this->add_control(
			'image2',
			[
				'label' => esc_html__( 'Choose Image', 'towngov' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [ 'layout_control' => ['1', '3'], ],
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image3',
			[
				'label' => esc_html__( 'Choose Image', 'towngov' ),
				'type' => Controls_Manager::MEDIA,
				'condition' => [ 'layout_control' => '3', ],
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'mark',
			[
				'label'       => __( 'Signature Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'condition' => [ 'layout_control' => '1', ],
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Signature Title Here', 'towngov' ),
			]
		);
		
		$this->add_control(		
			 'number',
			[
				'label'       => __( 'Counter Value', 'towngov' ),				
                'type'        => Controls_Manager::TEXTAREA,
				'condition' => [ 'layout_control' => '1', ],				
				'dynamic'     => [				
					'active' => true,
				],				
				'placeholder' => __( 'Enter Your Counter Value', 'towngov' ),
			]
		);
		
		$this->add_control(		
			 'experience',
			[
				'label'       => __( 'Experience Title', 'towngov' ),				
                'type'        => Controls_Manager::TEXTAREA,
				'condition' => [ 'layout_control' => '1', ],				
				'dynamic'     => [				
					'active' => true,
				],				
				'placeholder' => __( 'Enter your experience title', 'towngov' ),
			]
		);
		
		$this->add_control(
			'box_title',
			[
				'label'       => __( 'Title', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'condition' => [ 'layout_control' => ['2', '3'], ],
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Title Here', 'towngov' ),
			]
		);
		
		$this->add_control(
			'box_text',
			[
				'label'       => __( 'Description', 'towngov' ),
				'type'        => Controls_Manager::TEXT,
				'condition' => [ 'layout_control' => '2', ],
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description Here', 'towngov' ),
			]
		);
		
		$this->end_controls_section();
		
		/************************************************************************
								Tab Style Start
		*************************************************************************/
		
		$this->start_controls_section(
			'section_style_image',
			[
				'label' => esc_html__( 'Image Setting', 'towngov' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [ 'layout_control' => ['1', '5'], ],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'towngov' ),
				'type' => Controls_Manager::CHOOSE,
				'condition' => [ 'layout_control' => ['1', '5'], ],
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'towngov' ),
						'icon' => 'eicon-text-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'towngov' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'float: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'width',
			[
				'label' => esc_html__( 'Width', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'condition' => [ 'layout_control' => ['1', '5'], ],
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'space',
			[
				'label' => esc_html__( 'Max Width', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'condition' => [ 'layout_control' => ['1', '5'], ],
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label' => esc_html__( 'Height', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'condition' => [ 'layout_control' => ['1', '5'], ],
				'default' => [
					'unit' => 'px',
				],
				'tablet_default' => [
					'unit' => 'px',
				],
				'mobile_default' => [
					'unit' => 'px',
				],
				'size_units' => [ 'px', 'vh' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 500,
					],
					'vh' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'object-fit',
			[
				'label' => esc_html__( 'Object Fit', 'towngov' ),
				'condition' => [ 'layout_control' => ['1', '5'], ],
				'type' => Controls_Manager::SELECT,
				'condition' => [
					'height[size]!' => '',
				],
				'options' => [
					'' => esc_html__( 'Default', 'towngov' ),
					'fill' => esc_html__( 'Fill', 'towngov' ),
					'cover' => esc_html__( 'Cover', 'towngov' ),
					'contain' => esc_html__( 'Contain', 'towngov' ),
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} img' => 'object-fit: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'separator_panel_style',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
				'condition' => [ 'layout_control' => ['1', '5'], ],
			]
		);

		$this->start_controls_tabs( 'image_effects' );

		$this->start_controls_tab( 'normal',
			[
				'label' => esc_html__( 'Normal', 'towngov' ),
				'condition' => [ 'layout_control' => ['1', '5'], ],
			]
		);

		$this->add_control(
			'opacity',
			[
				'label' => esc_html__( 'Opacity', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}} img',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'hover',
			[
				'label' => esc_html__( 'Hover', 'towngov' ),
			]
		);

		$this->add_control(
			'opacity_hover',
			[
				'label' => esc_html__( 'Opacity', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}}:hover img' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters_hover',
				'selector' => '{{WRAPPER}}:hover img',
			]
		);

		$this->add_control(
			'background_hover_transition',
			[
				'label' => esc_html__( 'Transition Duration', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 3,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'transition-duration: {{SIZE}}s',
				],
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'towngov' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} img',
				'separator' => 'before',
				'condition' => [ 'layout_control' => ['1', '5'], ],
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'towngov' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'image_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} img',
			]
		);

		$this->end_controls_section();
		
		/**Video Icon Style**/
		$this->start_controls_section(
			'caption_box_style',
			[
				'label' => esc_html__('Caption Box Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [ 'layout_control' => '1', ],
			]
		);
		
		$this->add_control(
			'caption_position',
			[
				'label' => esc_html__( 'Position', 'towngov' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'Default', 'towngov' ),
					'absolute' => esc_html__( 'Absolute', 'towngov' ),
					'fixed' => esc_html__( 'Fixed', 'towngov' ),
				],
				'selectors' => [
					'{{WRAPPER}} .te-caption-box' => 'position: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'caption_offset_orientation_h',
			[
				'label' => esc_html__( 'Horizontal Orientation', 'towngov' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'end',
				'options' => [
					'start' => [
						'title' => 'left',
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => 'right',
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'towngov-control-start-end',
				'render_type' => 'ui',
				'condition' => [
					'caption_position!' => '',
				],
			]
		);
		
		$this->add_responsive_control(
			'caption_offset_x',
			[
				'label' => esc_html__( 'Offset', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .te-caption-box' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'caption_offset_orientation_h!' => 'end',
					'caption_position!' => '',
				],
			]
		);
		
		$this->add_responsive_control(
			'caption_offset_x_end',
			[
				'label' => esc_html__( 'Offset', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .te-caption-box' => 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'caption_offset_orientation_h' => 'end',
					'caption_position!' => '',
				],
			]
		);
		
		$this->add_control(
			'caption_offset_orientation_v',
			[
				'label' => esc_html__( 'Vertical Orientation', 'towngov' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'towngov' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'towngov' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
				'condition' => [
					'caption_position!' => '',
				],
			]
		);

		$this->add_responsive_control(
			'caption_offset_y',
			[
				'label' => esc_html__( 'Offset', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw', 'custom' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .te-caption-box' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'caption_offset_orientation_v!' => 'end',
					'caption_position!' => '',
				],
			]
		);

		$this->add_responsive_control(
			'caption_offset_y_end',
			[
				'label' => esc_html__( 'Offset', 'towngov' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw', 'custom' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .te-caption-box' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'caption_offset_orientation_v' => 'end',
					'caption_position!' => '',
				],
			]
		);

		$this->add_responsive_control(
			'_z_index',
			[
				'label' => esc_html__( 'Z-Index', 'towngov' ),
				'type' => Controls_Manager::NUMBER,
				'selectors' => [
					'{{WRAPPER}} .te-caption-box' => 'z-index: {{VALUE}};',
				],
			]
		);
		
		$this->start_controls_tabs( 'towngov_tabs_btn' );
	
			$this->start_controls_tab(
				'towngov_tab_btn_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
					'condition' => [ 'layout_control' => '1', ],
				]
			);
				//background
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'caption_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-caption-box',				
					]
				);
				
				$this->add_responsive_control(
					'caption_box_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-caption-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				
				//border
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'caption_border_type',
						'selector' => 
							'{{WRAPPER}} .about-image-caption-inner',				
						'separator' => 'before',
					]
				);
				
				//border
				$this->add_control(
					'caption_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-caption-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				
				//box shadow
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'border_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-caption-box',				
						'separator' => 'before',
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'towngov_tab_btn_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				//background
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'caption_hover_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-caption-box:hover',				
					]
				);
				
				//border
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'caption_hover_border_type',
						'selector' => 
							'{{WRAPPER}} .about-image-caption-inner:hover',				
						'separator' => 'before',
					]
				);
			
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		
		$this->end_controls_section();
		
		/**Icon Box Style**/
		$this->start_controls_section(
			'icon_box_style',
			[
				'label' => esc_html__('Icon Setting', 'towngov'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [ 'layout_control' => '2', ],
			]
		);
		$this->start_controls_tabs( 'towngov_service_icon_tab' );
		
			$this->start_controls_tab(
				'towngov_service_icon_normal',
				[
					'label' => __( 'Normal', 'towngov' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'icon_box_bgtype',
						'label' => __( 'Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-icon-box'				
					]
				);
				$this->add_control(
					'service_icon_color',
					[
						'label' => __('Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'color: {{VALUE}}',
							'{{WRAPPER}} .te-icon-box a' => 'color: {{VALUE}}'
						],
						'separator' => 'before',
					]
				);
				$this->add_responsive_control(
					'icon_width_size',
					[
						'label' => __( 'Width', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'width: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_height_size',
					[
						'label' => __( 'Height', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_line_height',
					[
						'label' => __( 'Line Height', 'cleanex' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', 'em', '%', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 500,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'line-height: {{SIZE}}{{UNIT}};'
						],
					]
				);
				$this->add_responsive_control(
					'icon_box_space',
					[
						'label'              => __( 'Space', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-icon-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_responsive_control(
					'icon_box_padding',
					[
						'label'              => __( 'Padding', 'towngov' ),
						'type'               => Controls_Manager::DIMENSIONS,
						'size_units'         => [ 'px', 'em', '%' ],
						'selectors'          => [
							'{{WRAPPER}} .te-icon-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
						
						'frontend_available' => true,
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'service_icon_border_type',
						'selector' => 
							'{{WRAPPER}} .te-icon-box',				
						'separator' => 'before',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'service_icon_box_shadow',
						'selector' => 
							'{{WRAPPER}} .te-icon-box',				
						'separator' => 'before',
					]
				);
				$this->add_control(
					'service_icon_border_radius',
					[
						'label' => esc_html__('Border Radius', 'towngov'),
						'type' => Controls_Manager::DIMENSIONS,
						'separator' => 'before',
						'size_units' => ['px'],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]
				);
			$this->end_controls_tab();
			
			$this->start_controls_tab(
				'towngov_services_icon_box_hover',
				[
					'label' => __( 'Hover', 'towngov' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'service_icon_hover_bg_bgtype',
						'label' => __( 'Hover Background', 'towngov' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => 
							'{{WRAPPER}} .te-icon-box:hover'				
					]
				);
				
				$this->add_control(
					'icon_hover_color',
					[
						'label' => __('Button Text Color', 'towngov'),
						'type' => Controls_Manager::COLOR,
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .te-icon-box:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .te-icon-box:hover a' => 'color: {{VALUE}}',
						],
						'separator' => 'before',
					]
				);
				
				$this->add_control(
					'service_icon_hover_transition',
					[
						'label' => esc_html__( 'Transition Duration', 'towngov' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'max' => 3,
								'step' => 0.1,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .te-icon-box:hover' => 'transition-duration: {{SIZE}}s'
						],
					]
				);
		
				$this->add_control(
					'icon_hover_animation',
					[
						'label' => esc_html__( 'Hover Animation', 'towngov' ),
						'type' => Controls_Manager::HOVER_ANIMATION,
					]
				);
				
			$this->end_controls_tab();
			
		$this->end_controls_tabs();   
		$this->end_controls_section();
		
		
		//Title Style
		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title Setting', 'towngov' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'towngov' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-title' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Typography', 'towngov'),
				'selector' => 
					'{{WRAPPER}} .te-title'
			]
		);
		
		$this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__( 'Title Color', 'towngov' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-title:hover' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => 
					'{{WRAPPER}} .te-title',
			]
		);

		$this->end_controls_section();
		
		//Content Style
		$this->start_controls_section(
			'counter_style',
			[
				'label' => esc_html__( 'Counter Setting', 'towngov' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'counter_space',
			[
				'label' => __( 'Spacing', 'cleanex' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .te-counter' => 'margin-right: {{SIZE}}{{UNIT}};'
				],
			]
		);
		
		$this->add_control(
			'counter_color',
			[
				'label' => esc_html__( 'Title Color', 'towngov' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-counter' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'counter_typography',
				'label' => __('Typography', 'towngov'),
				'selector' => 
					'{{WRAPPER}} .te-counter'
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'counter_text_shadow',
				'selector' => 
					'{{WRAPPER}} .te-counter',
			]
		);

		$this->end_controls_section();
		
		//Title Style
		$this->start_controls_section(
			'text_style',
			[
				'label' => esc_html__( 'Content Setting', 'towngov' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Title Color', 'towngov' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .te-text' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __('Typography', 'towngov'),
				'selector' => 
					'{{WRAPPER}} .te-text'
			]
		);
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_text_shadow',
				'selector' => 
					'{{WRAPPER}} .te-text',
			]
		);

		$this->end_controls_section();
		
	}
	/**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); 
		$video_link = $settings[ 'video_link' ];
		$icon = $settings[ 'icon' ];
		$mark = $settings[ 'mark' ];
		$number = $settings[ 'number' ];
		$experience = $settings[ 'experience' ];
	?>
		
        <?php if($settings['layout_control'] == '5') : ?>
			<div class="history-card-image">
                <img src="<?php echo esc_url( wp_get_attachment_url( $settings['image']['id'] ) );?>" alt="<?php esc_attr_e( 'img-25', 'towngov' );?>" class="img-fluid">
            </div><!-- history-card-image -->
		<?php elseif($settings['layout_control'] == '4') : ?>
        
        <div class="about-one-image">
            <img src="<?php echo esc_url( wp_get_attachment_url( $settings['shape_image']['id'] ) );?>" alt="<?php esc_attr_e( 'img-32', 'towngov' );?>" class="floated-image-one">
            <img src="<?php echo esc_url( wp_get_attachment_url( $settings['image1']['id'] ) );?>" alt="<?php esc_attr_e( 'img-30', 'towngov' );?>" class="img-fluid">
        </div>
		
		<?php elseif($settings['layout_control'] == '3') : ?>
        
        <div class="about-two-image">
            <div class="about-two-image-inner img-one">
                <img src="<?php echo esc_url( wp_get_attachment_url( $settings['image1']['id'] ) );?>" alt="<?php esc_attr_e( 'img-30', 'towngov' );?>">
                <img src="<?php echo esc_url( wp_get_attachment_url( $settings['image2']['id'] ) );?>" class="floated-image" alt="<?php esc_attr_e( 'img-31', 'towngov' );?>">
                <?php if($settings['box_title']){?><div class="sign-text te-title"><?php echo wp_kses($settings['box_title'], true); ?></div><?php };?>
            </div><!-- about-two-image-inner -->
            <div class="about-two-image-inner img-two">
                <img src="<?php echo esc_url( wp_get_attachment_url( $settings['shape_image']['id'] ) );?>" alt="<?php esc_attr_e( 'img-32', 'towngov' );?>" class="mayor-image">
                <img src="<?php echo esc_url( wp_get_attachment_url( $settings['image3']['id'] ) );?>" alt="<?php esc_attr_e( 'img-33', 'towngov' );?>">
            </div><!-- about-two-image-inner img-two -->
            <?php if( $video_link['url'] ){?>
            <div class="about-two-service-video">
                <a href="<?php echo esc_url( $video_link['url'] );?>" class="video-popup">
                    <i class="fa fa-play"></i>
                </a><!-- video-popup -->
            </div><!-- about-two-service-video -->
            <?php };?>            
        </div><!--about-two-image-->
        
		<?php elseif($settings['layout_control'] == '2') : ?>
        
        <div class="event-details-card-title" style="background-image:url('<?php echo esc_url( wp_get_attachment_url( $settings['shape_image']['id'] ) );?>');">
            <div class="event-icon te-icon-box">
                <?php \Elementor\Icons_Manager::render_icon( $icon ); ?>
            </div>
            <?php if($settings['box_title']){?><h5 class="te-title"><?php echo wp_kses($settings['box_title'], true); ?></h5><?php };?>
            <?php if($settings['box_text']){?><p class="te-text"><?php echo wp_kses($settings['box_text'], true); ?></p><?php };?>
        </div>
        
        <?php else : ?>
        
        <div class="about-image">
            <div class="about-image-inner img-one">
                <?php if($settings['image']['id']){ ?>
                    <?php Group_Control_Image_Size::print_attachment_image_html( $settings ); ?>
                <?php } ?>
                
                <?php if( $mark ){?><div class="sign-text te-title"><?php echo wp_kses( $mark, true );?></div><?php };?>
                
                <?php if( $number || $experience ){?>
                <div class="about-image-caption te-caption-box">
                    <div class="about-image-caption-inner">
                        <?php if( $number ){?><span class="about-caption-number te-counter"><?php echo wp_kses( $number, true );?></span><?php };?>
                        <?php if( $experience ){?><span class="about-caption-text te-text"><?php echo wp_kses( $experience, true );?></span><?php };?>
                    </div>
                </div>
                <?php };?>
                
            </div><!--about-image-inner img-one-->
            
            <?php if($settings['image2']['id'] || $settings['shape_image']['id']){ ?>
            <div class="about-image-inner img-two">
                <?php if($settings['shape_image']['id']){ ?><img src="<?php echo esc_url( wp_get_attachment_url( $settings['shape_image']['id'] ) );?>" class="floated-image" alt="<?php esc_attr_e( 'img-3', 'towngov' );?>"><?php } ?>
                <?php if($settings['image2']['id']){ ?><img src="<?php echo esc_url( wp_get_attachment_url( $settings['image2']['id'] ) );?>" class="img-fluid" alt="<?php esc_attr_e( 'img-4', 'towngov' );?>"><?php } ?>
            </div><!--about-image-inner img-two-->
            <?php } ?>
            
        </div>
    <?php endif; ?>
    <?php
	}
}